/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.codeassist.strategies;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.statements.Statement;
import org.eclipse.dltk.compiler.env.IModuleSource;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.core.index2.search.ISearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.SourceRange;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.php.core.codeassist.ICompletionContext;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.Logger;
import org.eclipse.php.internal.core.PHPCorePlugin;
import org.eclipse.php.internal.core.codeassist.AliasType;
import org.eclipse.php.internal.core.codeassist.CodeAssistUtils;
import org.eclipse.php.internal.core.codeassist.ICompletionReporter;
import org.eclipse.php.internal.core.codeassist.contexts.AbstractCompletionContext;
import org.eclipse.php.internal.core.codeassist.strategies.GlobalElementStrategy;
import org.eclipse.php.internal.core.compiler.ast.nodes.UsePart;
import org.eclipse.php.internal.core.compiler.ast.nodes.UseStatement;
import org.eclipse.php.internal.core.model.PhpModelAccess;
import org.eclipse.php.internal.core.typeinference.FakeMethod;
import org.eclipse.php.internal.core.typeinference.PHPModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalTypesStrategy
extends GlobalElementStrategy {
    protected final int trueFlag;
    protected final int falseFlag;
    protected static final IType[] EMPTY = new IType[0];
    private boolean aliasAdded = false;

    public GlobalTypesStrategy(ICompletionContext context, int trueFlag, int falseFlag) {
        super(context, null);
        this.trueFlag = trueFlag;
        this.falseFlag = falseFlag;
    }

    public GlobalTypesStrategy(ICompletionContext context) {
        this(context, 0, 0);
    }

    @Override
    public SourceRange getReplacementRange(ICompletionContext context) throws BadLocationException {
        SourceRange replacementRange = super.getReplacementRange(context);
        boolean insertMode = this.isInsertMode();
        if (replacementRange.getLength() > 0 && insertMode) {
            return new SourceRange(replacementRange.getOffset(), replacementRange.getLength() - 1);
        }
        return replacementRange;
    }

    @Override
    public void apply(ICompletionReporter reporter) throws BadLocationException {
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        SourceRange replacementRange = this.getReplacementRange(abstractContext);
        IType[] types = this.getTypes(abstractContext);
        String suffix = "";
        String nsSuffix = this.getNSSuffix(abstractContext);
        IType[] iTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IType type = iTypeArray[n2];
            try {
                int flags = type.getFlags();
                reporter.reportType(type, PHPFlags.isNamespace(flags) ? nsSuffix : suffix, replacementRange, this.getExtraInfo());
            }
            catch (ModelException e) {
                PHPCorePlugin.log(e);
            }
            ++n2;
        }
        this.addAlias(reporter, suffix);
    }

    protected void addAlias(ICompletionReporter reporter, String suffix) throws BadLocationException {
        String prefix;
        if (this.aliasAdded) {
            return;
        }
        this.aliasAdded = true;
        ICompletionContext context = this.getContext();
        AbstractCompletionContext abstractContext = (AbstractCompletionContext)context;
        if (!abstractContext.getCompletionRequestor().isContextInformationMode() && (prefix = abstractContext.getPrefixWithoutProcessing()).indexOf(92) < 0) {
            IModuleSource module = reporter.getModule();
            ISourceModule sourceModule = (ISourceModule)module.getModelElement();
            ModuleDeclaration moduleDeclaration = SourceParserUtil.getModuleDeclaration((ISourceModule)sourceModule);
            int offset = abstractContext.getOffset();
            IType namespace = PHPModelUtils.getCurrentNamespace(sourceModule, offset);
            Map<String, UsePart> result = this.getAliasToNSMap(prefix, moduleDeclaration, offset, namespace);
            this.reportAlias(reporter, suffix, abstractContext, module, result);
        }
    }

    protected void reportAliasForNS(ICompletionReporter reporter, String suffix, AbstractCompletionContext abstractContext, IModuleSource module, Map<String, UsePart> result) throws BadLocationException {
        SourceRange replacementRange = this.getReplacementRange(abstractContext);
        IDLTKSearchScope scope = this.createSearchScope();
        for (String name : result.keySet()) {
            String fullName = result.get(name).getNamespace().getFullyQualifiedName();
            IType[] elements = PhpModelAccess.getDefault().findTypes(null, String.valueOf(fullName) + '\\', ISearchEngine.MatchRule.PREFIX, 0, 0, scope, null);
            int i = 0;
            while (i < elements.length) {
                String elementName = elements[i].getElementName();
                this.reportAlias(reporter, scope, module, replacementRange, elements[i], elementName, elementName.replace(fullName, name), suffix);
                ++i;
            }
        }
    }

    protected void reportAlias(ICompletionReporter reporter, String suffix, AbstractCompletionContext abstractContext, IModuleSource module, Map<String, UsePart> result) throws BadLocationException {
        SourceRange replacementRange = this.getReplacementRange(abstractContext);
        IDLTKSearchScope scope = this.createSearchScope();
        for (String name : result.keySet()) {
            String fullName = result.get(name).getNamespace().getFullyQualifiedName();
            IType[] elements = PhpModelAccess.getDefault().findTypes(fullName, ISearchEngine.MatchRule.EXACT, 0, 0, scope, null);
            try {
                int i = 0;
                while (i < elements.length) {
                    if (!PHPFlags.isNamespace(elements[i].getFlags())) {
                        this.reportAlias(reporter, scope, module, replacementRange, elements[i], fullName, name, suffix);
                    } else {
                        IType[] typesOfNS = elements[i].getTypes();
                        int j = 0;
                        while (j < typesOfNS.length) {
                            ++j;
                        }
                    }
                    ++i;
                }
            }
            catch (ModelException e) {
                e.printStackTrace();
            }
        }
    }

    private Map<String, UsePart> getAliasToNSMap(final String prefix, ModuleDeclaration moduleDeclaration, final int offset, IType namespace) {
        final HashMap<String, UsePart> result = new HashMap<String, UsePart>();
        try {
            int start = 0;
            if (namespace != null) {
                start = namespace.getSourceRange().getOffset();
            }
            final int searchStart = start;
            moduleDeclaration.traverse(new ASTVisitor(){

                public boolean visit(Statement s) throws Exception {
                    if (s instanceof UseStatement) {
                        UseStatement useStatement = (UseStatement)s;
                        for (UsePart usePart : useStatement.getParts()) {
                            String name;
                            if (usePart.getAlias() != null && usePart.getAlias().getName() != null) {
                                name = usePart.getAlias().getName();
                                if (!name.startsWith(prefix)) continue;
                                result.put(name, usePart);
                                continue;
                            }
                            name = usePart.getNamespace().getFullyQualifiedName();
                            int index = name.lastIndexOf(92);
                            if (index >= 0) {
                                name = name.substring(index + 1);
                            }
                            if (!name.startsWith(prefix)) continue;
                            result.put(name, usePart);
                        }
                    }
                    return this.visitGeneral((ASTNode)s);
                }

                public boolean visitGeneral(ASTNode node) throws Exception {
                    if (node.sourceStart() > offset || node.sourceEnd() < searchStart) {
                        return false;
                    }
                    return super.visitGeneral(node);
                }
            });
        }
        catch (Exception e) {
            Logger.logException(e);
        }
        return result;
    }

    protected void reportAlias(ICompletionReporter reporter, IDLTKSearchScope scope, IModuleSource module, SourceRange replacementRange, IType type, String fullName, String alias, String suffix) {
        reporter.reportType((IType)new AliasType((ModelElement)type, fullName, alias), suffix, replacementRange, this.getExtraInfo());
    }

    protected IType[] getTypes(AbstractCompletionContext context) throws BadLocationException {
        IType[] types;
        String prefix = context.getPrefix();
        if (prefix.startsWith("$")) {
            return EMPTY;
        }
        IDLTKSearchScope scope = this.createSearchScope();
        if (context.getCompletionRequestor().isContextInformationMode()) {
            return PhpModelAccess.getDefault().findTypes(prefix, ISearchEngine.MatchRule.EXACT, this.trueFlag, this.falseFlag, scope, null);
        }
        LinkedList<IType> result = new LinkedList<IType>();
        if (prefix.length() > 1 && prefix.toUpperCase().equals(prefix)) {
            types = PhpModelAccess.getDefault().findTypes(prefix, ISearchEngine.MatchRule.CAMEL_CASE, this.trueFlag, this.falseFlag, scope, null);
            result.addAll(Arrays.asList(types));
        }
        types = PhpModelAccess.getDefault().findTypes(null, prefix, ISearchEngine.MatchRule.PREFIX, this.trueFlag, this.falseFlag, scope, null);
        result.addAll(Arrays.asList(types));
        return result.toArray(new IType[result.size()]);
    }

    protected void addSelf(AbstractCompletionContext context, ICompletionReporter reporter) throws BadLocationException {
        String prefix = context.getPrefix();
        SourceRange replaceRange = this.getReplacementRange(context);
        if (CodeAssistUtils.startsWithIgnoreCase("self", prefix) && (!context.getCompletionRequestor().isContextInformationMode() || prefix.length() == 4)) {
            String suffix = this.getSuffix(context);
            IType selfClassData = CodeAssistUtils.getSelfClassData(context.getSourceModule(), context.getOffset());
            if (selfClassData != null) {
                try {
                    ISourceRange sourceRange;
                    IMethod ctor = null;
                    IMethod[] iMethodArray = selfClassData.getMethods();
                    int n = iMethodArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IMethod method = iMethodArray[n2];
                        if (method.isConstructor()) {
                            ctor = method;
                            break;
                        }
                        ++n2;
                    }
                    if (ctor != null) {
                        sourceRange = selfClassData.getSourceRange();
                        FakeMethod ctorMethod = new FakeMethod((ModelElement)selfClassData, "self", sourceRange.getOffset(), sourceRange.getLength(), sourceRange.getOffset(), sourceRange.getLength()){

                            public boolean isConstructor() throws ModelException {
                                return true;
                            }
                        };
                        ctorMethod.setParameters(ctor.getParameters());
                        reporter.reportMethod((IMethod)ctorMethod, suffix, replaceRange);
                    } else {
                        sourceRange = selfClassData.getSourceRange();
                        reporter.reportMethod((IMethod)new FakeMethod((ModelElement)selfClassData, "self", sourceRange.getOffset(), sourceRange.getLength(), sourceRange.getOffset(), sourceRange.getLength()), "()", replaceRange);
                    }
                }
                catch (ModelException e) {
                    PHPCorePlugin.log(e);
                }
            }
        }
    }

    public String getNSSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "\\".equals(nextWord) ? "" : "\\";
    }

    public String getSuffix(AbstractCompletionContext abstractContext) {
        String nextWord = null;
        try {
            nextWord = abstractContext.getNextWord();
        }
        catch (BadLocationException e) {
            PHPCorePlugin.log(e);
        }
        return "::".equals(nextWord) ? "" : "::";
    }

    protected Object getExtraInfo() {
        return null;
    }
}

