/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPhpScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPStructuredTextPartitioner;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class FormatterUtils {
    private static PHPStructuredTextPartitioner partitioner = new PHPStructuredTextPartitioner();
    private static StringBuffer helpBuffer = new StringBuffer(50);

    public static String getRegionType(IStructuredDocument document, int offset) {
        IStructuredDocumentRegion sdRegion;
        block7: {
            try {
                sdRegion = document.getRegionAtCharacterOffset(offset);
                if (sdRegion != null) break block7;
                return null;
            }
            catch (BadLocationException badLocationException) {}
        }
        ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
        if (tRegion == null && offset == document.getLength()) {
            tRegion = sdRegion.getRegionAtCharacterOffset(--offset);
        }
        if (tRegion.getType().equals("PHP_CLOSE")) {
            tRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
        }
        int regionStart = sdRegion.getStartOffset(tRegion);
        if (tRegion != null && tRegion instanceof ITextRegionContainer) {
            ITextRegionContainer container = (ITextRegionContainer)tRegion;
            tRegion = container.getRegionAtCharacterOffset(offset);
            regionStart += tRegion.getStart();
        }
        if (tRegion != null && tRegion instanceof IPhpScriptRegion) {
            IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
            int regionOffset = offset - regionStart;
            ITextRegion innerRegion = scriptRegion.getPhpToken(regionOffset);
            return innerRegion.getType();
        }
        return null;
    }

    public static String getPartitionType(IStructuredDocument document, int offset, boolean perferOpenPartitions) {
        block10: {
            String partition;
            block11: {
                IStructuredDocumentRegion sdRegion;
                block9: {
                    try {
                        sdRegion = document.getRegionAtCharacterOffset(offset);
                        if (sdRegion != null) break block9;
                        return null;
                    }
                    catch (BadLocationException badLocationException) {}
                }
                ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(offset);
                if (tRegion == null && offset == document.getLength()) {
                    tRegion = sdRegion.getRegionAtCharacterOffset(--offset);
                }
                if (tRegion.getType().equals("PHP_CLOSE")) {
                    tRegion = sdRegion.getRegionAtCharacterOffset(offset - 1);
                }
                int regionStart = sdRegion.getStartOffset(tRegion);
                if (tRegion != null && tRegion instanceof ITextRegionContainer) {
                    ITextRegionContainer container = (ITextRegionContainer)tRegion;
                    tRegion = container.getRegionAtCharacterOffset(offset);
                    regionStart += tRegion.getStart();
                }
                if (tRegion == null || !(tRegion instanceof IPhpScriptRegion)) break block10;
                IPhpScriptRegion scriptRegion = (IPhpScriptRegion)tRegion;
                int regionOffset = offset - regionStart;
                ITextRegion innerRegion = scriptRegion.getPhpToken(regionOffset);
                partition = scriptRegion.getPartition(regionOffset);
                if (offset - (sdRegion.getStart() + regionStart + innerRegion.getStart()) != 0) break block11;
                String regionType = innerRegion.getType();
                if (PHPPartitionTypes.isPHPDocCommentState(regionType) || regionType != "PHPDOC_COMMENT_START") {
                    return partition;
                }
                if (PHPPartitionTypes.isPHPMultiLineCommentState(regionType) || regionType != "PHP_COMMENT_START") {
                    return partition;
                }
                return "org.eclipse.php.PHP_DEFAULT";
            }
            return partition;
        }
        partitioner.connect((IDocument)document);
        return partitioner.getContentType(offset, perferOpenPartitions);
    }

    public static String getPartitionType(IStructuredDocument document, int offset) {
        return FormatterUtils.getPartitionType(document, offset, false);
    }

    public static String getLineBlanks(IStructuredDocument document, IRegion lineInfo) throws BadLocationException {
        helpBuffer.setLength(0);
        int startOffset = lineInfo.getOffset();
        int length = lineInfo.getLength();
        char[] line = document.get(startOffset, length).toCharArray();
        int i = 0;
        while (i < line.length) {
            char c = line[i];
            if (!Character.isWhitespace(c)) break;
            helpBuffer.append(c);
            ++i;
        }
        return helpBuffer.toString();
    }

    public static IStructuredDocumentRegion getLastPhpStructuredDocumentRegion(IStructuredDocumentRegion currentStructuredDocumentRegion) {
        assert (currentStructuredDocumentRegion != null);
        currentStructuredDocumentRegion = currentStructuredDocumentRegion.getPrevious();
        while (currentStructuredDocumentRegion != null && currentStructuredDocumentRegion.getType() != "PHP_CONTENT") {
            currentStructuredDocumentRegion = currentStructuredDocumentRegion.getPrevious();
        }
        return currentStructuredDocumentRegion;
    }
}

