/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IExpressionManager;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.actions.expressions.WatchExpressionAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.debug.ui.Logger;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class PHPWatchAction
extends WatchExpressionAction
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            action.setEnabled(textSelection.getLength() != 0);
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection instanceof TextSelection) {
            TextSelection textSelection = (TextSelection)selection;
            IExpressionManager expressionManager = DebugPlugin.getDefault().getExpressionManager();
            IDOMNode domNode = (IDOMNode)selection.getFirstElement();
            try {
                String expression = domNode.getFirstStructuredDocumentRegion().getParentDocument().get(textSelection.getOffset(), textSelection.getLength());
                IWatchExpression watchExpression = expressionManager.newWatchExpression(expression.trim());
                expressionManager.addExpression((IExpression)watchExpression);
                watchExpression.setExpressionContext(this.getContext());
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
    }

    public void dispose() {
    }
}

