/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.ui.preferences.phps;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org.eclipse.php.internal.debug.core.preferences.PHPexeItem;
import org.eclipse.php.internal.debug.core.preferences.PHPexes;
import org.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org.eclipse.php.internal.debug.ui.preferences.phps.PHPexeDescriptor;
import org.eclipse.php.internal.debug.ui.preferences.phps.ShowPHPsPreferences;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PHPsComboBlock
implements ISelectionProvider {
    PHPexes exes = PHPexes.getInstance();
    protected Combo fExecutablesCombo;
    protected Combo fDebuggersCombo;
    private Composite fControl;
    private PHPexeDescriptor fDefaultDescriptor = null;
    private ISelection fPrevSelection = new StructuredSelection();
    private final ListenerList fSelectionListeners = new ListenerList();
    private String fTitle = null;
    private final List<PHPexeItem> phpExecutables = new ArrayList<PHPexeItem>();
    private boolean isTitled;
    private Link link;
    private Set<String> fDebuggerIds;
    private Timer timer;

    public PHPsComboBlock(boolean titleGrouped) {
        this.isTitled = titleGrouped;
        this.fDefaultDescriptor = new PHPexeDescriptor(){

            public String getDescription() {
                PHPexeItem def = PHPsComboBlock.this.exes.getDefaultItem(PHPDebugPlugin.getCurrentDebuggerId());
                if (def != null) {
                    return String.valueOf(def.getName()) + " (" + def.getExecutable().toString() + ")";
                }
                return "No PHP exes defined";
            }
        };
    }

    public PHPsComboBlock() {
        this(true);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public void createControl(Composite ancestor) {
        Font font = ancestor.getFont();
        Composite composite = null;
        if (this.isTitled) {
            Group g = new Group(ancestor, 0);
            if (this.fTitle == null) {
                this.fTitle = PHPDebugUIMessages.PHPexesComboBlock_3;
            }
            g.setText(this.fTitle);
            composite = g;
        } else {
            composite = new Composite(ancestor, 0);
        }
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        composite.setFont(font);
        this.fControl = composite;
        Composite topLeft = new Composite(composite, 0);
        layout = new GridLayout(2, false);
        topLeft.setLayout((Layout)layout);
        topLeft.setFont(font);
        Label debuggerLabel = new Label(topLeft, 64);
        debuggerLabel.setText(PHPDebugUIMessages.PhpDebugPreferencePage_phpDebugger);
        GridData data = new GridData(1);
        data.widthHint = 100;
        debuggerLabel.setLayoutData((Object)data);
        this.fDebuggersCombo = new Combo(topLeft, 12);
        this.fDebuggersCombo.setFont(font);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.fDebuggersCombo.setLayoutData((Object)data);
        this.fDebuggersCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedDebuggerID = PHPsComboBlock.this.getSelectedDebuggerId();
                PHPexeItem[] items = PHPsComboBlock.this.exes.getItems(selectedDebuggerID);
                List<PHPexeItem> itemsList = items != null ? Arrays.asList(items) : new ArrayList<PHPexeItem>(0);
                PHPsComboBlock.this.setPHPexes(itemsList);
                PHPsComboBlock.this.fireSelectionChanged();
                PHPsComboBlock.this.signalExecutablesCombo();
            }
        });
        Label dummy = new Label(composite, 0);
        dummy.setLayoutData((Object)new GridData(512));
        Composite bottomLeft = new Composite(composite, 0);
        layout = new GridLayout(2, false);
        bottomLeft.setLayout((Layout)layout);
        bottomLeft.setFont(font);
        data = gridData;
        bottomLeft.setLayoutData((Object)data);
        Label executableLabel = new Label(bottomLeft, 64);
        executableLabel.setText("PHP Executable:");
        data = new GridData(1);
        data.widthHint = 100;
        executableLabel.setLayoutData((Object)data);
        this.fExecutablesCombo = new Combo(bottomLeft, 12);
        this.fExecutablesCombo.setFont(font);
        data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        this.fExecutablesCombo.setLayoutData((Object)data);
        this.fExecutablesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPsComboBlock.this.setPHPexe(PHPsComboBlock.this.getPHPexe());
            }
        });
        this.link = new Link(composite, 0);
        data = new GridData();
        data.horizontalSpan = 1;
        this.link.setLayoutData((Object)data);
        this.link.setFont(font);
        this.link.setText(PHPDebugUIMessages.PhpDebugPreferencePage_installedPHPsLink);
        this.link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPexeItem selected = PHPsComboBlock.this.getPHPexe();
                new ShowPHPsPreferences().run(null);
                PHPsComboBlock.this.fillWithWorkspacePHPexes();
                if (PHPsComboBlock.this.phpExecutables.contains(selected)) {
                    String name = String.valueOf(selected.getName()) + " (" + selected.getExecutable().toString() + ")";
                    PHPsComboBlock.this.fExecutablesCombo.select(PHPsComboBlock.this.fExecutablesCombo.indexOf(name));
                }
            }
        });
        this.checkDeuggers();
        this.fillDebuggers();
        this.fillWithWorkspacePHPexes();
    }

    private void checkDeuggers() {
        if (!this.exes.hasItems()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)PHPDebugUIMessages.PHPsComboBlock_NoPHPsTitle, (String)PHPDebugUIMessages.PHPsComboBlock_noPHPsMessage);
            new ShowPHPsPreferences().run(null);
        }
    }

    protected void fillDebuggers() {
        this.fDebuggerIds = PHPDebuggersRegistry.getDebuggersIds();
        for (String id : this.fDebuggerIds) {
            this.fDebuggersCombo.add(PHPDebuggersRegistry.getDebuggerName((String)id));
        }
        String defaultName = PHPDebuggersRegistry.getDebuggerName((String)PHPDebuggersRegistry.getDefaultDebuggerId());
        int index = this.fDebuggersCombo.indexOf(defaultName);
        if (index > -1) {
            this.fDebuggersCombo.select(index);
        } else if (this.fDebuggersCombo.getItemCount() > 0) {
            this.fDebuggersCombo.select(0);
        }
    }

    protected void signalExecutablesCombo() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate((TimerTask)new BlinkTask(), 0L, 300L);
    }

    protected void fillWithWorkspacePHPexes() {
        ArrayList<PHPexeItem> standins = new ArrayList<PHPexeItem>();
        PHPexeItem[] types = this.exes.getItems(PHPDebugPlugin.getCurrentDebuggerId());
        if (types != null) {
            int i = 0;
            while (i < types.length) {
                PHPexeItem type = types[i];
                standins.add(type);
                ++i;
            }
        }
        this.setPHPexes(standins);
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] listeners = this.fSelectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    public Control getControl() {
        return this.fControl;
    }

    public void setEnabled(boolean enabled) {
        this.fControl.setEnabled(enabled);
        this.fExecutablesCombo.setEnabled(enabled);
        this.fDebuggersCombo.setEnabled(enabled);
        this.link.setEnabled(enabled);
    }

    public PHPexeItem getPHPexe() {
        int index = this.fExecutablesCombo.getSelectionIndex();
        if (index >= 0 && !PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined.equals(this.fExecutablesCombo.getText())) {
            return this.phpExecutables.get(index);
        }
        return null;
    }

    public PHPexeItem[] getPHPexes() {
        return this.phpExecutables.toArray(new PHPexeItem[this.phpExecutables.size()]);
    }

    public String getSelectedExecutablePath() {
        PHPexeItem item = this.getPHPexe();
        if (item != null) {
            return item.getExecutable().toString();
        }
        return "";
    }

    public String getSelectedIniPath() {
        PHPexeItem item = this.getPHPexe();
        if (item != null && item.getINILocation() != null) {
            return item.getINILocation().toString();
        }
        return "";
    }

    public String getSelectedDebuggerId() {
        int selectedIndex = this.fDebuggersCombo.getSelectionIndex();
        String debuggerId = "org.eclipse.php.debug.core.zendDebugger";
        if (selectedIndex > -1 && this.fDebuggerIds.size() > selectedIndex) {
            debuggerId = this.fDebuggerIds.toArray()[selectedIndex].toString();
        }
        return debuggerId;
    }

    public ISelection getSelection() {
        PHPexeItem vm = this.getPHPexe();
        if (vm == null) {
            return new StructuredSelection();
        }
        return new StructuredSelection((Object)vm);
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setPHPexe(PHPexeItem item) {
        if (item == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)item));
        }
    }

    public void setDebugger(String debuggerID) {
        int index = this.fDebuggersCombo.indexOf(PHPDebuggersRegistry.getDebuggerName((String)debuggerID));
        if (index > -1) {
            this.fDebuggersCombo.select(index);
            PHPexeItem[] items = this.exes.getItems(debuggerID);
            if (items != null) {
                this.setPHPexes(Arrays.asList(items));
            } else {
                this.setPHPexes(new ArrayList<PHPexeItem>(0));
            }
        }
    }

    protected void setPHPexes(List<PHPexeItem> phps) {
        this.phpExecutables.clear();
        this.phpExecutables.addAll(phps);
        Collections.sort(this.phpExecutables, new Comparator<PHPexeItem>(){

            @Override
            public int compare(PHPexeItem o1, PHPexeItem o2) {
                if (o1 != null && o2 != null) {
                    String o1Name = o1.getName();
                    String o2Name = o2.getName();
                    if (o1Name != null && o2Name != null) {
                        return o1Name.compareToIgnoreCase(o2Name);
                    }
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                return obj == this;
            }
        });
        String[] names = new String[this.phpExecutables.size()];
        Iterator<PHPexeItem> iter = this.phpExecutables.iterator();
        int i = 0;
        while (iter.hasNext()) {
            PHPexeItem item = iter.next();
            names[i] = String.valueOf(item.getName()) + " (" + item.getExecutable().toString() + ")";
            ++i;
        }
        if (names.length == 0) {
            names = new String[]{PHPDebugUIMessages.PhpDebugPreferencePage_noExeDefined};
        }
        this.fExecutablesCombo.setItems(names);
        PHPexeItem defaultExe = this.exes.getDefaultItem(this.getSelectedDebuggerId());
        if (defaultExe != null) {
            String defaultName = String.valueOf(defaultExe.getName()) + " (" + defaultExe.getExecutable().toString() + ")";
            this.fExecutablesCombo.select(this.fExecutablesCombo.indexOf(defaultName));
        } else {
            this.fExecutablesCombo.select(0);
        }
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.fPrevSelection)) {
            this.fPrevSelection = selection;
            if (selection.isEmpty()) {
                this.fExecutablesCombo.setText("");
                this.fExecutablesCombo.select(-1);
                this.fExecutablesCombo.setItems(new String[0]);
                this.fillWithWorkspacePHPexes();
            } else {
                Object phpExe = ((IStructuredSelection)selection).getFirstElement();
                int index = this.phpExecutables.indexOf(phpExe);
                if (index >= 0) {
                    this.fExecutablesCombo.select(index);
                }
            }
            this.fireSelectionChanged();
        }
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public void setUseDefaultPHPexe() {
        if (this.fDefaultDescriptor != null && this.fControl != null) {
            this.fPrevSelection = null;
            this.fireSelectionChanged();
        }
    }

    private class BlinkTask
    extends TimerTask {
        int counter;

        private BlinkTask() {
        }

        public void run() {
            try {
                if (this.counter++ < 6) {
                    PHPsComboBlock.this.fExecutablesCombo.getDisplay().syncExec(new Runnable(){

                        public void run() {
                            try {
                                if (BlinkTask.this.counter % 2 != 0) {
                                    ((BlinkTask)BlinkTask.this).PHPsComboBlock.this.fExecutablesCombo.setEnabled(false);
                                } else {
                                    ((BlinkTask)BlinkTask.this).PHPsComboBlock.this.fExecutablesCombo.setEnabled(true);
                                }
                            }
                            catch (SWTException sWTException) {
                                BlinkTask.this.cancel();
                            }
                        }
                    });
                } else {
                    this.cancel();
                }
            }
            catch (SWTException sWTException) {
                this.cancel();
            }
        }
    }
}

