/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.preferences.PHPFormatterConfigurationWrapper;
import org.eclipse.php.internal.ui.preferences.PropertyAndPreferencePage;
import org.eclipse.php.internal.ui.util.ElementCreationProxy;
import org.eclipse.php.ui.preferences.IPHPFormatterConfigurationBlockWrapper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class PHPFormatterPreferencePage
extends PropertyAndPreferencePage {
    public static final String PREF_ID = "org.eclipse.php.ui.preferences.PHPFormatterPreferencePage";
    public static final String PROP_ID = "org.eclipse.php.ui.propertyPages.PHPFormatterPreferencePage";
    private IPHPFormatterConfigurationBlockWrapper fConfigurationBlock;
    private boolean hasExtensionsForPDT = false;

    public PHPFormatterPreferencePage() {
        this.setPreferenceStore(PHPUiPlugin.getDefault().getPreferenceStore());
        this.setTitle(PHPUIMessages.PHPFormatterPreferencePage_title);
    }

    public void createControl(Composite parent) {
        IWorkbenchPreferenceContainer container = (IWorkbenchPreferenceContainer)this.getContainer();
        this.fConfigurationBlock = this.getFormatterPreferencesBlock();
        this.fConfigurationBlock.init(this.getNewStatusChangedListener(), this.getProject(), container);
        this.setDescription(this.fConfigurationBlock.getDescription());
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.php.help.formatter_preferences");
    }

    private IPHPFormatterConfigurationBlockWrapper getFormatterPreferencesBlock() {
        IPHPFormatterConfigurationBlockWrapper prefBlock = null;
        String formatterExtensionName = "org.eclipse.php.ui.phpFormatterPrefBlock";
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(formatterExtensionName);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("block")) {
                ElementCreationProxy ecProxy = new ElementCreationProxy(element, formatterExtensionName);
                prefBlock = (IPHPFormatterConfigurationBlockWrapper)ecProxy.getObject();
            }
            ++i;
        }
        if (prefBlock == null) {
            prefBlock = new PHPFormatterConfigurationWrapper();
        } else {
            this.hasExtensionsForPDT = true;
        }
        return prefBlock;
    }

    protected Control createPreferenceContent(Composite composite) {
        return this.fConfigurationBlock.createContents(composite);
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        if (!this.hasExtensionsForPDT) {
            GridData data = new GridData(4, 4, true, false);
            this.fConfigurationBlockControl.setLayoutData((Object)data);
        }
        return control;
    }

    protected boolean hasProjectSpecificOptions(IProject project) {
        return this.fConfigurationBlock.hasProjectSpecificOptions(project);
    }

    protected String getPreferencePageID() {
        return PREF_ID;
    }

    protected String getPropertyPageID() {
        return PROP_ID;
    }

    protected void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.useProjectSpecificSettings(useProjectSpecificSettings);
        }
        super.enableProjectSpecificSettings(useProjectSpecificSettings);
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performDefaults();
        }
    }

    public boolean performOk() {
        if (this.fConfigurationBlock != null && !this.fConfigurationBlock.performOk()) {
            return false;
        }
        return super.performOk();
    }

    public void performApply() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.performApply();
        }
    }

    public void dispose() {
        if (this.fConfigurationBlock != null) {
            this.fConfigurationBlock.dispose();
        }
        super.dispose();
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.setDescription(null);
    }
}

