﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Text;
using System.Text.RegularExpressions;
using Progressive.PecaStarter.Commons.Networks;

namespace Progressive.PecaStarter.Peercast4Net
{
    class Peercast4Net : Peercast4NetBase
    {
        private const string FetchCommand = "/admin?cmd=fetch&url={0}&name={1}&genre={2}&desc={3}&contact={4}&type={5}";
        private const string SetMetaCommand = "/admin?cmd=setmeta&name={0}&genre={1}&desc={2}&url={3}&comment={4}&t_artist={5}&t_title={6}&t_album={7}&t_genre={8}&t_contact={9}";
        private const string StopCommand = "/admin?cmd=stop&id={0}";
        private const string KeepCommand = "/admin?cmd=keep&id={0}";
        private const string ApplyCommand = "/admin?cmd=apply";
        private const string ViewXmlCommand = "/admin?cmd=viewxml";

        private string address = "localhost:7144";
        public string Address
        {
            get { return address; }
            set
            {
                if (address == value)
                    return;
                string[] parts = value.Split(':');
                if (parts.Length < 1 || 2 < parts.Length
                        || Uri.CheckHostName(parts[0]) == UriHostNameType.Unknown
                        || (parts.Length == 2 && !Regex.IsMatch(parts[1], "^[0-9]{1,5}$")))
                {
                    address = "localhost:7144";
                    return;
                }
                address = value;
            }
        }

        public IAsyncResult BeginBroadcast(
                string url, string name, string genre, string description, string contactUrl, string type,
                AsyncCallback callback, object state)
        {
            return BeginAccess(GetAddress(string.Format(FetchCommand,
                    Escape(url), Escape(name), Escape(genre), Escape(description), Escape(contactUrl), Escape(type))),
                    callback, state);
        }

        public void EndBroadcast(IAsyncResult asyncResult)
        {
            EndAccess(asyncResult);
        }

        public IAsyncResult BeginUpdate(
                string name, string genre, string description, string url, string comment,
                string trackArtist, string trackTitle, string trackAlbum, string trackGenre, string trackContact,
                AsyncCallback callback, object state)
        {
            return BeginAccess(GetAddress(string.Format(SetMetaCommand,
                    Escape(name), Escape(genre), Escape(description), Escape(url), Escape(comment),
                    Escape(trackArtist), Escape(trackTitle), Escape(trackAlbum), Escape(trackGenre), Escape(trackContact))),
                    callback, state);
        }

        public void EndUpdate(IAsyncResult asyncResult)
        {
            EndAccess(asyncResult);
        }

        public IAsyncResult BeginStop(string id, AsyncCallback callback, object state)
        {
            return BeginAccess(GetAddress(string.Format(StopCommand, id)), callback, state);
        }

        public void EndStop(IAsyncResult asyncResult)
        {
            EndAccess(asyncResult);
        }

        public IAsyncResult BeginKeep(string id, AsyncCallback callback, object state)
        {
            return BeginAccess(GetAddress(string.Format(KeepCommand, id)), callback, state);
        }

        public void EndKeep(IAsyncResult asyncResult)
        {
            EndAccess(asyncResult);
        }

        public IAsyncResult BeginGetStatus(AsyncCallback callback, object status)
        {
            return BeginGetText(GetAddress(ViewXmlCommand), callback, status);
        }

        public string EndGetStatus(IAsyncResult asyncResult)
        {
            return EndGetText(asyncResult);
        }

        private string GetAddress(string path)
        {
            return "http://" + address + path;
        }

        /// <summary>
        /// 可能ならShift-JIS、もしくはUTF8でエンコードする
        /// 文字数チェックも含む
        /// </summary>
        private string Escape(string str)
        {
            // TODO: SJIS版
            return Uri.EscapeDataString(str);
        }
    }
}
