﻿using System.Linq;
using System.Collections.Generic;
using System.Configuration;
using System.Threading;
using System.Windows;
using System.Windows.Input;
using Progressive.PecaStarter.Dao;
using Progressive.PecaStarter.Dxo;
using Progressive.PecaStarter.Model;
using Progressive.PecaStarter.ViewModel.Command;
using Progressive.PecaStarter.ViewModel.Page;
using System;
using System.Collections.Specialized;
using System.Windows.Threading;

namespace Progressive.PecaStarter.ViewModel
{
    public class MainWindowViewModel : ViewModelBase
    {
        #region Variables
        private readonly Core core;
        private readonly Peercast peercast;
        private readonly IList<YellowPages> yellowPageses;
        private readonly Logger logger;
        private bool isBusy;
        private double left;
        private double top;
        private double height;
        private double width;
        private string feedback;
        private int selectedIndex;
        #endregion

        #region Properties
        private Timer Timer { get; set; }
        public bool IsTimerRunning { get { return Timer != null; } }
        public bool IsBusy
        {
            get { return isBusy; }
            set
            {
                isBusy = value;
                NotifyPropertyChanged("IsBusy");
                CommandManager.InvalidateRequerySuggested();
            }
        }
        public bool IsBroadcast { get { return peercast.IsBroadcast; } }
        public IDictionary<string, YellowPagesViewModel> YellowPageses { get; private set; }
        #endregion

        #region Binding Properties
        public RelayListViewModel RelayListViewModel { get; private set; }
        public YellowPagesesViewModel YellowPagesesViewModel { get; private set; }
        public ExternalSourceViewModel ExternalSourceViewModel { get; private set; }
        public SettingsViewModel SettingsViewModel { get; private set; }
        public string Title { get { return core.ApplicationTitle; } }
        public double Left
        {
            get { return left; }
            set
            {
                left = value;
                NotifyPropertyChanged("Left");
            }
        }
        public double Top
        {
            get { return top; }
            set
            {
                top = value;
                NotifyPropertyChanged("Top");
            }
        }
        public double Height
        {
            get { return height; }
            set
            {
                height = value;
                NotifyPropertyChanged("Height");
            }
        }
        public double Width
        {
            get { return width; }
            set
            {
                width = value;
                NotifyPropertyChanged("Width");
            }
        }
        public string Alert { get; private set; }
        public string Feedback
        {
            get { return feedback; }
            set
            {
                feedback = value;
                NotifyPropertyChanged("Feedback");
            }
        }
        public string ConfigurationPath
        {
            get
            {
                return ConfigurationManager.OpenExeConfiguration(ConfigurationUserLevel.PerUserRoamingAndLocal).FilePath;
            }
        }
        public int SelectedIndex
        {
            get { return selectedIndex; }
            set
            {
                selectedIndex = value;
                NotifyPropertyChanged("SelectedIndex");
            }
        }
        public Visibility ButtonsVisibility
        {
            get
            {
                if (SelectedIndex == 2 || SelectedIndex == 3)
                {
                    return Visibility.Visible;
                }
                return Visibility.Collapsed;
            }
        }

        public ICommand BroadcastCommand { get; private set; }
        public ICommand UpdateCommand { get; private set; }
        public ICommand StopCommand { get; private set; }
        #endregion

        public MainWindowViewModel()
        {
            core = new Core();
            peercast = new Peercast();
            logger = new Logger();
            selectedIndex = 2;
            Left = double.NaN;
            Top = double.NaN;
            Height = 320.0;
            Width = 512.0;
            yellowPageses = core.GetYellowPages();
            YellowPageses = new Dictionary<string, YellowPagesViewModel>();
            foreach (var yp in yellowPageses)
            {
                YellowPageses.Add(yp.Name, new YellowPagesViewModel(this, yp));
            }
            RelayListViewModel = new RelayListViewModel(peercast, yellowPageses, this);
            YellowPagesesViewModel = new YellowPagesesViewModel(this);
            ExternalSourceViewModel = new ExternalSourceViewModel(this, peercast);
            SettingsViewModel = new SettingsViewModel(this, peercast, logger);
            BroadcastCommand = new BroadcastCommand(peercast, logger, yellowPageses, this);
            UpdateCommand = new UpdateCommand(peercast, logger, yellowPageses, this);
            StopCommand = new StopCommand(peercast, logger, yellowPageses, this);
            AddRelation("IsBusy", "IsBroadcast");
            AddRelation("SelectedIndex", "ButtonsVisibility");
        }

        public void Save()
        {
            ExternalSourceViewModel.UpdateHistory();
            new SaveDataDao().Update(SaveDataDxo.toEntity(this));
        }

        public Tuple<bool, MessageBoxButton, string> CanClose()
        {
            if (IsBusy)
            {
                return Tuple.Create(false, MessageBoxButton.OK, "処理が実行中なので終了できません。");
            }
            if (IsBroadcast)
            {
                return Tuple.Create(false, MessageBoxButton.YesNo, "配信中です。強制的に終了しますか？");
            }
            return Tuple.Create(true, MessageBoxButton.OK, (string)null); ;
        }

        public override void Dispose()
        {
            Save();
        }

        public void NotifyAlert(string value)
        {
            Alert = value;
            NotifyPropertyChanged("Alert");
            Alert = "";
            NotifyPropertyChanged("Alert");
        }

        public void BeginTimer()
        {
            var ypvm = YellowPagesesViewModel.SelectedYellowPages;
            var wyp = yellowPageses.Single(a => a.Name == ypvm.Name) as WebApiYellowPages;
            NameValueCollection nvc = null;
            if (wyp != null)
            {
                nvc = new NameValueCollection();
                nvc.Add("name", ExternalSourceViewModel.Name.Value);
                nvc.Add("password", YellowPagesesViewModel.SelectedYellowPages["password"]);
                nvc.Add("listeners", "-1");
            }
            var command = new TimerCommand(peercast, logger, Dispatcher.CurrentDispatcher, this, wyp, nvc);
            if (Timer != null)
            {
                Timer.Dispose();
            }
            Timer = new Timer(new TimerCallback((arg) => command.Execute()), null, TimeSpan.FromMinutes(10), TimeSpan.FromMinutes(10));
        }

        public void EndTimer()
        {
            Timer.Dispose();
            Timer = null;
        }

        public void EndTimer(string message)
        {
            logger.insert("", "", "", "", message);
            EndTimer();
        }
    }
}
