﻿using System;
using System.Windows.Controls;
using System.Windows.Navigation;
using Progressive.PecaStarter.View.WPF.Dialog;
using Progressive.PecaStarter.View.WPF.Page;
using Progressive.PecaStarter.ViewModel;
using Progressive.PecaStarter.ViewModel.Broadcast;

namespace Progressive.PecaStarter.View.WPF
{
    /// <summary>
    /// Broadcast.xaml の相互作用ロジック
    /// </summary>
    public partial class Broadcast
    {
        private TaskTrayIconManager TaskTrayIconManager;
        private BroadcastViewModel ViewModel
        {
            get { return DataContext as BroadcastViewModel; }
        }

        public Broadcast()
            : base()
        {
            DataContext = new BroadcastViewModel();
            if (ViewModel.SettingsViewModel.IsSavePosition)
            {
                Left = ViewModel.Left;
                Top = ViewModel.Top;
                Width = ViewModel.Width;
                Height = ViewModel.Height;
            }
        }

        private void Window_Loaded(object sender, System.Windows.RoutedEventArgs e)
        {
            TaskTrayIconManager = new TaskTrayIconManager(this);
            if (ViewModel.SettingsViewModel.IsNotifyIcon)
            {
                TaskTrayIconManager.Create();
            }
            ViewModel.SettingsViewModel.PropertyChanged += (s, e1) =>
            {
                if (e1.PropertyName != "IsNotifyIcon")
                {
                    return;
                }
                if ((s as SettingsViewModel).IsNotifyIcon)
                {
                    TaskTrayIconManager.Create();
                    return;
                }
                TaskTrayIconManager.Dispose();
            };
            ViewModel.RelaySelectDialogViewModel.PropertyChanged += (s, e1) =>
            {
                if (e1.PropertyName != "BroadcastChannels")
                {
                    return;
                }
                if ((s as RelaySelectDialogViewModel).BroadcastChannels == null)
                {
                    return;
                }
                Dispatcher.Invoke((Action)(() => new RelaySelectDialog(this, ViewModel.RelaySelectDialogViewModel).ShowDialog()), null);
            };
            externalSource.GotFocus += (s, e1) =>
            {
                (externalSource.Content as ExternalSource).ypPrefix.GetBindingExpression(ContentProperty).UpdateTarget();
            };
        }

        protected override void OnClosing(System.ComponentModel.CancelEventArgs e)
        {
            base.OnClosing(e);
            if (!ViewModel.SettingsViewModel.IsSavePosition)
            {
                return;
            }
            ViewModel.Left = Left;
            ViewModel.Top = Top;
            ViewModel.Width = Width;
            ViewModel.Height = Height;
        }

        private void Frame_LoadCompleted(object sender, NavigationEventArgs e)
        {
            var frame = sender as Frame;
            (frame.Content as System.Windows.Controls.Page).DataContext = frame.DataContext;
        }
    }
}
