<?php
/*
 * This file is part of the petitwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: petitwork: the PHP lightweight web framework
 * File:    xbpwZip.php
 *
 * PHP 5 only
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: xbpwBatchExecuter.php 17 2009-05-09 06:21:54Z exbridge $
 * @copyright 2007-2008 Exbridge,Inc.
 */
require_once(PW_CORE_DIR . DS . 'xbpwService.php');
class xbpwBatchExecuter extends xbpwService {

    private $_pw_process_list = array();
    private $_pw_process_class_list = array();

    private $_pw_end_file_flg = true;

    //.prc file：処理実行中（実行中0バイト：エラー発生1バイト以上）
    //.end file：処理終了
    private $_pw_class_nm = '';
    private $_pw_file_nm  = '';

    private $_pw_status;
    private $_pw_message;

    /**
     * add process
     *  array('subdir'  => サブディレクトリ名
     *        'process' => プロセス名)
     */
    public function addProcess($process) {
        $this->_pw_process_list[] = $process;
    }

    /**
     * set end file create flg
     */
    public function setEndFileFlg($flg) {
        $this->_pw_end_file_flg = $flg;
    }

    /**
     * get status
     */
    public function getStatus() {
        return $this->_pw_status;
    }

    /**
     * get message
     */
    public function getMessage() {
        return $this->_pw_message;
    }

    /**
     * run process
     */
    public function run() {
        try {
            //process executer
            foreach ($this->_pw_process_list as $pw_process) {
                $dir = $pw_process['dir'];
                $process = $pw_process['process'];
                if (isNULL($pw_process['dir'])) {
                    require_once(PW_BATCH_DIR . DS . $process . '.php');
                }
                else {
                    require_once(PW_BATCH_DIR . DS . $dir . DS . $process . '.php');
                }
                $process_obj = new $process();
                $this->_pw_class_nm = $process;
                $results = $this->exec($process_obj, $process);
                if ($results['status']==false) {
                    $this->_pw_status  = $results['status'];
                    $this->_pw_message = $results['message'];
                    return $results;
                }
            }

            //end files delete
            $file_list = PW_PRC_DIR . '/*.end';
            foreach (glob($file_list) as $file) {
                unlink($file);
            }

            $this->_pw_status  = true;
            $this->_pw_message = 'process completed.';
            return array('status'=>$this->_pw_status, 'message'=>$this->_pw_message);
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, $e->getMessage());
        }
    }

    /**
     * exec process
     */
    public function exec($process_obj, $process) {
        try {
            $result;

            $this->_initialize();

            if (!$this->_isEndFile()) {
                $results = $process_obj->mainProcess();
                if (!is_array($results)) {
                    throw new xbpwException(E_USER_ERROR, 'results format error. [' . $process . ']');
                }
                //traceLog('process successed');
            }
            else {
                traceLog('exists end file. process skipped [' . $process . ']');
            }

            $this->_finalize();

            return $results;
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, $e->getMessage());
        }
    }

    /**
     *  init
     */
    private function _initialize() {
        try {
            if (PW_PRC_DIR == '') {
                throw new xbpwException(E_USER_ERROR, 'not found prc dir');
            }
            if ($this->_pw_class_nm == '') {
                throw new xbpwException(E_USER_ERROR, 'not found process name');
            }
            $this->_pw_file_nm = PW_PRC_DIR . DS . $this->_pw_class_nm;
            return $this->_createPrcFile();
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, $e->getMessage());
        }
    }

    /**
     *  finalize
     */
    private function _finalize() {
        try {
            if ($this->_pw_end_file_flg) {
                $this->_createEndFile();
            }
            return $this->_deletePrcFile();
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, $e->getMessage());
        }
    }

    /**
     *  create prc file
     */
    private function _createPrcFile() {
        try {
            if (!$this->_pw_end_file_flg) {
                if ($this->_isPrcFile()) {
                    throw new xbpwException(E_USER_ERROR, 'while starting or abnormal termination of the last processing');
                }
            }
            $file = $this->_pw_file_nm . '.prc';
            if (file_exists($file)) {
                throw new xbpwException(E_USER_ERROR, 'while starting or abnormal termination of the last processing');
            }
            return $this->_createFile($file);
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, $e->getMessage());
        }
    }

    /**
     *  delete prc file
     */
    private function _deletePrcFile() {
        try {
            $file = $this->_pw_file_nm . '.prc';
            return $this->_deleteFile($file);
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, $e->getMessage());
        }
    }

    /**
     *  create end file
     */
    private function _createEndFile() {
        try {
            $file = $this->_pw_file_nm . '.end';
            return $this->_createFile($file);
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, $e->getMessage());
        }
    }

    /**
     * exist end file
     */
    private function _isEndFile() {
        try {
            $file = $this->_pw_file_nm . '.end';
            return file_exists($file);
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, $e->getMessage());
        }
    }

    /**
     * exist prc file
     */
    private function _isPrcFile() {
        try {
            foreach ($this->_pw_process_list as $pw_process) {
                $dir = $pw_process['dir'];
                $process = $pw_process['process'];
                $file = PW_PRC_DIR . DS . $process . '.prc';
                if (file_exists($file)) {
                    return true;
                }
            }
            return false;
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, $e->getMessage());
        }
    }

    /**
     * create file
     */
    private function _createFile($file) {
        try {
            $handle = @fopen($file, 'wb');
            if (!$handle) {
                throw new xbpwException(E_USER_ERROR, sprintf('error open file（%s）',$file));
            }
            @fclose($handle);
            return true;
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, $e->getMessage());
        }
    }

    /**
     * delete file
     */
    private function _deleteFile($file) {
        try {
            $handle = @unlink($file);
            if (!$handle) {
                throw new xbpwException(E_USER_ERROR, sprintf('error delete file（%s）',$file));
            }
            return true;
        }
        catch (xbpwException $e) {
            throw $e;
        }
        catch (Exception $e) {
            throw new xbpwException(E_USER_ERROR, $e->getMessage());
        }
    }
}
