<?php
/*
 * This file is part of the petitwork package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Project: petitwork: the PHP lightweight web framework
 * File:    xbpwFTP.php
 *
 * @link http://exbridge.jp/
 * @author S.Tajima <tajima@exbridge.jp>
 * @version svn:$Id: xbpwFTP.php 17 2009-05-09 06:21:54Z exbridge $
 * @copyright 2007-2008 Exbridge,Inc.
 */
class xbpwFTP
{
    var $_pw_handle;
    var $_pw_host;
    var $_pw_port;
    var $_pw_user_id;
    var $_pw_pass;

    var $_pw_remote_dir;
    var $_pw_local_dir;

    /**
     * Creates new instance.
     * @access public
     */
    function xbpwFTP($host, $port, $userid, $password)
    {
        if (isset($host) || !is_null($host) || $host!='') {
            $this->_pw_host = $host;
        }
        if (isset($port) || !is_null($port) || $port!='') {
            $this->_pw_port = $port;
        }
        if (isset($userid) || !is_null($userid) || $userid!='') {
            $this->_pw_user_id = $userid;
        }
        if (isset($password) || !is_null($password) || $password!='') {
            $this->_pw_pass = $password;
        }
    }

    /**
     * setting RemoteDir
     * @param remoteDir
     * @access public
     */
    function setRemoteDir($remoteDir)
    {
        $this->_pw_remote_dir = $remoteDir;
    }

    /**
     * setting LocalDir
     * @param localDir
     * @access public
     */
    function setLocalDir($localDir)
    {
        $this->_pw_local_dir = $localDir;
    }

    /**
     * getting remote file list
     * @access public
     */
    function getRemoteFileList()
    {
        $this->getConnection();
        $result = ftp_nlist ($this->_pw_handle, $this->_pw_remote_dir);
        ftp_close($this->_pw_handle);

        $remote_file_list = array();
        foreach ($result as $file) {
            $str = split ('/', $file);
            $str = $str[count($str)-1];
            $remote_file_list[] = $str;
        }
        return $remote_file_list;
    }

    /**
     * file get(n)
     * @access public
     */
    function getList($list)
    {
        if (!is_array( $list )) {
            trigger_error("FTP class get list not array.", E_USER_NOTICE);
            return;
        }

        $this->getConnection();
        foreach ($list as $file) {
            $this->get( $file );
        }
        ftp_close($this->_pw_handle);
        return $result;
    }

    /**
     * file put(n)
     * @access public
     */
    function putList($list)
    {
        if (!is_array( $list )) {
            trigger_error("FTP class put list not array.", E_USER_NOTICE);
            return;
        }

        $this->getConnection();
        foreach ($list as $file) {
            $this->put( $file );
        }
        ftp_close($this->_pw_handle);
        return $result;
    }

    /**
     * fiel delete (n)
     * @access public
     */
    function deleteList($list)
    {
        if(!is_array( $list )) {
            trigger_error("FTP class delete list not array.", E_USER_NOTICE);
            return;
        }

        $this->getConnection();
        foreach ($list as $file) {
            $this->delete( $file );
        }
        ftp_close($this->_pw_handle);
        return $result;
    }

    /**
     * file getting
     * @access public
     */
    function get($file)
    {
        $lfile = $this->_pw_local_dir . DS . $file;
        $rfile = $this->_pw_remote_dir . DS . $file;

        $result;
        if (!$this->_pw_handle)
        {
            $this->getConnection();
            $result = ftp_get($this->_pw_handle, $lfile, $rfile, FTP_BINARY);
            ftp_close($this->_pw_handle);
        }
        else {
            $result = ftp_get($this->_pw_handle, $lfile, $rfile, FTP_BINARY);
        }
        return $result;
    }

    /**
     * file putting
     * @param file
     * @access public
     */
    function put($file)
    {
        $lfile = $this->_pw_local_dir . DS . $file;
        $rfile = $this->_pw_remote_dir . DS . $file;

        $result;
        if (!$this->_pw_handle) {
            $this->getConnection();
            $result = ftp_put($this->_pw_handle, $rfile, $lfile, FTP_BINARY);
            ftp_close($this->_pw_handle);
        }
        else {
            $result = ftp_put($this->_pw_handle, $rfile, $lfile, FTP_BINARY);
        }
        return $result;
    }

    /**
     * file delete
     * @param file
     * @access public
     */
    function delete($file)
    {
        $rfile = $this->_pw_remote_dir . DS . $file;

        $result;
        if (!$this->_pw_handle) {
            $this->getConnection();
            $result = ftp_delete($this->_pw_handle, $rfile);
            ftp_close($this->_pw_handle);
        }
        else {
            $result = ftp_delete($this->_pw_handle, $rfile);
        }
        return $result;
    }

    /**
     * Getting connection
     * @access public
     */
    function getConnection()
    {
        //サーバー接続10回リトライ
        for ($i=0; $i<10; $i++) {
            $this->_pw_handle = ftp_connect($this->_pw_host, $this->_pw_port);
            if ($this->_pw_handle) {
                //debugLog("ftp connecting ok", __CLASS__, __FILE__, __LINE__);
                break;
            }
            else {
                if ($i == 9) {
                    if (PW_EXCEPTION_DISABLED) {
                        trigger_error("FTP class connect retry over error.", E_USER_ERROR);
                    }
                    else {
                        throw new xbpwException(E_USER_ERROR, "FTP class connect retry over error.");
                    }
                }
                sleep(10);
                //debugLog("ftp connecting retry", __CLASS__, __FILE__, __LINE__);
            }
        }

        //サーバーログオン10回リトライ
        for ($i=0; $i<10; $i++) {
            $result = ftp_login($this->_pw_handle, $this->_pw_user_id, $this->_pw_pass); 
            if ($result) {
                //debugLog("ftp login ok", __CLASS__, __FILE__, __LINE__);
                break;
            }
            else {
                if ($i == 9) {
                    if (PW_EXCEPTION_DISABLED) {
                        trigger_error("FTP class logon retry over error.", E_USER_ERROR);
                    }
                    else {
                        throw new xbpwException(E_USER_ERROR, "FTP class logon retry over error.");
                    }
                }
                sleep(10);
                //debugLog("ftp login retry", __CLASS__, __FILE__, __LINE__);
            }
        }
        return true;
    }
}
