<?php
/*
 * This file is part of the somfa package.
 * (c) 2007-2008 Exbridge,inc. <info@exbridge.jp>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

/**
 * Simple O/R Mapping Class
 * PHP versions 5
 * 
 * @package SOMFA
 * @author S.Tajima<tajima@exbridge.jp> 2007/10/23 criteria構築部分を分離
 * @version svn:$Id: somfaCriteria.php 17 2009-05-09 06:21:54Z exbridge $
 * @copyright 2007-2008 Exbridge,inc.
 */
class somfaCriteria
{
    /**
     * select columns
     * @var array
     * @access public
     */
    var $_select_columns = array();

    /**
     * criterion
     * @var array
     * @access public
     */
    var $_criterion = array();

    /**
     * orderBy Columns value
     * @var integer
     * @access public
     */
    var  $_order_by_columns;

    /**
     * groupBy Columns value
     * @var string
     * @access public
     */
    var  $_group_by_columns;

    /**
     * Construct
     * @return void
     */
    function somfaCriteria()
    {
    }

    /**
     * addCriteria.
     * @access public
     */
    function addCriterion ($criterion, $comparison = 'AND')
    {
        if (count($this->_criterion) < 1) {
            $this->_criterion[] = $criterion . " ";
        }
        else {
            $this->_criterion[] = $comparison . " " . $criterion . " ";
        }
    }

    /**
     * addColumn.
     * @access public
     */
    function addColumn ($column)
    {
        $this->_select_columns[] = " " . $column . " ";
    }

    /**
     * addOrderByColumn.
     * @access public
     */
    function addOrderByColumn ($orderBy, $sortOrder = null)
    {
        if (is_null($sortOrder)) {
            $this->_order_by_columns[] = $orderBy;
        }
        else {
            $this->_order_by_columns[] = $orderBy . ' ' . $sortOrder . ' ';
        }
    }

    /**
     * addGroupByColumn.
     * @access public
     */
    function addGroupByColumn ($groupBy)
    {
        $this->_group_by_columns[] = $groupBy;
    }
}
