/**
 * name in object 構文が使えない環境で構文解析エラーを回避するためにこのメソッドを使用します。
 * 但し for( name in object ) については構文解析エラーになる環境はありません。
 * @alias X.Object.inObject
 * @function
 * @param {string|number} name 
 * @param {object} obj 
 * @return {boolean} name が定義されている(値が undefined や null でも) -> true
 */
var X_Object_inObject = X_UA[ 'IE' ] < 5.5 ? // TODO JScript で判定
	(function( name, obj, p ){
		if( obj[ name ] ) return true; // quick
		name += ''; // 数値も許可
		for( p in obj ){
			if( p === name ) return true;
		};
		return false;
	}) :
	new Function( 'a,b', 'return a in b' );


// ------------------------------------------------------------------------- //
// --- interface ----------------------------------------------------------- //
// ------------------------------------------------------------------------- //

/**
 * Object に関するメソッドを集めたものです。
 * @namespace X.Object
 * @alias X.Object
 */
X[ 'Object' ] = {
	// TODO rename to copy
	'clone'      : X_Object_clone,
	
	'override'   : X_Object_override,
	
	'clear'      : X_Object_clear,
	
	'deepCopy'   : X_Object_deepCopy,
	
	// TODO rename to X.Array.copy
	'cloneArray' : X_Object_cloneArray,
	
	'isEmpty'    : X_Object_isEmpty,
	
	'inObject'   : X_Object_inObject
	
	// TODO hasOwnProperty
};

// ------------------------------------------------------------------------- //
// --- implements ---------------------------------------------------------- //
// ------------------------------------------------------------------------- //
/**
 * 単純なクローンでメンバーをコピーしたオブジェクトを返します。 k in null でエラーになる Opera7- に対策済。
 * @alias X.Object.clone
 * @param {object|Array} src コピー元のオブジェクトです。
 * @return {object|Array}
 */
function X_Object_clone( src ){
	var ret, k;
	
	if( !src || !X_Type_isObject( src ) ) return src;
	
	ret = {};
	for( k in src ){
		//if( X_EMPTY_OBJECT[ k ] ) continue;
		ret[ k ] = src[ k ];
	};
	return ret;
};

/**
 * オブジェクトにオブジェトのメンバーをコピーします。同じ名前のメンバーは上書きされます。
 * @alias X.Object.override
 * @param {object} target コピーされるオブジェクトです。返り値はこのオブジェクトです。
 * @param {object} src コピー元のオブジェクトです。
 * @return {object} target が返る。
 */
function X_Object_override( target, src ){
	var k;
	if( !src || !X_Type_isObject( src ) ) return target;
	for( k in src ){
		//if( X_EMPTY_OBJECT[ k ] ) continue;
		target[ k ] = src[ k ];
	};
	return target;
};

/**
 * オブジェクトの全てのメンバーを破棄します。
 * @alias X.Object.clear
 * @param {object} obj。
 */
function X_Object_clear( obj, k ){
	if( obj ){
		for( k in obj ){
			delete obj[ k ];
		};
	};
};


/**
 * オブジェクト(object, Array)のメンバーを探索して、ディープコピーしたオブジェクトを返します。
 * オブジェクトが循環参照している場合は、既にコピーしているオブジェクトが現れた時点で、先に作成しているコピーの参照を返すので無限にループすることはありません。
 * @alias X.Object.deepCopy
 * @param {object|Array} src コピー元のオブジェクトです。
 * @return {object|Array}
 */
function X_Object_deepCopy( src ){		
	return X_Object_deepCopy_( src, [], [], -1 );
};

function X_Object_deepCopy_( src, objSrc, objCopy, n ) {
	var ret, i, k;
	
	if( !src ){ // 0, "", null, undefined, NaN, false
		return src;
	} else
	if( X_Type_isArray( src ) ){
		i = objSrc.indexOf( src );
		if( i !== -1 ) return objCopy[ i ];
		objSrc[ ++n ] = src;
		objCopy[ n ]  = ret = [];
	} else
	if( X_Type_isObject( src ) ){
		i = objSrc.indexOf( src );
		if( i !== -1 ) return objCopy[ i ];
		objSrc[ ++n ] = src;
		objCopy[ n ]  = ret = {};
	} else {
		// string, number, true
		return src;
	};
	for( k in src ){
		//if( X_EMPTY_OBJECT[ k ] ) continue;
		ret[ k ] = X_Object_deepCopy_( src[ k ], objSrc, objCopy, n );
	};
	return ret;
};

/**
 * 単純にメンバーをコピーした Array を返します。
 * @alias X.Object.cloneArray
 * @param {Array} ary コピー元のオブジェクトです。
 * @return {Array}
 */
function X_Object_cloneArray( ary ){
	var ret = [],
		i = ary.length;

	if( !i ) return ret;
	for( ; i; ){
		ret[ --i ] = ary[ i ];
	};
	return ret;
};

/**
 * object が空か？調べます。 object でない場合、undefined が返る
 * @alias X.Object.isEmpty
 * @param {object} v 
 * @return {boolean|undefined}
 */
function X_Object_isEmpty( v ){
	if( !v ) return;
	for( var k in v ){
		//if( X_EMPTY_OBJECT[ _k ] ) continue;
		return false;//if( v.hasOwnProperty && v.hasOwnProperty( p ) ) return false; ie4 で動かない、、、
	};
	return true;
};

/*	
X.matchTest = function( array1, array2 ){
	var i = array2.length;
	for( ; i; ){
		if( array1.indexOf( array2[ --i ] ) === -1 ) return false;
	};
	return true;
}; */
