
var X_ViewPort_readyState,
	X_ViewPort_active = !!window.parent || !!document.activeElement, // parent は frameに読み込まれた場合のieのerror回避
	X_ViewPort_activeTimerID,
	X_ViewPort_rootElement,
	X_ViewPort_lock,
	X_ViewPort_width,
	X_ViewPort_height,
	X_ViewPort_scrollX = 0,
	X_ViewPort_scrollY = 0,
	X_ViewPort_baseFontSize,
	X_ViewPort_vScrollbarSize,
	X_ViewPort_hScrollbarSize,
	
	X_ViewPort_useDetectionLoop = X_UA[ 'IE' ] < 9 || X_UA[ 'iOS' ],
	X_ViewPort_detectFontSize = !X_ViewPort_useDetectionLoop && function(){
			var size = X_Node_fontSizeNode[ '_rawObject' ].offsetHeight;
			if( X_ViewPort_baseFontSize !== size ){
				X_ViewPort_baseFontSize = size;
				X_ViewPort_baseFontSize && X_ViewPort[ 'asyncDispatch' ]( X_EVENT_BASE_FONT_RESIZED );
			};
	},

	X_ViewPort_orientationFlag,	
	X_ViewPort_orientationchange = window[ 'orientation' ] !== undefined && function( e ){
		X_ViewPort_orientationFlag = true;
		!X_UA[ 'Android' ] && X_ViewPort_resize();
		//console.log( '-- orientationchange : ' + X[ 'ViewPort' ][ 'getSize' ][ 0 ] + ' ' + X[ 'ViewPort' ][ 'getSize' ][ 1 ] );
	},
	
	X_ViewPort_document = X_EventDispatcher( document ),

X_ViewPort = X_Class_override(
	X_EventDispatcher( window ),
	{

		'handleEvent' : function( e ){
			var href, i, name, active = false;
			
			switch( e.type ){
				case 'beforeunload' :
					// ie では　a href="javascript" な要素でも beforeunload が起こる
					href = e.target && e.target[ 'attr' ] && e.target[ 'attr' ]( 'href' );
					if( href && href.indexOf && href.indexOf( 'javascript:' ) === 0 ) return X_Callback_PREVENT_DEFAULT | X_Callback_STOP_PROPAGATION;
					
					return X_ViewPort[ 'dispatch' ]( X_EVENT_BEFORE_UNLOAD );
					
				case 'unload' :
					//https://developer.mozilla.org/ja/docs/Web/JavaScript/A_re-introduction_to_JavaScript
					//Firefox 1.5 の bfcache が無効になりますので、他に理由がない限り Firefox では unload リスナを登録するべきではないことに注意してください。
					X_ViewPort[ 'dispatch' ]( X_EVENT_UNLOAD );
				//alert('unload');
					X_ViewPort_document[ 'kill' ]();
					this[ 'kill' ]();
					
					//X_System[ 'dispatch' ]( X_EVENT_SHUT_DOWN );
					break;

				case 'visibilitychange' :
					X_ViewPort[ 'dispatch' ]( ( X_ViewPort_active = document[ 'hidden' ] ) ? X_EVENT_VIEW_DEACTIVATE : X_EVENT_VIEW_ACTIVATE );
					break;
				case 'mozvisibilitychange' :
					X_ViewPort[ 'dispatch' ]( ( X_ViewPort_active = document[ 'mozHidden' ] ) ? X_EVENT_VIEW_DEACTIVATE : X_EVENT_VIEW_ACTIVATE );
					break;
				case 'webkitvisibilitychange' :
					X_ViewPort[ 'dispatch' ]( ( X_ViewPort_active = document[ 'webkitHidden' ] ) ? X_EVENT_VIEW_DEACTIVATE : X_EVENT_VIEW_ACTIVATE );
					break;

	
				case 'blur' :
				case 'focusout' :
				case 'pagehide' :				
					active = true;
				case 'focus' :
				case 'focusin' :
				case 'pageshow' :
					if( X_ViewPort_active === active ){
						X_ViewPort_active = !active;
						if( X_ViewPort_activeTimerID ){
							X_ViewPort_activeTimerID = X_Timer_remove( X_ViewPort_activeTimerID );
						} else {
							X_ViewPort_activeTimerID = X_Timer_once( 1, X_ViewPort_changeFocus );
						};
					};
					break;
			};
		}
		
	}
);

function X_ViewPort_changeFocus(){
	X_ViewPort[ 'dispatch' ]( X_ViewPort_active ? X_EVENT_VIEW_ACTIVATE : X_EVENT_VIEW_DEACTIVATE );
	X_ViewPort_activeTimerID = 0;
};


/**
 * window に相当する ViewPort 情報を提供するオブジェクト。
 * @namespace X.ViewPort
 * @alias X.ViewPort
 */
X[ 'ViewPort' ] = {
	
	'listen' : function( type, arg1, arg2, arg3 ){
		if( type <= X_ViewPort_readyState ){
			/*
			 * X_EVENT_XDOM_READY 以後に listen した場合の対策
			 */
			X_ViewPort[ 'asyncDispatch' ]( type );
		};
		// ie8-では keydown -> documentへ
		type && arg1 && X_ViewPort[ 'listen' ]( type, arg1, arg2, arg3 );
		return X[ 'ViewPort' ];
	},
	
	
	'listenOnce' : function( type, arg1, arg2, arg3 ){
		if( type <= X_ViewPort_readyState ){
			/*
			 * X.Event.XDOM_READY 以後に listen した場合の対策
			 */
			X_ViewPort[ 'asyncDispatch' ]( type );
		};
		type && arg1 && X_ViewPort[ 'listenOnce' ]( type, arg1, arg2, arg3 );
		return X[ 'ViewPort' ];
	},
	
	'unlisten' : function( type, arg1, arg2, arg3 ){
		type && arg1 && X_ViewPort[ 'unlisten' ]( type, arg1, arg2, arg3 );
		return X[ 'ViewPort' ];
	},
	
	'listening' : function( type, arg1, arg2, arg3 ){
		return X_ViewPort[ 'listening' ]( type, arg1, arg2, arg3 );
	},
	
	// hammer のテストファイルだけが使用
	'asyncDispatch' : function(){
		return X_ViewPort[ 'asyncDispatch' ].apply( X_ViewPort, arguments );
	},
	
	'getPointerPosition' : function(){
		
	},
	
	/* 要素が視界に入った  http://remysharp.com/2009/01/26/element-in-view-event-plugin/
	 * TODO -> Node.call('inView')
	 */
	'inView' : function( elm ){
		
	},
	
	'getSize' : function(){
		return [ X_ViewPort_width, X_ViewPort_height ];
	},
//https://developer.mozilla.org/en-US/docs/Web/API/Element.getBoundingClientRect
//use window.pageXOffset and window.pageYOffset instead of window.scrollX and window.scrollY
//(((t = document.documentElement) || (t = document.body.parentNode)) && typeof t.ScrollLeft == 'number' ? t : document.body).ScrollLeft;
//(((t = document.documentElement) || (t = document.body.parentNode)) && typeof t.ScrollTop == 'number' ? t : document.body).ScrollTop
	
	'getDocumentSize' : function(){
		// Opera は互換モードでは document.body.scrollHeight、標準モードでは document.documentElement.scrollHeight でページの高さが取れる。と思ってたんだけど、例外があった。
		// http://orera.g.hatena.ne.jp/edvakf/20100515/1273908051
	//http://onozaty.hatenablog.com/entry/20060803/p1
	// Safari2.0.4では標準・互換どちらも document.body
		
		X_Node_updateTimerID && X_Node_startUpdate();
		/*X_UA[ 'Opera' ] ?
			( document.documentElement && document.documentElement.clientWidth ?
				new Function( 'return[document.documentElement.clientWidth,document.documentElement.clientHeight]' ) :
				new Function( 'return[document.body.clientWidth,document.body.clientHeight]' )
			) :*/			
		return [
			X_ViewPort_rootElement.scrollWidth  || X_ViewPort_rootElement.offsetWidth,
			X_ViewPort_rootElement.scrollHeight || X_ViewPort_rootElement.offsetHeight
		];
	},
	
	'getScrollPosition' :
		window.pageXOffset !== undefined ?
			( function(){
				X_Node_updateTimerID && X_Node_startUpdate();
				return[ X_ViewPort_scrollX = window.pageXOffset, X_ViewPort_scrollY = window.pageYOffset ];
			} ) :
		window.scrollLeft  !== undefined ?
			( function(){
				X_Node_updateTimerID && X_Node_startUpdate();
				return[ X_ViewPort_scrollX = window.scrollLeft, X_ViewPort_scrollY = window.scrollTop ];
			} ) :
			( function(){
				X_Node_updateTimerID && X_Node_startUpdate();
				// body は Safari2-
				return[ X_ViewPort_scrollX = X_ViewPort_rootElement.scrollLeft || document.body.scrollLeft, X_ViewPort_scrollY = X_ViewPort_rootElement.scrollTop || document.body.scrollTop ];
			} ),

	'getScrollbarSize' : function(){
		return [ X_ViewPort_vScrollbarSize, X_ViewPort_hScrollbarSize ];	
	},
	
	'getBaseFontSize' : function(){
		if( X_Node_updateTimerID ){
			X_Node_startUpdate();
			return X_ViewPort_baseFontSize = X_Node_fontSizeNode[ '_rawObject' ].offsetHeight;
		};
		return X_ViewPort_baseFontSize;
	}
	
};



/* -----------------------------------------------
 * Resize
 *  original : uupaa.js
 * 
 * TODO
 *  https://w3g.jp/blog/studies/ios7_1_minimal-ui_warning
 *  iOS7.0からあったiPad Safariの高さ100%コンテンツでlandscape（横向き）時に起きる不具合
 * 
 * http://looxu.blogspot.jp/2013/11/ios7mobile-safariwindowinnerheight.html
 * iOS7にて、Mobile Safariのwindow.innerHeightを正しく取得する方法
 * 
 *  http://tenderfeel.xsrv.jp/javascript/1182/
 *  アドレスバーの高さの算出
 * 
 * http://sssslide.com/www.slideshare.net/hiroakiwakamatsu/javascript-14514208
 * 1. 傾き時の画面サイズ取得ー 対処方法の例
 * (1)ー? タイマーを使って、画面サイズ取得の タイミングを少しだけ遅延させる
 * window.onorientationchange = function() { setTimeout(function() { alert("W: " + window.innerWidth + ", H: " + window.innerHeight); }, 200); }
 * 横に傾けた時、正常に横向け時の 幅と高さが取得できている ただし、端末によってはうまく取得できな い場合がある(Galaxy S IIIとか・・・) 7 
 * 
 * http://sssslide.com/www.slideshare.net/hiroakiwakamatsu/ss-12718639
 * 
 * 
 * getBoundingClientRect で　fontsize の調査
 */
		var X_ViewPort_resize =
			// iOS もループで回す,,,iOS3.1.3, iOS6 で確認
			X_ViewPort_useDetectionLoop ?
				(function(){
					var size;
					if( !X_ViewPort_lock ){
						size = X_ViewPort_getWindowSize();
						if( X_ViewPort_width !== size[ 0 ] || X_ViewPort_height !== size[ 1 ] ){
							X_ViewPort_width = size[ 0 ];
							X_ViewPort_height = size[ 1 ];
							X_Timer_once( 100, X_ViewPort_detectFinishResizing );
							X_ViewPort_lock = true;
						};
					};
					
					size = X_Node_fontSizeNode[ '_rawObject' ].offsetHeight;
					if( X_ViewPort_baseFontSize !== size ){
						X_ViewPort_baseFontSize && X_ViewPort[ 'asyncDispatch' ]( X_EVENT_BASE_FONT_RESIZED );
						X_ViewPort_baseFontSize = size;
					};
					
				}) :
				(function( e ){
					console.log( '-- resize : ' + X_Timer_now() );
					
					!X_ViewPort_lock && ( X_ViewPort_lock = true ) && X_Timer_once( 100, X_ViewPort_detectFinishResizing );
					return X_Callback_PREVENT_DEFAULT | X_Callback_STOP_PROPAGATION;
				});
		
		function X_ViewPort_detectFinishResizing(){
			var size = X_ViewPort_getWindowSize();
			if( X_ViewPort_width !== size[ 0 ] || X_ViewPort_height !== size[ 1 ] ){
				X_ViewPort_width  = size[ 0 ];
				X_ViewPort_height = size[ 1 ];
				X_Timer_once( 100, X_ViewPort_detectFinishResizing );
			} else {
				console.log( '-- detectFinishResizing : ' + X_Timer_now() );
				
				X_ViewPort[ 'asyncDispatch' ]( X_EVENT_VIEW_RESIZED );
				X_ViewPort_lock = false;
				if( X_ViewPort_orientationFlag ){
					X_ViewPort_orientationFlag = false;
					X_ViewPort[ 'asyncDispatch' ]( 100, { type : X_EVENT_VIEW_TURNED, 'orientation' : window.orientation } );
				};
			};
		};

		X_TEMP.onDomContentLoaded = function(){
			var s, size, elmHtml, elmHead, elmBody, html, head, body;
			
			console.log( '> X_TEMP.onDomContentLoaded rs:' + X_ViewPort_readyState );
			
			if( X_EVENT_PRE_INIT <= X_ViewPort_readyState ) return X_Callback_UN_LISTEN;
			X_ViewPort_readyState = X_EVENT_PRE_INIT;
			
			// DOMContentLoaded の無いブラウザで X_TEMP.onDomContentLoaded への参照が残り続けるのを回避
			X_TEMP.onDomContentLoaded && X_ViewPort_document[ 'unlisten' ]( 'DOMContentLoaded', X_TEMP.onDomContentLoaded );
			delete X_TEMP.onDomContentLoaded;
			
			elmHtml = document.documentElement ||
				X_UA_DOM.W3C ? document.getElementsByTagName( 'html' )[ 0 ] :
				X_UA_DOM.IE4 ? document.all.tags( 'html' )[ 0 ] : null;
			
			elmHead = 
				X_UA_DOM.W3C ? document.getElementsByTagName( 'head' )[ 0 ] :
				X_UA_DOM.IE4 ? document.all.tags( 'head' )[ 0 ] : null;

			elmBody = document.body;

			X_ViewPort_rootElement = document.compatMode !== 'CSS1Compat' ? elmBody : elmHtml || elmBody;

	/**
	 * Node( documentElement )
	 * @alias X.Doc.html
	 * @type {Node}
	 */
			X[ 'Doc' ][ 'html' ] = html = X_Node_html = elmHtml && Node( elmHtml )[ 'removeClass' ]( 'js-disabled' )[ 'addClass' ]( X_UA_classNameForHTML );
			html[ '_flags' ] |= X_NodeFlags_IN_TREE;

	/**
	 * Node( head )
	 * @alias X.Doc.head
	 * @type {Node}
	 */			
			X[ 'Doc' ][ 'head' ] = head = X_Node_head = elmHead && Node( elmHead );

	/**
	 * Node( documentElement )
	 * @alias X.Doc.body
	 * @type {Node}
	 */		
			X[ 'Doc' ][ 'body' ] = body = X_Node_body = Node( elmBody );

			body[ 'parent ' ] = head[ 'parent' ] = html;
			html[ '_xnodes' ] = [ head, body ];
			
			html[ 'appendTo' ] = html[ 'prev' ] = html[ 'next' ] = html[ 'clone' ] = html[ 'remove' ] = html[ 'destroy' ] =
			html[ 'create' ] = html[ 'createText' ] = html[ 'createAt' ] = html[ 'createTextAt' ] = html[ 'append' ] = html[ 'appendAt' ] = html[ 'empty' ] = html[ 'html' ] = html[ 'text' ] =
			html[ 'css' ] = html[ 'cssText' ] =
			head[ 'appendTo' ] = head[ 'prev' ] = head[ 'next' ] = head[ 'clone' ] = head[ 'remove' ] = head[ 'destroy' ] =
			head[ 'createText' ] = head[ 'createTextAt' ] = head[ 'empty' ] = head[ 'html' ] = head[ 'text' ] = head[ 'css' ] = head[ 'cssText' ] =
			body[ 'appendTo' ] = body[ 'prev' ] = body[ 'next' ] = body[ 'clone' ] = body[ 'remove' ] = body[ 'destroy' ] = new Function( 'return this' );

			X_ViewPort[ 'listenOnce' ]( X_EVENT_PRE_INIT, function(){
				X_ViewPort_readyState = X_EVENT_XTREE_READY;
				if( X_TEMP.X_Dom_useBuilder ) X_TEMP.X_Dom_useBuilder = !!document.body.children.length;
				!X_TEMP.X_Dom_useBuilder && X_ViewPort[ 'asyncDispatch' ]( X_EVENT_XTREE_READY );
			} );
			
			X_ViewPort[ 'listenOnce' ]( X_EVENT_XTREE_READY, function(){
				X_ViewPort_readyState = X_EVENT_INIT;
				//X_UA[ 'Opera7' ] && alert( 'bc' );
				X_Node_body[ 'appendAt' ]( 0,
					X_Node_systemNode = X_Doc_create( 'div', { 'class' : 'hidden-system-node' } ),
					X_Node_fontSizeNode = X_Doc_create( 'div', { 'class' : 'hidden-system-node' } )[ 'cssText' ]( 'line-height:1;height:1em;' )[ 'text' ]( 'X' )
				);
				X_Node_startUpdate();

				X_ViewPort[ 'asyncDispatch' ]( X_EVENT_INIT );
			} );

			X_ViewPort[ 'listenOnce' ]( X_EVENT_INIT, function(){
				var size = X_ViewPort_getWindowSize(),
				
				// http://jsdo.it/imaya/kTYg
					body = document.body,
					defaultOverflow = document.body.style.overflow,
					w, h;
			
				X_ViewPort_width  = size[ 0 ];
				X_ViewPort_height = size[ 1 ];
			
				body.style.overflow = 'hidden';
				w = body.clientWidth;
				h = body.clientHeight;
			
				body.style.overflow = 'scroll';
				w -= body.clientWidth;
				h -= body.clientHeight;
			
				if( !w ) w = body.offsetWidth  - body.clientWidth;
				if( !h ) h = body.offsetHeight - body.clientHeight;
				body.style.overflow = defaultOverflow; 
			
				X_ViewPort_vScrollbarSize = w;
				X_ViewPort_hScrollbarSize = h;
				if( h <= 0 ){ // ie6, ie11, firefox で　負の値が返る
					console.log( 'invalid hScrollbarSize: ' + h );
					X_ViewPort_hScrollbarSize = w;
				};
				
				//
				if( X_ViewPort_orientationchange ){
					X_EventDispatcher_systemListen( X_ViewPort, 'orientationchange', X_ViewPort_orientationchange );
				};
				
				if( X_ViewPort_detectFontSize ){
					X_EventDispatcher_systemListen( X_ViewPort, 'resize', X_ViewPort_resize );
					X_Timer_add( 333, X_ViewPort_detectFontSize );
				} else {
					X_Timer_add( 333, X_ViewPort_resize );
				};
				
				X_ViewPort_baseFontSize = X_Node_fontSizeNode[ '_rawObject' ].offsetHeight;

				X_ViewPort[ 'asyncDispatch' ]( X_ViewPort_readyState = X_EVENT_XDOM_READY );
			} );

			X_ViewPort[ 'asyncDispatch' ]( X_EVENT_PRE_INIT );	


			X_EventDispatcher_systemListen( X_ViewPort, [ 'beforeunload', 'unload' ] );

//ブラウザの戻るボタンで戻ったときに呼ばれるイベントとかキャッシュとかそこらへんのこと
//http://d.hatena.ne.jp/koumiya/20080916/1221580149

			if( document[ 'hidden' ] !== undefined ){// iOS 7+
				X_EventDispatcher_systemListen( X_ViewPort_document, 'visibilitychange', X_ViewPort );
			} else
			if( document[ 'mozHidden' ] !== undefined ){
				X_EventDispatcher_systemListen( X_ViewPort_document, 'mozvisibilitychange', X_ViewPort );
			} else
			if( document[ 'webkitHidden' ] !== undefined ){
				X_EventDispatcher_systemListen( X_ViewPort_document, 'webkitvisibilitychange', X_ViewPort );
			} else
			if( X_UA[ 'iOS' ] && window[ 'onpageshow' ] !== undefined ){
				X_EventDispatcher_systemListen( X_ViewPort, [ 'pageshow', 'pagehide' ] );
			} else
			if( document[ 'onfocusin' ] !== undefined ){
				// https://github.com/ai/visibilityjs/blob/master/lib/visibility.fallback.js
				X_EventDispatcher_systemListen( X_ViewPort_document, [ 'focusin', 'focusout' ], X_ViewPort );
			} else {
				X_EventDispatcher_systemListen( X_ViewPort, [ 'focus', 'blur' ] );
			};

			return X_Callback_UN_LISTEN;
		};

		function X_ViewPort_getWindowSize(){
			return X_UA[ 'IE' ] ? // Opera10.1 では ズーム時に表示領域のサイズが取れない！
				[ X_ViewPort_rootElement.clientWidth, X_ViewPort_rootElement.clientHeight ] :
				X_UA[ 'Opera' ] < 12 ? // Opera10.1 では ズーム + resize 時に表示領域のサイズが取れない！
				[ X_ViewPort_rootElement.offsetWidth, X_ViewPort_rootElement.offsetHeight ] :
				[ window.innerWidth, window.innerHeight ];
		};


console.log( 'X.Dom dom:w3c=' + X_UA_DOM.W3C + ' ev:w3c=' + X_UA_EVENT.W3C );

/* -----------------------------------------------
 * Document Ready
 *  Dean Edwards/Matthias Miller/John Resig
 */

// SafariでJavaScriptのデバッグをする方法
// safari1.3 可
// http://shimax.cocolog-nifty.com/search/2006/09/safarijavascrip_c54d.html

/* for ie9+/Mozilla/Opera9 */
if( X_UA_EVENT.W3C ){
	X_ViewPort_document[ 'listenOnce' ]( 'DOMContentLoaded', X_TEMP.onDomContentLoaded );
} else
if( 6 <= X_UA[ 'IE' ] && X[ 'inHead' ] ){
	// if this script in Head
	document.write( "<script id=__ie_onload defer src=javascript:void(0)><\/script>" );
	X_TEMP._script = document.getElementById( "__ie_onload" );
	X_TEMP._script.onreadystatechange = function(){
		var s = X_TEMP._script;
		if( s && s.readyState === 'complete' ){
			s.onreadystatechange = X_emptyFunction;
			s.onreadystatechange = null;
			s.parentNode.removeChild( s );
			delete X_TEMP._script;
			X_TEMP.onDomContentLoaded && X_TEMP.onDomContentLoaded();
		};
	};
};
// Re: onLoad doesn't work with Safari?
// http://lists.apple.com/archives/web-dev/2003/Oct/msg00036.html
if( X_UA[ 'WebKit' ] || X_UA[ 'Safari' ]  < 3 ){ // sniff
	X_Timer_add( 16, function(){
		if( !X_TEMP.onDomContentLoaded ) return X_Callback_UN_LISTEN;
		if( document.readyState === 'loaded' || document.readyState === 'complete' ) return X_TEMP.onDomContentLoaded();
	});
};

/* for other browsers */
X_ViewPort[ 'listenOnce' ]( 'load', X_TEMP.onDomContentLoaded );
