//{+xhr"XHR,XDR,MSXMLによる通信"(XMLHTTPRequest, XDomainRequest, ActiveX-MSXML を使った通信)[+net]

// https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest
// https://web.archive.org/web/20071101021832/http://web.paulownia.jp/script/ajax/xmlhttp4.html
// https://web.archive.org/web/20091029170015/http://wiki.paulownia.jp/ajax/xmlhttprequest
/* 
 * http://ponpon-village.net/ajax/xmlhttp.htm
 * IE のバージョンによっては、ActiveXObject("Msxml2.XMLHTTP.5.0") , ActiveXObject("Msxml2.XMLHTTP.4.0") ,
ActiveXObject("Msxml2.XMLHTTP.3.0") , ActiveXObject("Msxml2.XMLHTTP") なども使用出来る。

http://vird2002.s8.xrea.com/javascript/XMLHttpRequest.html
// --- 使うべきオブジェクト
new ActiveXObject( 'Msxml2.XMLHTTP.3.0' ); // バージョン3.0 広範に利用されているので、今後も bugfix を行う
new ActiveXObject( 'Msxml2.XMLHTTP.6.0' ); // バージョン6.0 は最新版なので bugfix を続ける

// --- 使うべきではないオブジェクト
new ActiveXObject( 'Microsoft.XMLHTTP' );  // Microsoft接頭辞は古いので指定すべきではない
new ActiveXObject( 'Msxml.XMLHTTP' );      // Msxml2接頭辞を指定すべき
new ActiveXObject( 'Msxml2.XMLHTTP' );     // バージョンを省略すると 3.0 として扱われるので、バージョンは明記すべき
new ActiveXObject( 'Msxml2.XMLHTTP.4.0' ); // バージョン4.0 は bugfix が行われないので、3.0 か 6.0 を指定すべき
new ActiveXObject( 'Msxml2.XMLHTTP.5.0' ); // バージョン5.0 は bugfix が行われないので、3.0 か 6.0 を指定すべき

[IE][Javascript][Json] IE+Jsonではまった
http://d.hatena.ne.jp/khiker/20081026/javascript_json
> AddCharset utf-8 json
> AddType text/javascript json

JavaScriptでJSONをeval
http://d.hatena.ne.jp/sshi/20060904/p1

itozyun 2014-10-30 20:55:41
basic 認証のかかったhtml を表示して、そのjsが xhr をすると Android1.6 では 401 error が返る。Android 2.3 では解決している。
Android1.6- の XHR で 401 エラーが返った場合は、iframe に xml を表示させてその内容を取ればサーバ側の対応無しでいけるかも？

IE9 で 画像バイナリの取得 VBA をかましている
http://web.archive.org/web/20130808105151/http://gurimmer.lolipop.jp/daihakken/2012/05/22/javascriptajaxxmlhttprequest%E3%82%92%E4%BD%BF%E3%81%A3%E3%81%9Fajax%E3%81%AE%E3%82%A8%E3%83%B3%E3%82%B3%E3%83%BC%E3%83%89
http://d.hatena.ne.jp/maachang/20130221/1361427565

http://web.archive.org/web/20130531162446/http://gurimmer.lolipop.jp/daihakken/2012/06/25/ajaxjavascript%E3%83%8D%E3%82%A4%E3%83%86%E3%82%A3%E3%83%96xmlhttp%E3%82%B5%E3%83%9D%E3%83%BC%E3%83%88%E3%81%A8%E3%81%AF/

IE8 以下で xhr の失敗率が高い問題 
http://tkengo-totoro.blogspot.jp/2011/11/iexmlhttprequest.html
TODO クライアント側にもリトライ機構を入れてみる

 */
var // Opera7.6+, Safari1.2+, khtml3.?+, Gecko0.9.7+
	// ie9- ではローカルリソースには MSXML を使う
	X_Net_XHR_createW3C   = window[ 'XMLHttpRequest' ] && function(){ return X_Net_XHR_w3c || ( X_Net_XHR_w3c = new XMLHttpRequest() ); },
	X_Net_XHR_w3c         = X_Net_XHR_createW3C && X_Net_XHR_createW3C(),
	X_Net_XHR_cors        = X_Net_XHR_w3c && X_Net_XHR_w3c.withCredentials !== undefined,
	X_Net_XHR_progress    = X_Net_XHR_w3c && X_Net_XHR_w3c.onprogress !== undefined,
	X_Net_XHR_upload      = X_Net_XHR_w3c && !!X_Net_XHR_w3c.upload,
	
	X_Net_XHR_createXDR   = window[ 'XDomainRequest' ] && function(){ return X_Net_XHR_xdr || ( X_Net_XHR_xdr = new XDomainRequest() ); },
	X_Net_XHR_xdr         = X_Net_XHR_createXDR && X_Net_XHR_createXDR(),

	// ie11の互換モード(7,8)の msxml はいまいち動かない
	X_Net_XHR_createMSXML = X_UA[ 'ActiveX' ] && ( X_UA[ 'IE5x' ] || X_UA[ 'IE6' ] || X_URL_IS_LOCAL ) &&
		( new Function( 'f', [
			'var x=".XMLHTTP",',
				'm="MSXML2"+x,',
				'n=[m+".6.0",m+".3.0",m+".5.0",m+".4.0",m,"Microsoft"+x],',
				'v=[6,3,5,4,2,1],',
				'a=ActiveXObject,',
				'i=-1;',
			'for(;i<5;){',
				'try{',
					'return f?[v[++i],new a(n[i])]:new a(n[i])',
				'}catch(e){}',
			'}'
		].join( '' ) ) ),

	X_Net_XHR_msXMLVer    = 0,	
	X_Net_XHR_msXML       = X_Net_XHR_createMSXML && X_Net_XHR_createMSXML( true ),
	
	X_Net_XHR_neverReuse  = X_UA[ 'IE' ] < 9, // ie7,8 の xhr はリユース不可。msxml はリユース可能。
	
	X_Net_XHR_TYPE_FLASH  = 8,
	X_Net_XHR_TYPE_GADGET = 16;

if( X_Net_XHR_msXML ){
	X_Net_XHR_msXMLVer = X_Net_XHR_msXML[ 0 ];
	X_Net_XHR_msXML    = X_Net_XHR_msXML[ 1 ];
} else {
	X_Net_XHR_createMSXML = null;
};

X[ 'XHR' ] = {

	'W3C'         : X_Net_XHR_createW3C   ? 1 : 0,
	'MSXML'       : X_Net_XHR_createMSXML ? 2 : 0,
	'XDR'         : X_Net_XHR_createXDR   ? 4 : 0,

/*
 * http://hakuhin.jp/as/import.html
 * ファイルの読み込みについて(4 or 5 or 6+)
 * http://hakuhin.jp/as/javascript.html
 * Flash から JavaScript にアクセスする(3+)
 */
	'FLASH'       : X_Pulgin_FLASH_ENABLED && 4 <= X_Pulgin_FLASH_VERSION ? 8 : 0,
	
	'GADGET'      : 5.5 <= X_UA[ 'IE' ] || !X_UA[ 'IE' ] ? 16 : 0,

/**
 * https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest
 * Progress Events 	Chrome7, firefox3.5, ie10, opera12, Safari?, Chrome for Android 0.16
 */
	'PROGRESS'        : X_Net_XHR_progress,

	'UPLOAD_PROGRESS' : X_Net_XHR_upload,

	// or gadget proxy or flash
	'CORS'            : X_Net_XHR_xdr || X_Net_XHR_cors
};

if( X_Net_XHR_msXMLVer ) X[ 'XHR' ][ 'MSXML_VERSION' ] = X_Net_XHR_msXMLVer;

if( X_Net_XHR_w3c || X_Net_XHR_msXML ){

X_TEMP.X_Net_XHR_init = function(){
	X_NET_XHRWrapper = X_Class_override( X_EventDispatcher(), X_TEMP.X_Net_XHR_params, true );
	
	delete X_TEMP.X_Net_XHR_init;
	delete X_TEMP.X_Net_XHR_params;	
	
	return X_NET_XHRWrapper;
};

X_TEMP.X_Net_XHR_params = {
			
			'_rawType'   : X_EventDispatcher_EVENT_TARGET_XHR,
			
			_isXDR       : false,
			_isMsXML     : false,
			
			_method      : '',
			_dataType    : '',
			_busy        : false,
			_canceled    : false,
			_error       : false,
			_percent     : 0,
			_timerID     : 0,
			
			load : function( obj ){
				var raw      = this[ '_rawObject' ],
					method   = obj[ 'method' ],
					url      = obj[ 'url' ],
					async    = obj[ 'async' ] !== false,
					username = obj[ 'username' ],
					password = obj[ 'password' ],
					headers  = obj[ 'headers' ] || {},
					postdata = obj[ 'postdata' ] || '',
					timeout  = obj[ 'timeout' ] || 20000,
					noCache  = obj[ 'cache' ] !== true,
					xDomain  = !X_URL_isSameDomain( url ),
					isFile   = X_URL_isLocal( url ),
					init,
					tmp, p;

				this._dataType = obj[ 'dataType' ];
				
				if( !raw || xDomain !== this._isXDR || ( X_Net_XHR_createMSXML && isFile !== this._isMsXML ) ){
					raw && this[ 'unlisten' ]( [ 'load', 'readystatechange', 'progress', 'error', 'timeout' ] );
					init = true;
					this[ '_rawObject' ] = raw = xDomain ?
													( X_Net_XHR_cors ?
														X_Net_XHR_createW3C() :
														X_Net_XHR_createXDR()
													) :
												 isFile ?
												 	( X_Net_XHR_createMSXML ?
														( X_Net_XHR_msXML = X_Net_XHR_msXML || X_Net_XHR_createMSXML() ):
														X_Net_XHR_createW3C()
													 ) :
												 X_Net_XHR_createW3C ?
													X_Net_XHR_createW3C() :
													( X_Net_XHR_msXML = X_Net_XHR_msXML || X_Net_XHR_createMSXML() );

					// raw === XDR これは　error になるのでフラグに控える
					this._isXDR   = X_Net_XHR_createXDR && xDomain;
					this._isMsXML = !X_Net_XHR_createW3C || ( isFile && X_Net_XHR_createMSXML );
				};
				
				raw.open( method, url, async, username, password );
				
				if( raw.responseType !== undefined ){
					switch( this._dataType ){
						case '' :
						case 'text' :
						// js, css
							raw.responseType = 'text';
							break;
						case 'json' :
						case 'moz-json' : // firefox9-
							raw.responseType = X_UA[ 'Gecko' ] ? this._dataType : ''; // Iron 37 でエラー
							break;
						case 'document' :
						case 'xml' :
						case 'html' :
						case 'htm' :
						// svg
							raw.responseType = 'document';
							break;
						case 'blob' :
						case 'arraybuffer' :
						// jpeg,jpg,png,gif,mp3,ogg...
							raw.responseType = this._dataType;
							break;
					};
				};
				
				// http://www.quirksmode.org/blog/archives/2005/09/xmlhttp_notes_r_1.html
				if( !this._isMsXML && raw.overrideMimeType ){	
					switch( X_URL_getEXT( url ) ){
						case 'html' :
						case 'xml' :
							tmp = 'text/xml';
							break;

						case 'mp3' :
							tmp = 'audio/mpeg';
							break;
						case 'opus' :
						case 'ogg' :
							tmp = 'audio/ogg';
							break;
						case 'wav' :
							tmp = 'audio/wav';
							break;							
						case 'aac' :
							tmp = 'audio/aac';
							break;
						case 'm4a' :
							tmp = 'audio/x-m4a"';
							break;	
						case 'mp4' :
							tmp = 'audio/x-mp4';
							break;	
						case 'weba' :
							tmp = 'audio/webm';
							break;
					};
					if( tmp = obj[ 'mimeType' ] || tmp ) raw.overrideMimeType( tmp );
				};

				if( !this._isXDR && ( this._isMsXML ? 3 <= X_Net_XHR_msXMLVer : raw.setRequestHeader ) ){ // msxml は setRequestHeader getter がいけない
					
					/*
					if( noCache ){
						headers[ 'Pragma' ] = 'no-cache';
						headers[ 'Cache-Control' ] = 'no-cache';
						headers[ 'If-Modified-Since' ] = 'Thu, 01 Jun 1970 00:00:00 GMT';
					} else */					
					// http://nakigao.sitemix.jp/blog/?p=2040
					// json 取得時に SafariでHTTP/412のエラー。但し相手が audio の場合、この指定があるとロードに失敗する。 iOS8.2, iOS7.1 では遭遇せず
					if( this._dataType === 'json' ){
						headers[ 'If-Modified-Since' ] = ( new Date ).toUTCString();
					};
					
					// http://boscono.hatenablog.com/entry/2013/12/23/152851
					if ( !xDomain && !headers[ 'X-Requested-With' ] ) {
						headers[ 'X-Requested-With' ] = 'XMLHttpRequest';
					};
					
					if( method === 'POST' && !headers[ 'Content-Type' ] ){
						headers[ 'Content-Type' ] = 'application/x-www-form-urlencoded';
					};

					
					for( p in headers ){
						if( X_EMPTY_OBJECT[ p ] ) continue;
						//console.log( headers[ p ] );
						headers[ p ] !== undefined && raw.setRequestHeader( p, headers[ p ] + '' ); // Opera8.01+, MSXML3+
					};
				};
				
				if( !this._isMsXML && raw.timeout !== undefined ){
					raw.timeout = timeout;
				} else {
					this._timerID = X_Timer_once( timeout, this, this.onTimeout );
				};	
				
				// send 前にフラグを立てる,回線が早いと raw.send() 内で onload -> _busy = false ののち、 _busy = true するため。
				this._busy = true;

				raw.send( X_Type_isString( postdata ) ? postdata : X_String_serialize( postdata ) );

				if( !async || raw.readyState === 4 ){
					X_Timer_once( 32, this, this.handleEvent, [ { type : 'readystatechange' } ] );
				} else
				if( init ){
					if( this._isMsXML ){
						raw[ 'onreadystatechange' ] = X_NET_XHRWrapper.handleEvent;
					} else
					if( X_Net_XHR_progress || this._isXDR ){
						this[ 'listen' ]( [ 'load', 'progress', 'error', 'timeout' ] ); //, 'abort'
					} else
					if( X_UA[ 'IE8' ] ){
						this[ 'listen' ]( [ 'readystatechange', 'error', 'timeout' ] );
					} else
					if( X_UA[ 'IE7' ] ){
						this[ 'listen' ]( [ 'readystatechange', 'error' ] );
					
					} else {
						this[ 'listen' ]( [ 'load', 'readystatechange', 'error', 'timeout' ] ); //, 'abort'
					};
				
					if( X_Net_XHR_upload ){
						raw.upload.addEventListener( 'progress', this.onUploadProgress );
					};
				};
			},
			
			cancel : function(){
				/* this[ '_rawObject' ].abort && */ this[ '_rawObject' ].abort();
				this._canceled = true;
			},
			
			reset : function(){
				
				this._method   = this._dataType = '';
				this._canceled = this._busy = this._error = false;
				this._timerID && X_Timer_remove( this._timerID );
				this._percent  = this._timerID = 0;
				
				// XMLHttpRequest の使い方
				// http://webos-goodies.jp/archives/50548720.html
				// XMLHttpRequest オブジェクトを再利用する際も、 abort メソッドを呼び出す必要があるようです。
				/* this[ '_rawObject' ].abort && */ this[ '_rawObject' ].abort();	
				
				// XMLHttpRequest で順番にリソースを取得する
				// http://note.chiebukuro.yahoo.co.jp/detail/n16248
				// Opera 10.10 と Safari 4.1 はエラーが起きた XHR を再利用できないので毎回作る
				
				// 
				// domes.lingua.heliohost.org/dom-intro/load-save2.html
				// 規定上は open() を呼び出すと XMLHttpRequest オブジェクトが未送信状態に戻りますが、
				// Opera 10.10、Safari 4.1 では、同一オリジン制限に違反した XMLHttpRequest オブジェクトは再度 open() しても未送信状態に戻りません。
				
				// Timeout した Gecko の xhr.response に触るとエラー??

				if( this._error || ( X_Net_XHR_neverReuse && !this._isMsXML ) ){
					
					if( X_Net_XHR_upload ){
						X_Net_XHR_w3c.upload.removeEventListener( 'progress', this.onUploadProgress );
					};

					// ie7 は xhr object を再利用できない。但し send のあとに alert を挟むと動いた、、、
					// ie7モード(IE11) では再利用可能、、、
										
					X_EventDispatcher_toggleAllEvents( this, false );
					this[ '_rawObject' ] = null;
					
					if( this._isXDR ){
						X_Net_XHR_xdr   = null;
						delete this._isXDR;
					} else {
						X_Net_XHR_w3c   = null;
					};				

					this[ 'unlisten' ]( [ 'load', 'readystatechange', 'progress', 'error', 'timeout' ] );
				};
			},
			
			handleEvent : function( e ){
				var raw  = X_NET_XHRWrapper[ '_rawObject' ],
					live = !X_NET_XHRWrapper._canceled,
					headers, status, data;

				switch( e && e.type || 'readystatechange' ){
					/*
					 * http://memopad.bitter.jp/w3c/ajax/ajax_xmlhttprequest_onreadystatechange.html
					readyState 	XMLHttpRequest のステータスを保持する。0 から 4 までに変化する:
					0: リクエストは初期化されていない
					1: サーバ接続は確立した
					2: リクエストを受信した
					3: リクエストの処理中
					4: リクエストは終了してレスポンスの準備が完了
					status 	200: "OK"
					404: Page not found
					
					If-Modified-Sinceヘッダを利用してWebページのキャッシュを行うXMLHttpRequestラッパー
					http://www.semblog.org/msano/archives/000407.html
					* */		
					case 'readystatechange' :
						//if( !X.XHR.PROGRESS ){
							switch( raw.readyState ){
								case 0 :
								case 1 :
									return;
								case 2 : // 0% ajaxstart
									live && X_NET_XHRWrapper[ 'asyncDispatch' ]( { type : X_EVENT_PROGRESS, 'percent' : 0 } );
									return;
								case 3 :
									live && X_NET_XHRWrapper[ 'asyncDispatch' ]( { type : X_EVENT_PROGRESS, 'percent' : X_NET_XHRWrapper._percent < 99.9 ? 99.9 : ( X_NET_XHRWrapper._percent + 100 ) / 2 } );
									// 99.9%
									return;
								case 4 :
									if( X_NET_XHRWrapper._percent === 100 ) return; // Opera8 readystatechange が2重に発生
									// 100%
									break; // load へ
								default :
									// error
									return;
							};						
						//};
	
					case 'load' :

						if( !X_NET_XHRWrapper._busy ) return;
						
						X_NET_XHRWrapper._percent = 100;
						X_NET_XHRWrapper._busy    = false;
						status        = raw.status;
						
						// TODO GET_FULL_HEADERS
						// https://msdn.microsoft.com/en-us/library/ms766595%28v=vs.85%29.aspx
						// Implemented in: MSXML 3.0 and MSXML 6.0
						if( X_NET_XHRWrapper._isXDR ){
							headers = { 'Content-Type' : raw.contentType };
						} else
						if( ( X_NET_XHRWrapper._isMsXML ? 3 <= X_Net_XHR_msXMLVer : raw.setRequestHeader ) && ( headers = raw.getAllResponseHeaders() ) ){
							headers = X_NET_XHR_parseResponseHeaders( headers );
						};
						
						// https://code.google.com/p/fakeworker-js/source/browse/src/javascript/fakeworker.js
						if(
							( !status && location.protocol === 'file:' ) ||
							// IE 6.0 でローカルファイルにアクセスした
							( status < 100 && ( status = 200 ) ) ||
				            ( 200 <= status && status < 400 ) ||
				            //status === 304 ||
				            ( status === 1223 && ( status = 204 ) ) ||
				            ( X_UA[ 'Webkit' ] && status === undefined ) // safari: /webkit/.test(userAgent)
						){
							/*
							 * opera8, safari2, khtml3 で utf8 日本語文字列の文字化け
							 */
							
							// parse json, html, xml, text, script, css
							switch( X_NET_XHRWrapper._dataType ){
								case '' :
								case 'text' :
									data = raw[ 'responseText' ];
									break;
								case 'json' :
								case 'moz-json' :
									data = raw[ 'response' ] || raw[ 'responseText' ];
									// eval() を使っているけど JSON の無いブラウザは XDomain な XHR はできないのでよしとする。
									// XDomain な XHR の際は Flash 等で代替し、その中に Json parser も組み込む。
									// http://d.hatena.ne.jp/sshi/20060904/p1
									if( !X_Type_isObject( data ) ) data = X_String_parseTrustedJsonString( data );
									break;
								case 'document' :
								case 'xml' :
								case 'html' :
								case 'htm' :
								// svg, vml, xaml, xul, mxml ??
									data = raw[ 'responseXML' ] || raw[ 'response' ] || raw[ 'responseText' ]; // とりあえず
									break;
								case 'blob' :
								case 'arraybuffer' :
									data = raw[ 'response' ] || raw[ 'responseText' ]; // とりあえず
									break;
							};

							X_NET_XHRWrapper[ 'asyncDispatch' ]( 32, { type : X_EVENT_SUCCESS, status : status || 200, response : data, 'headers' : headers || null } );
						} else {
							X_NET_XHRWrapper[ 'asyncDispatch' ]( 32, { type : X_EVENT_ERROR, status : status || 400, 'headers' : headers || null } );
						};
						break;
					
					case 'progress' :
						if( e.lengthComputable ){
							X_NET_XHRWrapper._percent = e.loaded / e.total;
							live && X_NET_XHRWrapper[ 'asyncDispatch' ]( { type : X_EVENT_PROGRESS, 'percent' : X_NET_XHRWrapper._percent } );
						};
						break;
					
					case 'error' :
					//console.dir( e );
						X_NET_XHRWrapper._busy  = false;
						X_NET_XHRWrapper._error = X_UA[ 'Opera' ] || X_UA[ 'Webkit' ] ;
						live && X_NET_XHRWrapper[ 'asyncDispatch' ]( 32, { type : X_EVENT_ERROR, status : raw.status } );
						break;

					case 'timeout' : // Gecko 12.0 https://developer.mozilla.org/ja/docs/XMLHttpRequest/Synchronous_and_Asynchronous_Requests
						X_NET_XHRWrapper._busy  = false;
						X_NET_XHRWrapper._error = !!X_UA[ 'Gecko' ];
						X_NET_XHRWrapper[ 'asyncDispatch' ]( { type :X_EVENT_ERROR, 'timeout' : true } );
						break;
				};
			},
			
			onTimeout : function(){
				var raw  = this[ '_rawObject' ],
					live = !X_NET_XHRWrapper._canceled || !this._busy;

				if( live || raw.readyState < 3 ){
					this._busy = false;
					live && this[ 'asyncDispatch' ]( { type : X_EVENT_ERROR, 'timeout' : true } );
				};
				this._timerID = 0;
			},
			
			onUploadProgress : X_Net_XHR_upload && function( e ){
				var raw  = X_NET_XHRWrapper[ '_rawObject' ].upload,
					live = !X_NET_XHRWrapper._canceled,
					states, data;
				live && X_NET_XHRWrapper[ 'asyncDispatch' ]( { type : X_EVENT_PROGRESS, 'percent' : X_NET_XHRWrapper._percent, 'uploadPercent' : ( e.loaded / e.total ) } );
			}
		};
	// 同期リクエストでなければならない場合, unload, beforeunload時

};
/*
 * https://gist.github.com/mmazer/5404301
 * 
 * XmlHttpRequest's getAllResponseHeaders() method returns a string of response
 * headers according to the format described here:
 * http://www.w3.org/TR/XMLHttpRequest/#the-getallresponseheaders-method
 * This method parses that string into a user-friendly key/value pair object.
 * 
 * http://hakuhin.jp/js/xmlhttprequest.html#XHR_GET_ALL_RESPONSE_HEADERS
 * 複数の情報が存在する場合、改行で区切られています。
 */

function X_NET_XHR_parseResponseHeaders( headerStr ){
	var headers = {}, headerPairs, i = 0, l, headerPair, index, key, val;
	
	if( !headerStr ) return headers;

	headerPairs = headerStr.split( '\u000d\u000a' );
	for( l = headerPairs.length; i < l ; ++i ){
		headerPair = headerPairs[i];
		index      = headerPair.indexOf( '\u003a\u0020' );
		if( index > 0 ){
			key = headerPair.substring( 0, index );
			val = headerPair.substring( index + 2 );
			headers[ key ] = val.split( '\r\n' ).join( '\n' ).split( '\n' );
		};
	};
	return headers;
};

