/*
 * $Id: flash.h 1554 2009-05-03 16:06:22Z rfhh $
 *
 * Copyright (C) 2003 ETC s.r.o.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the ETC s.r.o. nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Written by Marcel Telka <marcel@telka.sk>, 2003.
 *
 */

#ifndef URJ_SRC_FLASH_H
#define URJ_SRC_FLASH_H

#include <sysdep.h>

#include <stdio.h>
#include <stdint.h>

#include <urjtag/types.h>
#include <urjtag/log.h>

typedef struct URJ_FLASH_CFI_CHIP urj_flash_cfi_chip_t;

struct URJ_FLASH_CFI_ARRAY
{
    urj_bus_t *bus;
    uint32_t address;
    int bus_width;              /* in cfi_chips, e.g. 4 for 32 bits */
    urj_flash_cfi_chip_t **cfi_chips;
};

/** @return URJ_STATUS_OK on success; URJ_STATUS_FAIL on error */
int urj_flash_detectflash (urj_log_level_t ll, urj_bus_t *bus, uint32_t adr);

extern urj_flash_cfi_array_t *urj_flash_cfi_array;

#endif /* URJ_FLASH_H */
