<?php
require_once "cfg.php";
require_once "db.php";
require_once "dao/base.php";

class phpdao_factory
{
  private static $_is_init = false;
  private static $_defined_class = array();

  static function __initialize() //{{{
  {
    if( false == self::$_is_init && !$GLOBALS['PHPDAO_FACTORY_GENERATE'])
    {
      $schema_path = phpdao_cfg::get('root').'/dao/schema.php';
      require_once $schema_path;
      self::$_is_init = true;
    }
  }//}}}
  static function get_item($table_name,$where = array()) // {{{
  {
    if (false === ($rows = self::get_items($table_name,$where) ) )
      return false;

    return $rows[0];
  } // }}}
  static function get_items($table_name,$where = array()) // {{{
  {
    $where = self::array_to_where($table_name,$where);
    $db = phpdao_db::get();
    $objects = array();

    $sql = "select * from $table_name ".$where;
    if($db->query($sql))
    {
      $rows = $db->fetch_all_row();
      foreach( $rows as $r )
      {
        $object = self::create_table_class($table_name);
        $object->attach($r);
        $objects[] = $object;
      }
    }
    return $objects;
  } // }}}
  static function create_table_class($table_name) //{{{
  {
    $class_name = "phpdao_$table_name";
    if( !array_key_exists($class_name,self::$_defined_class) )
    {
      // CLASS_DEFINE {{{
      $class_define =<<<CLASS_DEFINE
class $class_name extends phpdao_dao_base {
  protected \$__table_name = '$table_name';
  function __toString()
  {
    return "$class_name Object";
  }
};
CLASS_DEFINE;
      // }}}
      eval($class_define);
      self::$_defined_class[$class_name] = true;
    }
    return new $class_name;
  } //}}}

  static function array_to_where($table_name,$array)//{{{
  {
    $where = array();
    foreach( $array as $key => $val )
    {
      if ($key == '@sql' )
        $where[] = "($val)";
      else
        if($val == null)
          $where[] = "$key is NULL";
        else
          $where[] = "$key = ".self::quote($table_name,$key,$val );
    }
    if (count($where))
      $qr = " where ".join(' and ',$where);
    else 
      $qr = '';
    return $qr;
  }//}}}
  static function quote($table_name,$col_name,$val) //{{{
  {
    $col = self::get_schema($table_name,$col_name);
    switch( $col['type'] )
    {
    case null:
      throw new exception("phpdao_factory error:no column name:[$table_name.$col_name]");
    case 'varchar':
    case 'char':
    case 'text':
      $val = "'".str_replace("'","''",$val)."'";
      break;
    case 'bigint':
    case 'int':
      break;
    default:
      throw new exception("phpdao_factory type not supported:[$table_name.$col_name.{$col['type']}]");
      break;
    }
    return $val;
  }//}}}

  // -- schema --
  public static function get_schema($table_name=null,$column_name=null)//{{{
  {
    if (null === $table_name)
      return phpdao_dao_schema::$schema;

    if (!array_key_exists($table_name,phpdao_dao_schema::$schema))
      throw new exception("db schema error:no table:[$table_name]");

    if( $column_name == null )
      return phpdao_dao_schema::$schema[$table_name];
        
    if( !array_key_exists($column_name,phpdao_dao_schema::$schema[$table_name]) )
      throw new exception("db schema error:no column:[$table_name,$column_name]");

    return phpdao_dao_schema::$schema[$table_name][$column_name];
  }//}}}
  public static function get_primary_key($table_name) //{{{
  {
    return self::get_schema($table_name,'@primary_key');
  } //}}}
  public static function get_relation($src_table_name,$target_table_name)//{{{
  {
    // TODO:phpdao_factory::$relationを定義し、検索せずに直接relationを参照できるようにする
    $table_schema = self::get_schema($src_table_name);
    unset($table_schema['@primary_key']); // foreach でErrorがでるため
    foreach( $table_schema as $column_name => $field )
    {
      if( isset($field['@relation']) )
      {
        foreach( $field['@relation'] as $t => $c )
        {
          if( $t == $target_table_name )
            return array(
                       'source'=> array('table'=>$src_table_name,
                                        'column'=>$column_name),
                       'target'=> array('table'=>$t,
                                        'column'=>$c),
                       );
        }
      }
    }
    throw new exception("NO relation:$src_table_name -> $target_table_name");
  }//}}}

  // -- db config generator --
  static function get_schema_from_db()//{{{
  {
    // ---- Only MySQL
    // -- table list --
    $query = "show tables";
    $db = phpdao_db::get();
    if ($db->query($query))
    {
      $rows = $db->fetch_all_row(null);
      foreach( $rows as $row )
      {
        $tables[$row[0]] = array();
      }
    }

    // -- table --
    $primary_key = null;
    foreach( $tables as $tablename => &$a )
    {
      $query = "desc $tablename";
      if ($db->query($query))
      {
        $columns = array();
        $rows = $db->fetch_all_row();
        foreach ( $rows as $row )
        {
          $col['field']   = $row['field'];
          $ty = preg_split('/[()]/',$row['type']);
          $col['type']      = $ty[0];
          $col['len']       = $ty[1];
          $col['null']      = ( $row['null'] == 'YES' ) ? true: false;
          $col['default']   = $row['default'];
          $col['extra']     = $row['extra'];
          if( $row['key'] == 'PRI' )
            $primary_key = $row['field'];
          $columns[$col['field']] = $col;
        }
        $a = $columns;
        $a['@primary_key'] = $primary_key;
      }
    }
    return $tables;
  }//}}}
  static function get_relation_from_file($tables) //{{{
  {
    $filename = phpdao_cfg::get('root').'/cfg/relation.ini'; 
    
    if( false === ($file = file($filename)) )
    {
      echo "not found relation file:$filename\n";
      die;
    }
    foreach( $file as $line )
    {
      list($content) = split('#',$line);
      $matches = array();
      if( preg_match('/([\w.]+)\s*=\s*([\w.]+)/',trim($content),$matches) )
      {
        list($all,$left,$right) = $matches;
        list($left_table,$left_column) = explode('.',$left);
        list($right_table,$right_column) = explode('.',$right);

        if( array_key_exists($left_table,$tables) && array_key_exists($left_column,$tables[$left_table]) &&
            array_key_exists($right_table,$tables) && array_key_exists($right_column,$tables[$right_table]))
        {
          $tables[$left_table][$left_column]['@relation'][$right_table] = $right_column;
          $tables[$right_table][$right_column]['@relation'][$left_table] = $left_column;
        }else
        {
          echo "not found column:$left_table.$left_column,$right_table.$right_column\n"; 
          die;
        }
      }
    }
    return $tables;
  }//}}}
  static function write_schema($schema)//{{{
  {
    $outstring=<<<EOF
<?php
# このクラスはphpdao_factory::generate()を使って作成されています。
# 変更が必要な場合は、DBのスキーマを変更後、php ./bin/generate.php を行ってください
class phpdao_dao_schema
{
  public static \$schema = array (

EOF;
    foreach( $schema as $tablename => $cols )
    {
      $outstring.=<<<EOF
      '$tablename'=>array( //{{{

EOF;
      if( array_key_exists('@primary_key',$cols) )
      {
        $outstring.=<<<EOF
        '@primary_key'=>'{$cols['@primary_key']}',

EOF;
      }

      foreach( $cols as $fieldname => $row )
      {
        if( $fieldname == '@primary_key' )
          continue;
        $relation = '';
        if(is_array($row) && array_key_exists('@relation',$row))
        {
          $relation = "'@relation' => array(";
          foreach ($row['@relation'] as $tbl => $clm )
          {
            $relation .= "
                '$tbl' => '$clm',";
          }
          $relation .= "
               ),";
        }
        $outstring.=<<<EOF
            '$fieldname' => array(
              'field'    => '{$row['field']}',
              'type'     => '{$row['type']}', 
              'len'      => '{$row['len']}', 
              'null'     => '{$row['null']}',
              'default'  => '{$row['default']}',
              'extra'    => '{$row['extra']}',
              $relation
             ),

EOF;

      }
      $outstring.=<<<EOF
          ), // }}}

EOF;
    }
    $outstring.=<<<EOF
  );

}
EOF;

    file_put_contents(phpdao_cfg::get('root')."/dao/schema.php",$outstring);
    return $outstring;
  }//}}}

  static function generate()//{{{
  {
    $schema = self::get_schema_from_db();
    $schema = self::get_relation_from_file($schema);
    self::write_schema($schema);
  }//}}}
  
}

phpdao_factory::__initialize();

