/***************************************************************
 * MPFSImg2.c
 * Defines an MPFS2 image to be stored in program memory.
 *
 * NOT FOR HAND MODIFICATION
 * This file is automatically generated by the MPFS2 Utility
 * ALL MODIFICATIONS WILL BE OVERWRITTEN BY THE MPFS2 GENERATOR
 * Generated  12 15 2011 11:58:19 
 ***************************************************************/

#define __MPFSIMG2_C

#include "TCPIPConfig.h"
#if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)

#include "TCPIP Stack/TCPIP.h"
#if defined(STACK_USE_MPFS2)


/**************************************
 * MPFS2 Image Data
 **************************************/
#define DATACHUNK000000 \
	0x4d,0x50,0x46,0x53,0x02,0x01,0x12,0x00,0x6a,0x55,0x5e,0x2a,0x26,0x4f,0x26,0x2d, /* MPFS....jU^.&O&- */ \
	0x0a,0xa3,0xff,0xff,0x6a,0x83,0xff,0xff,0xea,0x92,0xff,0xff,0x0a,0x4f,0xff,0xff, /* ....j........O.. */ \
	0x26,0xb6,0xff,0xff,0x8a,0xb6,0xff,0xff,0xca,0xb4,0xff,0xff,0xb8,0x01,0x00,0x00, /* &............... */ \
	0x5b,0x02,0x00,0x00,0xa1,0x03,0x00,0x00,0x18,0x68,0xe1,0x4e,0x00,0x00,0x00,0x00, /* [........h.N.... */ \
	0x01,0x00,0xc3,0x01,0x00,0x00,0xfc,0x05,0x00,0x00,0xc2,0x05,0x00,0x00,0x91,0x1b, /* ................ */ \
	0x15,0x4e,0x00,0x00,0x00,0x00,0x01,0x00,0xcd,0x01,0x00,0x00,0xbe,0x0b,0x00,0x00, /* .N.............. */ \
	0xa0,0x00,0x00,0x00,0xc3,0x42,0x9b,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xd8,0x01, /* .....B.N........ */ \
	0x00,0x00,0x5e,0x0c,0x00,0x00,0x1b,0x03,0x00,0x00,0x79,0x0a,0xea,0x4e,0x00,0x00, /* ..^.......y..N.. */ \
	0x00,0x00,0x00,0x00,0xe3,0x01,0x00,0x00,0x79,0x0f,0x00,0x00,0xc9,0x03,0x00,0x00, /* ........y....... */ \
	0x6e,0xec,0xe2,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0xed,0x01,0x00,0x00,0x42,0x13, /* n..N..........B. */ \
	0x00,0x00,0x60,0x00,0x00,0x00,0x6e,0xec,0xe2,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* ..`...n..N...... */ \
	0xee,0x01,0x00,0x00,0xa2,0x13,0x00,0x00,0xe9,0x01,0x00,0x00,0xed,0x6e,0xe1,0x4e, /* .............n.N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0xf9,0x01,0x00,0x00,0x8b,0x15,0x00,0x00,0x30,0x00, /* ..............0. */ \
	0x00,0x00,0xed,0x6e,0xe1,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0xfa,0x01,0x00,0x00, /* ...n.N.......... */ \
	0xbb,0x15,0x00,0x00,0x8c,0x0a,0x00,0x00,0xa4,0x69,0xe1,0x4e,0x00,0x00,0x00,0x00, /* .........i.N.... */ \
	0x02,0x00,0x0d,0x02,0x00,0x00,0x47,0x20,0x00,0x00,0x88,0x00,0x00,0x00,0xa4,0x69, /* ......G .......i */ \
	0xe1,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x02,0x00,0x00,0xcf,0x20,0x00,0x00, /* .N........... .. */ \
	0xc6,0x03,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x20,0x02, /* .......N...... . */ \
	0x00,0x00,0x95,0x24,0x00,0x00,0x18,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00, /* ...$.........N.. */ \
	0x00,0x00,0x00,0x00,0x21,0x02,0x00,0x00,0xad,0x24,0x00,0x00,0x08,0x00,0x00,0x00, /* ....!....$...... */ \
	0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x02,0x00,0x34,0x02,0x00,0x00,0xb5,0x24, /* ...N......4....$ */ \
	0x00,0x00,0x08,0x00,0x00,0x00,0x91,0x1b,0x15,0x4e,0x00,0x00,0x00,0x00,0x00,0x00, /* .........N...... */ \
	0x35,0x02,0x00,0x00,0xbd,0x24,0x00,0x00,0x06,0x02,0x00,0x00,0xcb,0x00,0xb7,0x4e, /* 5....$.........N */ \
	0x00,0x00,0x00,0x00,0x02,0x00,0x48,0x02,0x00,0x00,0xc3,0x26,0x00,0x00,0x20,0x00, /* ......H....&.. . */ \
	0x00,0x00,0xcb,0x00,0xb7,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x49,0x02,0x00,0x00, /* .....N......I... */ \
	0xe3,0x26,0x00,0x00,0x6c,0x03,0x00,0x00,0xc3,0xf2,0xad,0x4e,0x00,0x00,0x00,0x00, /* .&..l......N.... */ \
	0x02,0x00,0x5a,0x02,0x00,0x00,0x4f,0x2a,0x00,0x00,0x30,0x00,0x00,0x00,0xc3,0xf2, /* ..Z...O...0..... */ \
	0xad,0x4e,0x00,0x00,0x00,0x00,0x00,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63, /* .N......7m3tjz.c */ \
	0x73,0x73,0x00,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x00,0x66,0x6f,0x6f, /* ss.7m3tjz.js.foo */ \
	0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x00,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ter.inc.header.i */ \
	0x6e,0x63,0x00,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00,0x00,0x73,0x74, /* nc.index.htm..st */ \
	0x61,0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63, /* atus.htm..protec */ \
	0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72, /* t/config.htm..pr */ \
	0x6f,0x74,0x65,0x63,0x74,0x2f,0x69,0x6e,0x64,0x65,0x78,0x2e,0x68,0x74,0x6d,0x00, /* otect/index.htm. */ \
	0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e, /* .protect/reboot. */ \
	0x63,0x67,0x69,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62, /* cgi..protect/reb */ \
	0x6f,0x6f,0x74,0x2e,0x68,0x74,0x6d,0x00,0x00,0x70,0x72,0x6f,0x74,0x65,0x63,0x74, /* oot.htm..protect */ \
	0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74,0x6d,0x00,0x00,0x1f,0x8b,0x08,0x00,0x00, /* /user.htm....... */ \
	0x00,0x00,0x00,0x00,0x00,0xad,0x56,0xc1,0x6e,0xa3,0x30,0x10,0x3d,0x37,0x52,0xfe, /* ......V.n.0.=7R. */ \
	0x01,0xa9,0xd7,0x82,0x20,0x84,0xb4,0xa5,0xa7,0x6a,0xa5,0x1e,0xf7,0xb8,0x77,0x83, /* .... ....j....w. */ \
	0xc7,0xc1,0xaa,0x83,0x91,0x31,0x4d,0xba,0xd5,0xfe,0xfb,0xda,0xc6,0x80,0x01,0x27, /* .....1M........' */ \
	0xd5,0x4a,0x2b,0xa4,0x36,0x18,0xcf,0x7b,0xe3,0x99,0x37,0x33,0x2e,0x38,0xfe,0x0c, /* .J+.6..{..73.8.. */ \
	0xbe,0xb6,0x9b,0x3b,0xc2,0x6b,0x19,0x12,0x74,0xa2,0xec,0x33,0x0f,0x7e,0x81,0xc0, /* ...;.k..t..3.~.. */ \
	0xa8,0x46,0x0f,0xc1,0xab,0xa0,0x88,0x3d,0x04,0x2d,0xaa,0xdb,0xb0,0x05,0x41,0xc9, /* .F.....=.-....A. */ \
	0x8b,0xda,0x5a,0xa0,0xf2,0xfd,0x28,0x78,0x57,0xe3,0x3c,0xb8,0xcf,0x0a,0xfd,0xe8, /* ..Z...(xW.<..... */ \
	0xe5,0x13,0x12,0x47,0x5a,0xe7,0x41,0xdc,0x5c,0x02,0xd4,0x49,0xae,0xd7,0x1a,0x84, /* ...GZ.A.\..I.... */ \
	0x31,0xad,0x8f,0x6a,0x51,0x3d,0x3b,0xfd,0x25,0x56,0xcb,0x7f,0xb6,0x9b,0xed,0xe6, /* 1..jQ=;.%V...... */ \
	0xbe,0xad,0x10,0xe6,0xe7,0x90,0xd7,0x60,0x1c,0x38,0x53,0x2c,0xab,0x3c,0x78,0x3c, /* .......`.8S,.<x< */ \
	0xa8,0x5d,0x86,0x85,0x0b,0x0c,0x22,0x0f,0x12,0x65,0xd4,0x72,0x46,0xb1,0xe2,0xca, /* .]...."..e.rF... */ \
	0xb2,0xe9,0x4b,0x28,0x79,0x93,0x1b,0x38,0x1f,0xf3,0x9f,0x89,0x40,0x9e,0xb9,0x21, /* ..K(y..8....@..! */ \
	0xf0,0x00,0xee,0x0b,0xfd,0xf8,0x30,0x5d,0xfb,0x4a,0x00,0x5c,0x45,0xd8,0xef,0xbf, /* ......0].J.\E... */ \
	0x31,0x27,0xbc,0x13,0xd7,0xac,0x53,0xa4,0x9f,0x2b,0x00,0x0a,0xa2,0x41,0xc7,0xab, /* 1'....S..+...A.. */ \
	0xcc,0x69,0x9a,0xae,0x92,0x41,0x08,0xf1,0x06,0x68,0x4c,0xc3,0xce,0x06,0xd7,0x64, /* .i...A...hL....d */ \
	0xbb,0xa5,0xbf,0x41,0x41,0xc6,0x8d,0x9c,0x13,0x4a,0x3c,0x29,0xc2,0xb3,0x47,0x52, /* ...AA....J<)..GR */ \
	0xc9,0xac,0x57,0x2e,0xf7,0xdb,0xdb,0x6b,0x16,0xcf,0xd9,0xf6,0x0e,0xd9,0x19,0xe8, /* ..W....k........ */ \
	0xb1,0x92,0x79,0x50,0x70,0x86,0xf5,0x62,0xc9,0x19,0x17,0x93,0xcb,0x7d,0x0a,0xc3, /* ..yPp..b.....}.. */ \
	0x82,0x4b,0xc9,0x4f,0x8a,0x30,0xeb,0x4d,0x2b,0x6b,0x95,0x1c,0xcc,0xbb,0xeb,0x40, /* .K.O.0.M+k.....@ */ \
	0x24,0xf4,0xa7,0xde,0x53,0xc6,0x91,0xda,0x64,0x16,0x5e,0x26,0x29,0xa5,0xb1,0x3d, /* $...S...d.^&)..= */ \
	0xad,0x84,0x8b,0x0c,0x11,0xa3,0xc7,0x7a,0xda,0xd4,0x43,0x9d,0xa0,0xee,0x5c,0x08, /* .......z..C...\. */ \
	0x06,0xc4,0x45,0x48,0x32,0x8b,0x60,0x8f,0x14,0x8a,0xde,0x1d,0x1b,0x46,0x07,0x03, /* ..EH2.`......F.. */ \
	0xb9,0x1a,0x4e,0xf6,0xd6,0x0c,0xd3,0xb6,0x61,0x48,0x15,0x54,0xc1,0x78,0xf9,0xbe, /* ..N.....aH.T.x.. */ \
	0x4a,0xd7,0x14,0x32,0x1b,0x8d,0x73,0x45,0x25,0xcc,0x42,0xf8,0x74,0x23,0x84,0x36, /* J..2..sE%.B.t#.6 */ \
	0xcd,0x63,0xcc,0x26,0x6d,0xd8,0xa0,0x9a,0x73,0x63,0x28,0xb9,0x40,0x92,0x72,0x75, /* .c.&m...sc(.@.ru */ \
	0xf8,0x5a,0x15,0xdb,0xc2,0xef,0xbc,0xe2,0x1f,0x20,0xd6,0xe9,0xc4,0x46,0x5e,0xfd  /* .Z....... ...F^. */
#define DATACHUNK000001 \
	0xce,0x52,0xb1,0x43,0x2d,0xdd,0x23,0x66,0x3b,0x9b,0xa1,0x65,0xec,0x17,0x91,0x4a, /* .R.C-.#f;..e...J */ \
	0xdc,0x48,0x0d,0x38,0x7d,0xb0,0x06,0x05,0x94,0x7d,0x08,0x6e,0x3b,0x3b,0x9a,0x3a, /* .H.8}....}.n;;.: */ \
	0xfe,0x0e,0x00,0xbd,0xab,0x6b,0x00,0x75,0x10,0x10,0x8c,0x7a,0x50,0xaa,0xc4,0x00, /* .....k.u...zP... */ \
	0x58,0xd1,0xf5,0x75,0x32,0xf9,0x19,0xb5,0x0d,0x2a,0x07,0x0e,0x06,0x48,0xe8,0x90, /* X..u2........H.. */ \
	0xcb,0x6a,0x44,0x21,0x9c,0x4b,0xfb,0xd9,0xa9,0x91,0x38,0x7a,0x82,0x93,0xab,0xec, /* .jD!.K....8z.... */ \
	0xc3,0xe1,0xb0,0x14,0x5f,0xa9,0xc8,0x41,0xb8,0x2d,0x4b,0xc7,0x27,0xc8,0x4c,0x63, /* ...._..A.-K.'.Lc */ \
	0x0c,0x96,0x62,0x33,0x7e,0x25,0xb3,0x76,0x68,0xd7,0xd4,0x76,0xac,0xb2,0x0e,0x78, /* ..b3~%.vh..v...x */ \
	0x60,0xb1,0x1d,0x55,0x22,0xd9,0xb5,0x33,0x25,0x3e,0xde,0x4e,0xd3,0x84,0xef,0x3a, /* `..U"..3%>.N...: */ \
	0xb4,0x6c,0xbf,0x73,0x2e,0xaf,0x18,0x67,0x0e,0x34,0xc6,0x85,0x91,0x22,0xeb,0x4f, /* .l.s...g.4...".O */ \
	0xa7,0xfe,0x26,0x6e,0x41,0x52,0x95,0x9e,0x5a,0x21,0x84,0x4b,0x17,0xc6,0xfe,0x17, /* ..&nAR..Z!.K.... */ \
	0xc1,0x05,0x9d,0x1a,0x06,0x05,0xbf,0x38,0xf9,0xca,0x4d,0xcc,0x74,0x89,0x05,0xe3, /* .......8..M.t... */ \
	0x2f,0x5f,0xcd,0xf8,0x4e,0x90,0x3a,0x52,0xe9,0x73,0x32,0xa5,0xc4,0x91,0xff,0x3d, /* /_..N.:R.s2....= */ \
	0xc6,0xe3,0xa1,0xa2,0x92,0x63,0x58,0x8f,0xc8,0x1f,0xaa,0xad,0x53,0xa5,0x82,0x9f, /* .....cX.....S... */ \
	0x70,0x7e,0x18,0x5e,0x1e,0x02,0x42,0x2f,0x80,0x43,0x13,0x7c,0xfb,0xe2,0x9c,0x05, /* p~.^..B/.C.|.... */ \
	0x44,0x49,0x5b,0x4f,0xe7,0x24,0xf0,0xfc,0xb2,0x88,0x97,0xd3,0x12,0x75,0x4b,0x5a, /* DI[O.$.......uKZ */ \
	0xc9,0xa0,0x5f,0xdc,0x4d,0x15,0x0f,0x45,0x3a,0x31,0x09,0xc1,0x85,0x2b,0xf0,0x39, /* .._.M..E:1...+.9 */ \
	0xc4,0x2a,0xf5,0x73,0x67,0x30,0xbe,0xc5,0xf3,0x1c,0x4f,0xd3,0x69,0xac,0xa6,0x83, /* ...sg0....O.i... */ \
	0x33,0xa3,0x1c,0x85,0xa2,0xb6,0x72,0x62,0x3e,0x0a,0x2c,0x5b,0xb8,0x11,0x2f,0x5a, /* 3.....rb>.,[../Z */ \
	0xbd,0x53,0x88,0x4e,0xfe,0xed,0x50,0x72,0x32,0x37,0xf4,0xea,0x65,0xc7,0xc9,0x26, /* .S.N..Pr27..e..& */ \
	0x00,0x42,0x81,0xe1,0x16,0xe4,0xff,0x55,0xcf,0x15,0xa1,0x8c,0x64,0x98,0x7e,0xcc, /* .B.....U....d.~. */ \
	0x0b,0x40,0xc7,0x4f,0x73,0xe9,0xff,0xc3,0x48,0x59,0x9b,0x30,0x54,0x00,0x5b,0xa7, /* .@.Os...HY.0T.[. */ \
	0x2d,0x4c,0xf6,0xbe,0xbe,0xb0,0xeb,0xd7,0x86,0x3a,0x3f,0xc4,0x37,0x06,0x45,0xc3, /* -L.......:?.7.E. */ \
	0x5b,0xda,0xb7,0x44,0x54,0xa8,0x3c,0x76,0x12,0x56,0x0e,0xd0,0xba,0xe9,0xe4,0x9a, /* [..DT.<v.V...... */ \
	0x7c,0x68,0x49,0x03,0xcd,0xce,0xe7,0xbc,0xb1,0x8d,0xda,0x93,0xdb,0x78,0xa6,0x6b, /* |hI..........x.k */ \
	0xd8,0x6a,0x23,0xc2,0x89,0x67,0xe7,0xac,0x4f,0xda,0xd4,0xce,0xad,0x8b,0x4e,0xcd, /* .j#..g..O.....N. */ \
	0xb9,0x5a,0x9b,0x17,0xdf,0xd9,0xcf,0x86,0xfc,0x08,0xa0,0x77,0x20,0x01,0xb3,0x51, /* .Z.........w ..Q */ \
	0xbd,0xf3,0xa6,0x63,0x70,0x34,0xf5,0x11,0x39,0xb7,0xcd,0x9b,0xbc,0x91,0x80,0xb6, /* ...cp4..9....... */ \
	0x63,0x72,0xbb,0xf9,0xda,0x2e,0xfa,0xfd,0xbf,0xa9,0x6f,0x7e,0xdf,0xf3,0x8f,0x13, /* cr........o~.... */ \
	0xff,0xfd,0xc0,0xad,0x6b,0x80,0x31,0xe9,0x77,0x11,0x7f,0x37,0x07,0x1b,0x4a,0x76, /* ....k.1.w..7..Jv */ \
	0x9c,0x58,0x85,0xe9,0xef,0x0b,0x43,0x62,0x6e,0x24,0xca,0xf2,0x4e,0x9b,0x12,0x44, /* .X....Cbn$..N..D */ \
	0x99,0xd7,0xb8,0x38,0x78,0x8c,0x09,0xcc,0x8c,0xbb,0xda,0x4f,0x5c,0x96,0x3e,0x5b, /* ...8x......O\.>[ */ \
	0x82,0xad,0xed,0x5f,0x84,0x2d,0x7d,0x46,0xa5,0x0c,0x00,0x00,0x1f,0x8b,0x08,0x00, /* ..._.-}F........ */ \
	0x00,0x00,0x00,0x00,0x00,0x00,0xd5,0x57,0x5d,0x6f,0xdb,0x36,0x14,0x7d,0x56,0x80, /* .......W]o.6.}V. */ \
	0xfc,0x87,0x3b,0x3f,0x2c,0x32,0xe0,0x38,0x4e,0xb1,0xee,0xa1,0x81,0x3b,0xa4,0x49, /* ..;?,2.8N....;.I */ \
	0xb1,0x66,0x48,0x97,0x20,0x71,0x87,0x02,0xdb,0x1e,0x68,0x89,0x8e,0xd9,0xc8,0xa2, /* .fH. q....h..... */ \
	0x4a,0x52,0x76,0x8d,0x22,0x3f,0x68,0xff,0x72,0xe7,0x92,0x94,0x2c,0xbb,0x69,0x51, /* JRv."?h.r...,.iQ */ \
	0xac,0x7d,0x59,0x02,0x58,0x1f,0xbc,0xf7,0xf0,0xf2,0xdc,0x4f,0x1d,0x1d,0xd1,0x99, /* .}Y.X......O.... */ \
	0xae,0xd6,0x46,0xdd,0xcd,0x1d,0xfd,0x43,0x4f,0x46,0xa3,0x27,0x87,0x4f,0x46,0xc7, /* ..F....COF.'.OF. */ \
	0x23,0x7a,0xad,0x32,0xa3,0xb3,0xb9,0xaa,0x68,0x22,0xb3,0x79,0xa9,0x0b,0x7d,0xb7, /* #z.2....h".y..}. */ \
	0xa6,0x8b,0x32,0x1b,0x12,0x9d,0x16,0x05,0x79,0x05,0x4b,0x46,0x5a,0x69,0x96,0x32, /* ..2.....y.KFZi.2 */ \
	0x1f,0xee,0xef,0x1d,0x1d,0xd1,0xad,0x94,0x5d,0xbd,0xb3,0xeb,0xa3,0x8b,0x6b,0xba, /* ........].....k. */ \
	0x75,0x22,0xbb,0xa7,0x5c,0x67,0xf5,0x42,0x96,0x4e,0x38,0xa5,0x4b,0x9a,0x69,0x43, /* u"..\g.B.N8.K.iC */ \
	0x85,0xca,0x64,0x69,0x25,0xa9,0x12,0x4f,0x0b,0xff,0x1e,0x28,0xfc,0x0f,0xa4,0x73, /* ..di%..O...(...s */ \
	0xe9,0xa4,0x59,0xa8,0x52,0x5a,0x5a,0xcd,0x65,0x49,0x02,0x3b,0xbd,0xaf,0xa5,0x75, /* ..Y.RZZ.eI.;...u */ \
	0xa4,0x2c,0x65,0xba,0xb4,0x2a,0x97,0x46,0xe6,0xd4,0x73,0x6a,0x81,0x8b,0xae,0x5d, /* .,e....F..sj...] */ \
	0x6f,0x7f,0x6f,0x29,0x0c,0xf1,0xf3,0x55,0xed,0x5e,0xdf,0xd2,0x98,0x9e,0x8e,0x46, /* o.o)...U.^.....F */ \
	0xa3,0x13,0x3a,0x3a,0x5a,0xd8,0xfd,0x3d,0x0a,0x06,0x3a,0x0d,0x8b,0x81,0x06,0xac, /* ..::Z..=..:..... */ \
	0x5a,0x92,0x9e,0xd1,0xe9,0x6f,0xa7,0x6f,0x49,0x2e,0x61,0x99,0x25,0xa7,0xa9,0x82, /* Z....o.oI.a.%... */ \
	0xed,0xd2,0xda,0x80,0x25,0xde,0x89,0x0f,0x97,0x0a,0x7b,0x8e,0xa9,0x94,0x2b,0x3a, /* ....%.....{...+: */ \
	0x35,0x46,0xac,0xd3,0xfe,0x49,0x34,0xf1,0xa2,0x54,0x4e,0x09,0xe7,0xe1,0xfc,0x32, /* 5F...I4..TN....2 */ \
	0x23,0x65,0x7a,0xb1,0x10,0x65,0xce,0x02,0x49,0x6d,0x8a,0x67,0xe4,0xe6,0x92,0x70, /* #ez..e..Im.g...p */ \
	0xc3,0xd8,0x22,0x0b,0xd0,0x58,0xc2,0x09,0x9c,0xc0,0xe9,0x4c,0x10,0x68,0xc8,0xa1, /* .."..X.....L.h.. */ \
	0x8b,0x73,0x16,0x9c,0xa9,0xa2,0x18,0x10,0x28,0x12,0x34,0xab,0xcb,0xcc,0x33,0x86, /* .s......(.4...3. */ \
	0xd7,0x99,0x00,0xef,0x2b,0xe5,0xe6,0xcc,0x7a,0xa5,0x99,0xbb,0xb7,0xaf,0x2f,0x29, /* ....+...z...../) */ \
	0xd5,0x15,0x4b,0x88,0xa2,0xef,0xa1,0x8d,0xac,0xa4,0x70,0xc0,0x35,0x38,0x20,0xb4, /* ..K.......p.58 . */ \
	0xc2,0x33,0xb6,0x61,0xe2,0x18,0x41,0x95,0xb9,0x9c,0x29,0x18,0x2f,0x8b,0xf5,0xae, /* .3.a..A...)./... */ \
	0x72,0x2e,0x9c,0x78,0x46,0xa2,0xa4,0x37,0x37,0x97,0x24,0xcb,0x4c,0xe7,0x20,0xd7, /* r..xF..77.$.L. . */ \
	0x3a,0xa3,0xca,0x3b,0xc6,0x9a,0x4a,0xb2,0xf5,0x74,0xa1,0x9c,0xc3,0x6b,0x61,0xe9, /* :..;..J..t...ka. */ \
	0xfa,0xea,0x76,0x42,0xac,0xb3,0x85,0xd3,0xda,0x0c,0x56,0x98,0x94,0xb3,0xc0,0x49, /* ..vB......V....I */ \
	0x0a,0x1a,0x06,0xd4,0x9e,0x7c,0x10,0x2d,0x1b,0x78,0x00,0xa8,0x7d,0xdc,0xdf,0x4b, /* .....|.-.x..}..K */ \
	0x7c,0x0c,0x39,0xaa,0x2b,0x78,0xd4,0x90,0x9e,0xbe,0x93,0x99,0xc3,0x6b,0x76,0x06, /* |.9.+x.......kv. */ \
	0x83,0xc1,0x1f,0xd1,0x17,0x57,0x7e,0xc9,0x3b,0xc3,0xaf,0x82,0xc5,0x09,0x3c,0x6f, /* .....W~.;.....<o */ \
	0xe2,0xf2,0x39,0xfc,0x12,0x16,0xa3,0xda,0x90,0x7d,0x30,0x66,0x4f,0x74,0x5f,0xb6, /* ..9......}0fOt_. */ \
	0xc6,0x60,0xa9,0xbd,0xef,0x0a,0x44,0xf2,0xc6,0xd1,0xd6,0xee,0x12,0x07,0xc7,0x8d  /* .`....D......... */
#define DATACHUNK000002 \
	0x7c,0xcf,0x1b,0xd6,0x85,0x47,0x0d,0xf6,0x9f,0x19,0x08,0x4a,0x70,0x08,0xe2,0x24, /* |....G.....Jp..$ */ \
	0x7e,0xd8,0xbf,0x31,0x76,0x21,0xa0,0x66,0xe9,0x0a,0x0e,0xd0,0xab,0x21,0x5c,0xf7, /* ~..1v!.f.....!\. */ \
	0xca,0xb9,0xea,0x26,0x2c,0xf5,0x09,0xc7,0xa7,0xf8,0xf7,0xc8,0x16,0x38,0xd3,0xb6, /* ...&,........8.. */ \
	0x82,0x3f,0xdd,0x67,0x14,0x86,0xba,0x92,0x65,0x9a,0x32,0xaf,0xe3,0x31,0x5b,0xd7, /* .?.g....e.2..1[. */ \
	0xff,0xa5,0xf7,0xeb,0xcb,0x49,0xef,0x59,0x8f,0x1d,0xd6,0x1b,0x50,0x87,0x94,0x81, /* .....I.Y....P... */ \
	0x0f,0x94,0x2f,0x81,0xf1,0x29,0x3c,0x56,0x23,0xc4,0xb1,0x3f,0xa3,0x95,0x3c,0x30, /* ../..)<V#..?..<0 */ \
	0x08,0x6d,0xcb,0xa1,0x71,0xf1,0xf2,0x67,0x44,0xc9,0xba,0x90,0x94,0x2e,0xc4,0x1a, /* .m..q..gD....... */ \
	0x51,0xf2,0x74,0xf8,0x94,0x53,0xa1,0x42,0x56,0x4f,0x0b,0x0e,0x43,0xdd,0x0f,0xba, /* Q.t..S.BVO..C... */ \
	0x0f,0x24,0x0b,0xce,0xf9,0x96,0x86,0x53,0x84,0xca,0x52,0xbe,0x0d,0xfe,0xfc,0x0a, /* .$.....S..R..... */ \
	0x16,0xb6,0xe4,0xd3,0x9e,0xaf,0x36,0x56,0xcf,0x9c,0xe7,0x73,0x32,0xb9,0xee,0x75, /* ......6V...s2..u */ \
	0x8f,0x82,0x6d,0x76,0x50,0xb6,0x76,0xf8,0xee,0xd4,0x7d,0x15,0x7d,0x9e,0x86,0xc8, /* ..mvP.v...}.}... */ \
	0x46,0xb8,0x84,0xdf,0x46,0xb1,0x10,0xd6,0x9d,0x21,0x51,0x91,0x62,0xe3,0x36,0xae, /* F...F....!Q.b.6. */ \
	0x87,0x77,0xd2,0xf1,0x4d,0xeb,0xf6,0xd6,0x15,0xbe,0xa4,0x21,0xa9,0x7d,0xc6,0x08, /* .w..M......!.}.. */ \
	0x2e,0x51,0x61,0xa9,0x29,0x5e,0xc3,0xaa,0xb6,0xf3,0x86,0x06,0xd6,0x7e,0x88,0xf5, /* .Qa.)^.......~.. */ \
	0xeb,0x52,0xeb,0xca,0x92,0x5e,0x22,0xfa,0xb9,0x2c,0xe0,0xdc,0x39,0xfb,0x72,0xa7, /* .R...^"..,..9.r. */ \
	0x20,0xe6,0x4d,0x21,0x06,0x99,0x08,0xea,0x35,0xaa,0x98,0xcf,0x6d,0x65,0x7d,0x54, /*  .M!....5...me}T */ \
	0x2b,0x14,0xe1,0x4e,0xc6,0x57,0xba,0x28,0x18,0x20,0x05,0xcf,0x49,0x4c,0xcd,0xac, /* +..N.W.(. ..IL.. */ \
	0x36,0xff,0x25,0x71,0x79,0x51,0x16,0xa2,0xb2,0x32,0xdf,0x24,0xd7,0x8d,0x14,0x28, /* 6.%qyQ...2.$...( */ \
	0xf6,0xb3,0x99,0xcf,0xaa,0xb6,0x3c,0x87,0x3a,0x81,0xb3,0xc0,0xca,0xe9,0x9a,0x2f, /* ......<.:....../ */ \
	0x90,0x46,0x53,0x49,0x15,0x50,0x5b,0x1e,0x0a,0x59,0xde,0xb9,0xf9,0x09,0x29,0x7a, /* .FSI.P[..Y....)z */ \
	0x4e,0x68,0x0b,0xea,0xf0,0x10,0x31,0x99,0x70,0xd5,0x49,0x36,0x26,0xb6,0xd2,0x76, /* Nh....1.p.I6&..v */ \
	0xae,0x66,0xd1,0x4c,0x4e,0xda,0x1f,0xa2,0x08,0xab,0x24,0xbe,0x7c,0xab,0xb2,0x96, /* .f.LN.....$.|... */ \
	0x7e,0x35,0x1a,0xf9,0xa8,0xb3,0xe8,0xb0,0x39,0x7e,0xc7,0xad,0x5e,0x2b,0xe1,0x13, /* ~5......9~..^+.. */ \
	0x25,0x4d,0x2a,0xa1,0xac,0x66,0x52,0xe6,0xcc,0xa5,0xdf,0xae,0x51,0x6a,0x82,0x08, /* %M...fR.....Qj.. */ \
	0x35,0x25,0x5f,0xa3,0x91,0xa2,0xb0,0x8c,0xc7,0xf4,0x13,0xfd,0xf8,0x23,0xed,0x8a, /* 5%_..........#.. */ \
	0x58,0xac,0xd6,0x96,0x97,0xd1,0xc3,0x7d,0x98,0x27,0x0d,0xbe,0x72,0x34,0x17,0xdc, /* X......}.'..r4.. */ \
	0xa6,0x3a,0xc5,0x77,0x65,0xd0,0x00,0x62,0x71,0xb2,0x75,0xe1,0xbc,0x38,0x76,0x76, /* .:.we..bq.u..8vv */ \
	0xeb,0x4a,0xea,0x8d,0x01,0xad,0x46,0x9f,0x91,0x0f,0x1a,0x47,0x1f,0xf4,0x03,0x7e, /* .J....F....G...~ */ \
	0xf2,0x89,0xdc,0x23,0xa6,0x87,0x5e,0x85,0xfc,0x1c,0x36,0x7d,0xee,0x65,0x21,0xf9, /* ...#..^...6}.e!. */ \
	0x12,0xd8,0x4d,0x36,0x35,0xe1,0xcb,0x9b,0x87,0x3e,0x74,0xd0,0x9c,0x2d,0x69,0xd0, /* ..M65....>t..-i. */ \
	0x98,0xee,0x88,0xf8,0x62,0x7d,0x91,0x3f,0xa2,0x3e,0x54,0x25,0x2e,0xaf,0x26,0xe8, /* ....b}.?.>T%..&. */ \
	0x96,0xe3,0x4f,0x88,0x6b,0x0c,0x9c,0xc8,0x0f,0xae,0x31,0x08,0xbc,0xa5,0x1a,0xe4, /* ..O.k.....1..... */ \
	0x98,0x95,0xb2,0xdc,0x9e,0xa9,0xc4,0x13,0x67,0x07,0x0f,0x2e,0x5c,0x16,0x68,0x29, /* ........g...\.h) */ \
	0x0a,0x94,0xe1,0x10,0x0e,0xf8,0xe1,0x8c,0x4b,0x76,0x91,0xc5,0x54,0x9b,0x18,0x43, /* ........Kv..T..C */ \
	0x8f,0xad,0x6f,0x5a,0xc7,0x96,0xaf,0x0e,0xac,0x9f,0x76,0xb8,0xdf,0x08,0x2e,0x9e, /* ..oZ......v..... */ \
	0xb1,0x79,0x0c,0xd8,0x59,0x25,0xdb,0x62,0x75,0xe3,0xac,0x06,0x30,0x48,0x07,0x63, /* .y..Y%.bu...0H.c */ \
	0x92,0x9d,0xae,0xdb,0xc8,0x84,0xee,0xbb,0x4b,0xcd,0xe6,0x55,0xc4,0x38,0xf9,0x34, /* ........K..U.8.4 */ \
	0xc0,0x1f,0xf8,0xa7,0x1b,0xad,0x07,0x4b,0x49,0x2b,0xa1,0x78,0x08,0xf0,0xe5,0xe3, /* .......KI+.x.... */ \
	0x18,0x9d,0x0e,0x1a,0x79,0x34,0x11,0xe1,0xdc,0x4e,0x65,0x31,0x9e,0x9b,0x1c,0x79, /* ....y4...Ne1...y */ \
	0xbe,0x99,0xcf,0xba,0x21,0x5a,0x2e,0xf5,0x7d,0x08,0xc6,0x1a,0xe3,0xe4,0x66,0xe8, /* ....!Z..}.....f. */ \
	0xf1,0xc3,0x8e,0xa7,0x5b,0x95,0x55,0xfd,0xfd,0x62,0xd4,0x17,0xf6,0xad,0xe0,0x8b, /* ....[.U..b...... */ \
	0xa2,0x30,0xe6,0xb4,0x90,0xc6,0xb5,0xb6,0x84,0xd7,0x82,0xdf,0xa5,0xbd,0x48,0x29, /* .0............H) */ \
	0xcd,0x84,0x42,0x1a,0x0f,0xff,0x2a,0xcf,0x34,0xe2,0xaa,0x9d,0xcf,0x72,0x54,0xcd, /* ..B.....4....rT. */ \
	0x42,0x57,0x7e,0x90,0x9b,0x6a,0x61,0x72,0x90,0x64,0xa9,0xd0,0xa8,0x26,0xbd,0x66, /* BW~..jar.d...&.f */ \
	0x37,0xef,0xeb,0x6f,0x0b,0x96,0x58,0x3a,0xfe,0x1f,0xf1,0x72,0xd5,0x24,0xd1,0x80, /* 7..o..X:...r.$.. */ \
	0xde,0xd5,0x28,0xd5,0xf7,0x52,0x56,0x3e,0x76,0x90,0x4c,0x2c,0xb2,0xdd,0xa5,0x9a, /* ..(..RV>v.L,.... */ \
	0x22,0xcb,0x30,0x0f,0x9b,0x89,0x8a,0xdb,0x13,0xba,0x9b,0x95,0xc5,0x92,0xa7,0xed, /* ".0............. */ \
	0x3b,0x58,0xc2,0x0d,0xef,0x78,0xc4,0x83,0x7d,0x62,0x43,0xb1,0x45,0xb0,0xa5,0xbd, /* ;X...x..}bC.E... */ \
	0x4d,0xff,0xe9,0x0d,0x8e,0x47,0xfd,0xd0,0x38,0x1e,0x22,0x67,0x80,0xba,0x16,0x40, /* M....G..8."g...@ */ \
	0xb1,0xde,0xbb,0x1f,0x16,0xc5,0x4d,0x33,0x46,0x1b,0xe9,0x6a,0x53,0x22,0x3e,0xd1, /* ......M3F..jS">. */ \
	0x3d,0x30,0xfc,0xc6,0x51,0x22,0x4e,0x5a,0xed,0x18,0x8a,0xf9,0x18,0x4a,0xe7,0x7e, /* =0..Q"NZ.....J.~ */ \
	0x44,0x8e,0x08,0xfc,0xd0,0x6a,0xfb,0x1d,0x30,0xbc,0xcb,0x22,0x0f,0x02,0xfe,0x96, /* D....j..0..".... */ \
	0x23,0xc3,0x4a,0x61,0xb2,0x39,0x17,0x8f,0x4e,0xaf,0x44,0xd5,0xc2,0x46,0x7f,0x70, /* #.Ja.9..N.D..F.p */ \
	0x1d,0x49,0x23,0xd4,0x20,0xa8,0x84,0xd4,0x70,0x66,0x1d,0xc2,0x12,0x8e,0x8b,0xeb, /* .I#. ...pf...... */ \
	0x9d,0x4a,0x67,0x5f,0xac,0x27,0xe2,0xee,0x77,0x81,0x2e,0x13,0x74,0xfe,0x1c,0xfd, /* .Jg_.'..w...t... */ \
	0x3d,0x9c,0x29,0x83,0x26,0x33,0x57,0x45,0x3e,0x2c,0x31,0xba,0x7b,0xec,0xe0,0xe5, /* =.).&3WE>,1.{... */ \
	0x60,0x23,0x7d,0x03,0x4e,0xec,0x75,0x56,0x76,0xf1,0x9a,0x90,0x7c,0xc0,0xa7,0x85, /* `#}.N.uVv...|... */ \
	0xcb,0xe6,0xa9,0x34,0x48,0xc2,0x8f,0xd4,0x5d,0xe5,0x21,0x27,0x8e,0x1c,0xf7,0x0a, /* ...4H...].!'.... */ \
	0x1f,0x82,0x4d,0xf7,0xf6,0x73,0xc6,0x9b,0x0a,0x93,0x11,0x67,0xd9,0xe7,0x9c,0x88, /* ..M..s.....g.... */ \
	0x4f,0xb8,0xf0,0xc1,0xf5,0x2f,0xde,0xe8,0x9b,0x2d,0xa8,0x0e,0x00,0x00,0x3c,0x64, /* O..../...-....<d */ \
	0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x70,0x61,0x63,0x65,0x72, /* iv class="spacer */ \
	0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a, /* ">&nbsp;</div>.. */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x66,0x6f,0x6f,0x74,0x65,0x72,0x22, /* <div id="footer" */ \
	0x3e,0x43,0x6f,0x70,0x79,0x72,0x69,0x67,0x68,0x74,0x20,0x26,0x63,0x6f,0x70,0x79  /* >Copyright &copy */
#define DATACHUNK000003 \
	0x3b,0x20,0x32,0x30,0x31,0x31,0x20,0x53,0x61,0x74,0x6f,0x73,0x68,0x69,0x20,0x59, /* ; 2011 Satoshi Y */ \
	0x61,0x73,0x75,0x64,0x61,0x20,0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2f,0x61,0x64,0x36, /* asuda 7m3tjz/ad6 */ \
	0x67,0x7a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69, /* gz</div>....</di */ \
	0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x2f, /* v></div></div></ */ \
	0x64,0x69,0x76,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f, /* div></div>....</ */ \
	0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x74,0x6d,0x6c,0x3e,0x3c,0x21, /* body>..</html><! */ \
	0x44,0x4f,0x43,0x54,0x59,0x50,0x45,0x20,0x68,0x74,0x6d,0x6c,0x20,0x50,0x55,0x42, /* DOCTYPE html PUB */ \
	0x4c,0x49,0x43,0x20,0x22,0x2d,0x2f,0x2f,0x57,0x33,0x43,0x2f,0x2f,0x44,0x54,0x44, /* LIC "-//W3C//DTD */ \
	0x20,0x58,0x48,0x54,0x4d,0x4c,0x20,0x31,0x2e,0x30,0x20,0x53,0x74,0x72,0x69,0x63, /*  XHTML 1.0 Stric */ \
	0x74,0x2f,0x2f,0x45,0x4e,0x22,0x0d,0x0a,0x20,0x20,0x22,0x68,0x74,0x74,0x70,0x3a, /* t//EN"..  "http: */ \
	0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x54,0x52,0x2f, /* //www.w3.org/TR/ */ \
	0x78,0x68,0x74,0x6d,0x6c,0x31,0x2f,0x44,0x54,0x44,0x2f,0x78,0x68,0x74,0x6d,0x6c, /* xhtml1/DTD/xhtml */ \
	0x31,0x2d,0x73,0x74,0x72,0x69,0x63,0x74,0x2e,0x64,0x74,0x64,0x22,0x3e,0x0d,0x0a, /* 1-strict.dtd">.. */ \
	0x3c,0x68,0x74,0x6d,0x6c,0x20,0x78,0x6d,0x6c,0x6e,0x73,0x3d,0x22,0x68,0x74,0x74, /* <html xmlns="htt */ \
	0x70,0x3a,0x2f,0x2f,0x77,0x77,0x77,0x2e,0x77,0x33,0x2e,0x6f,0x72,0x67,0x2f,0x31, /* p://www.w3.org/1 */ \
	0x39,0x39,0x39,0x2f,0x78,0x68,0x74,0x6d,0x6c,0x22,0x20,0x78,0x6d,0x6c,0x3a,0x6c, /* 999/xhtml" xml:l */ \
	0x61,0x6e,0x67,0x3d,0x22,0x65,0x6e,0x22,0x20,0x6c,0x61,0x6e,0x67,0x3d,0x22,0x65, /* ang="en" lang="e */ \
	0x6e,0x22,0x3e,0x0d,0x0a,0x3c,0x68,0x65,0x61,0x64,0x3e,0x0d,0x0a,0x3c,0x74,0x69, /* n">..<head>..<ti */ \
	0x74,0x6c,0x65,0x3e,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x53,0x65,0x72,0x76,0x65, /* tle>dSqure Serve */ \
	0x72,0x20,0x50,0x72,0x6f,0x67,0x72,0x61,0x6d,0x3c,0x2f,0x74,0x69,0x74,0x6c,0x65, /* r Program</title */ \
	0x3e,0x0d,0x0a,0x3c,0x6c,0x69,0x6e,0x6b,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f, /* >..<link href="/ */ \
	0x37,0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x63,0x73,0x73,0x22,0x20,0x72,0x65,0x6c,0x3d, /* 7m3tjz.css" rel= */ \
	0x22,0x73,0x74,0x79,0x6c,0x65,0x73,0x68,0x65,0x65,0x74,0x22,0x20,0x74,0x79,0x70, /* "stylesheet" typ */ \
	0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x63,0x73,0x73,0x22,0x20,0x2f,0x3e,0x0d, /* e="text/css" />. */ \
	0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x73,0x72,0x63,0x3d,0x22,0x2f,0x37, /* .<script src="/7 */ \
	0x6d,0x33,0x74,0x6a,0x7a,0x2e,0x6a,0x73,0x22,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* m3tjz.js" type=" */ \
	0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22, /* text/javascript" */ \
	0x3e,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x68,0x65, /* ></script>..</he */ \
	0x61,0x64,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x62,0x6f,0x64,0x79,0x3e,0x0d,0x0a,0x3c, /* ad>....<body>..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x6f, /* div id="shadow-o */ \
	0x6e,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61, /* ne"><div id="sha */ \
	0x64,0x6f,0x77,0x2d,0x74,0x77,0x6f,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20,0x69,0x64, /* dow-two"><div id */ \
	0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d,0x74,0x68,0x72,0x65,0x65,0x22,0x3e, /* ="shadow-three"> */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x73,0x68,0x61,0x64,0x6f,0x77,0x2d, /* <div id="shadow- */ \
	0x66,0x6f,0x75,0x72,0x22,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d, /* four">..<div id= */ \
	0x22,0x70,0x61,0x67,0x65,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* "page">....<div  */ \
	0x69,0x64,0x3d,0x22,0x74,0x69,0x74,0x6c,0x65,0x22,0x3e,0x3c,0x64,0x69,0x76,0x20, /* id="title"><div  */ \
	0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x72,0x69,0x67,0x68,0x74,0x22,0x3e,0x64,0x53, /* class="right">dS */ \
	0x71,0x75,0x72,0x65,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x56,0x30,0x30,0x2e, /* qure Server V00. */ \
	0x30,0x31,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x3c,0x73,0x70,0x61,0x6e,0x20,0x69,0x64, /* 01</div><span id */ \
	0x3d,0x22,0x68,0x65,0x6c,0x6c,0x6f,0x22,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* ="hello">&nbsp;< */ \
	0x2f,0x73,0x70,0x61,0x6e,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a, /* /span></div>.... */ \
	0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x6d,0x65,0x6e,0x75,0x22,0x3e,0x0d, /* <div id="menu">. */ \
	0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x69,0x6e,0x64,0x65,0x78, /* .<a href="/index */ \
	0x2e,0x68,0x74,0x6d,0x22,0x3e,0x4f,0x76,0x65,0x72,0x76,0x69,0x65,0x77,0x3c,0x2f, /* .htm">Overview</ */ \
	0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72, /* a>..<a href="/pr */ \
	0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x68,0x74,0x6d, /* otect/config.htm */ \
	0x22,0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43,0x6f,0x6e,0x66,0x69,0x67, /* ">Network Config */ \
	0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20, /* uration</a>..<a  */ \
	0x68,0x72,0x65,0x66,0x3d,0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75, /* href="/protect/u */ \
	0x73,0x65,0x72,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44, /* ser.htm">User ID */ \
	0x20,0x26,0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x73,0x65,0x74,0x74, /*  & Password sett */ \
	0x69,0x6e,0x67,0x3c,0x2f,0x61,0x3e,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66, /* ing</a>..<a href */ \
	0x3d,0x22,0x2f,0x73,0x74,0x61,0x74,0x75,0x73,0x2e,0x68,0x74,0x6d,0x22,0x3e,0x43, /* ="/status.htm">C */ \
	0x75,0x72,0x72,0x65,0x6e,0x74,0x20,0x53,0x74,0x61,0x74,0x75,0x73,0x3c,0x2f,0x61, /* urrent Status</a */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65, /* >..</div>~inc:he */ \
	0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20, /* ader.inc~..<div  */ \
	0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d, /* id="content">... */ \
	0x0a,0x3c,0x68,0x31,0x3e,0x44,0x2d,0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75, /* .<h1>D-STAR dSqu */ \
	0x72,0x65,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a, /* re Server</h1>.. */ \
	0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22, /* ..<table style=" */ \
	0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30, /* padding-left: 10 */ \
	0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c, /* px;">..<tr><td>< */ \
	0x62,0x3e,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20  /* b>dSqure Server  */
#define DATACHUNK000004 \
	0x49,0x50,0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x20,0x3a,0x3c,0x2f,0x62,0x3e, /* IP Address :</b> */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c, /* </td><td>&nbsp;< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x73,0x65,0x72,0x76,0x65,0x72,0x5f, /* /td><td>~server_ */ \
	0x69,0x70,0x5f,0x61,0x64,0x64,0x72,0x65,0x73,0x73,0x7e,0x3c,0x2f,0x74,0x64,0x3e, /* ip_address~</td> */ \
	0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c, /* </tr>..<tr><td>< */ \
	0x62,0x3e,0x43,0x6f,0x6e,0x66,0x65,0x72,0x65,0x6e,0x63,0x65,0x20,0x52,0x6f,0x6f, /* b>Conference Roo */ \
	0x6d,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64, /* m Name :</b></td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e, /* ><td>&nbsp;</td> */ \
	0x3c,0x74,0x64,0x3e,0x7e,0x52,0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65,0x7e,0x3c,0x2f, /* <td>~RoomName~</ */ \
	0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74, /* td></tr>..<tr><t */ \
	0x64,0x3e,0x3c,0x62,0x3e,0x52,0x65,0x63,0x65,0x69,0x76,0x65,0x20,0x50,0x6f,0x72, /* d><b>Receive Por */ \
	0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e, /* t :</b></td><td> */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e, /* &nbsp;</td><td>~ */ \
	0x69,0x6e,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74, /* in_port~</td></t */ \
	0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x53, /* r>..<tr><td><b>S */ \
	0x65,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f, /* end Port :</b></ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74, /* td><td>&nbsp;</t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x6f,0x75,0x74,0x5f,0x70,0x6f,0x72,0x74,0x7e, /* d><td>~out_port~ */ \
	0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x28,0x44,0x65,0x66,0x61,0x75,0x6c,0x74,0x29, /*  &nbsp;(Default) */ \
	0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e, /* </td></tr>..<tr> */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4c,0x6f,0x67,0x20,0x53,0x65,0x72,0x76,0x65, /* <td><b>Log Serve */ \
	0x72,0x20,0x44,0x6f,0x6d,0x61,0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c, /* r Domain Name :< */ \
	0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73, /* /b></td><td>&nbs */ \
	0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4c,0x6f,0x67,0x4e, /* p;</td><td>~LogN */ \
	0x61,0x6d,0x65,0x7e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a, /* ame~</td></tr>.. */ \
	0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c,0x62,0x3e,0x4c,0x6f,0x67,0x20,0x50, /* <tr><td><b>Log P */ \
	0x6f,0x72,0x74,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74, /* ort :</b></td><t */ \
	0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* d>&nbsp;</td><td */ \
	0x3e,0x7e,0x6c,0x6f,0x67,0x5f,0x70,0x6f,0x72,0x74,0x7e,0x3c,0x2f,0x74,0x64,0x3e, /* >~log_port~</td> */ \
	0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c, /* </tr>..<tr><td>< */ \
	0x62,0x3e,0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x44,0x6f,0x6d, /* b>NTP Server Dom */ \
	0x61,0x69,0x6e,0x20,0x4e,0x61,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f, /* ain Name :</b></ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74, /* td><td>&nbsp;</t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x4e,0x74,0x70,0x4e,0x61,0x6d,0x65,0x7e,0x3c, /* d><td>~NtpName~< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c, /* /td></tr>..<tr>< */ \
	0x74,0x64,0x3e,0x3c,0x62,0x3e,0x54,0x69,0x6d,0x65,0x20,0x5a,0x6f,0x6e,0x65,0x20, /* td><b>Time Zone  */ \
	0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e, /* :</b></td><td>&n */ \
	0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x54,0x69, /* bsp;</td><td>~Ti */ \
	0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x7e,0x20,0x26,0x6e,0x62,0x73,0x70,0x3b,0x68,0x6f, /* meZone~ &nbsp;ho */ \
	0x75,0x72,0x73,0x26,0x6e,0x62,0x73,0x70,0x3b,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f, /* urs&nbsp;~TimeZo */ \
	0x6e,0x65,0x4d,0x69,0x6e,0x75,0x74,0x65,0x73,0x7e,0x26,0x6e,0x62,0x73,0x70,0x3b, /* neMinutes~&nbsp; */ \
	0x6d,0x69,0x6e,0x75,0x74,0x65,0x73,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72, /* minutes</td></tr */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62,0x6c,0x65,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* >..</table>....< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74, /* /div>....<script */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61, /*  type="text/java */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a, /* script">..<!--.. */ \
	0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d, /* document.getElem */ \
	0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29, /* entById('hello') */ \
	0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68, /* .innerHTML = "~h */ \
	0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d, /* ellomsg~";..//-- */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a, /* >..</script>.... */ \
	0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e, /* ~inc:footer.inc~ */ \
	0x0d,0x0a,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xaf,0x00,0x00,0x00,0x89,0x00, /* ......3......... */ \
	0x00,0x00,0x0b,0x01,0x00,0x00,0x4d,0x00,0x00,0x00,0x56,0x01,0x00,0x00,0x4c,0x00, /* ......M...V...L. */ \
	0x00,0x00,0x9d,0x01,0x00,0x00,0x4b,0x00,0x00,0x00,0x02,0x02,0x00,0x00,0x8b,0x00, /* ......K......... */ \
	0x00,0x00,0x48,0x02,0x00,0x00,0x8a,0x00,0x00,0x00,0x9d,0x02,0x00,0x00,0x60,0x00, /* ..H...........`. */ \
	0x00,0x00,0xe4,0x02,0x00,0x00,0x61,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x6d,0x00, /* ......a.......m. */ \
	0x00,0x00,0x95,0x03,0x00,0x00,0x01,0x00,0x00,0x00,0xb7,0x03,0x00,0x00,0x02,0x00, /* ................ */ \
	0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e, /* ..~inc:header.in */ \
	0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e, /* c~..<div id="con */ \
	0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x44,0x2d, /* tent">....<h1>D- */ \
	0x53,0x54,0x41,0x52,0x20,0x64,0x53,0x71,0x75,0x72,0x65,0x20,0x53,0x65,0x72,0x76, /* STAR dSqure Serv */ \
	0x65,0x72,0x20,0x53,0x74,0x61,0x74,0x75,0x73,0x3c,0x2f,0x68,0x31,0x3e,0x0d,0x0a, /* er Status</h1>.. */ \
	0x0d,0x0a,0x3c,0x74,0x61,0x62,0x6c,0x65,0x20,0x73,0x74,0x79,0x6c,0x65,0x3d,0x22  /* ..<table style=" */
#define DATACHUNK000005 \
	0x70,0x61,0x64,0x64,0x69,0x6e,0x67,0x2d,0x6c,0x65,0x66,0x74,0x3a,0x20,0x31,0x30, /* padding-left: 10 */ \
	0x70,0x78,0x3b,0x22,0x3e,0x0d,0x0a,0x3c,0x74,0x72,0x3e,0x3c,0x74,0x64,0x3e,0x3c, /* px;">..<tr><td>< */ \
	0x62,0x3e,0x44,0x61,0x74,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x74,0x64, /* b>Date :</b></td */ \
	0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e, /* ><td>&nbsp;</td> */ \
	0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x44,0x61,0x74,0x65,0x7e,0x3c,0x2f,0x74, /* <td>~CurDate~</t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* d><td>&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74,0x64,0x3e,0x3c,0x74,0x64, /* p;&nbsp;</td><td */ \
	0x3e,0x3c,0x62,0x3e,0x54,0x69,0x6d,0x65,0x20,0x3a,0x3c,0x2f,0x62,0x3e,0x3c,0x2f, /* ><b>Time :</b></ */ \
	0x74,0x64,0x3e,0x3c,0x74,0x64,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x3c,0x2f,0x74, /* td><td>&nbsp;</t */ \
	0x64,0x3e,0x3c,0x74,0x64,0x3e,0x7e,0x43,0x75,0x72,0x54,0x69,0x6d,0x65,0x7e,0x3c, /* d><td>~CurTime~< */ \
	0x2f,0x74,0x64,0x3e,0x3c,0x2f,0x74,0x72,0x3e,0x0d,0x0a,0x3c,0x2f,0x74,0x61,0x62, /* /td></tr>..</tab */ \
	0x6c,0x65,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x7e,0x4e,0x64, /* le>..</div>..~Nd */ \
	0x54,0x61,0x62,0x6c,0x65,0x7e,0x0d,0x0a,0x3c,0x2f,0x62,0x6f,0x64,0x79,0x3e,0x0d, /* Table~..</body>. */ \
	0x0a,0x3c,0x6d,0x65,0x74,0x61,0x20,0x68,0x74,0x74,0x70,0x2d,0x65,0x71,0x75,0x69, /* .<meta http-equi */ \
	0x76,0x3d,0x22,0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x22,0x20,0x63,0x6f,0x6e,0x74, /* v="refresh" cont */ \
	0x65,0x6e,0x74,0x3d,0x22,0x33,0x30,0x30,0x22,0x3e,0x0d,0x0a,0x3c,0x62,0x6f,0x64, /* ent="300">..<bod */ \
	0x79,0x3e,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65, /* y>..<script type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70, /* ="text/javascrip */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d, /* t">..<!--..docum */ \
	0x65,0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79, /* ent.getElementBy */ \
	0x49,0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65, /* Id('hello').inne */ \
	0x72,0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d, /* rHTML = "~hellom */ \
	0x73,0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f, /* sg~";..//-->..</ */ \
	0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f, /* script>..~inc:fo */ \
	0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x00,0x00,0x00,0x00,0x33, /* oter.inc~......3 */ \
	0x00,0x00,0x00,0xa2,0x00,0x00,0x00,0x63,0x00,0x00,0x00,0xf4,0x00,0x00,0x00,0x64, /* .......c.......d */ \
	0x00,0x00,0x00,0x1b,0x01,0x00,0x00,0x8d,0x00,0x00,0x00,0xb7,0x01,0x00,0x00,0x01, /* ................ */ \
	0x00,0x00,0x00,0xd7,0x01,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a, /* ...........~inc: */ \
	0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69, /* header.inc~..<di */ \
	0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d, /* v id="content">. */ \
	0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4e,0x65,0x74,0x77,0x6f,0x72,0x6b,0x20,0x43, /* ...<h1>Network C */ \
	0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x61,0x74,0x69,0x6f,0x6e,0x3c,0x2f,0x68,0x31, /* onfiguration</h1 */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f, /* >....<form metho */ \
	0x64,0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d, /* d="post" action= */ \
	0x22,0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x63,0x6f,0x6e,0x66,0x69,0x67, /* "/protect/config */ \
	0x2e,0x68,0x74,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x63,0x6f,0x6e,0x66, /* .htm" name="conf */ \
	0x69,0x67,0x22,0x3e,0x0d,0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e, /* ig">..<fieldset> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x4d,0x41, /* ..<div><label>MA */ \
	0x43,0x20,0x41,0x64,0x64,0x72,0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* C Address:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6d,0x61,0x63, /* "text" name="mac */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67, /* " value="~config */ \
	0x5f,0x6d,0x61,0x63,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* _mac~" /></div>. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x6f,0x6f, /* .<div><label>Roo */ \
	0x6d,0x20,0x4e,0x61,0x6d,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d, /* m Name:</label>. */ \
	0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* .<input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x52,0x6d,0x4e,0x6d,0x22,0x20, /* xt" name="RmNm"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x52,0x6f,0x6f,0x6d,0x4e,0x61,0x6d,0x65, /* value="~RoomName */ \
	0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22,0x20,0x73, /* ~" class="ad1" s */ \
	0x69,0x7a,0x65,0x3d,0x22,0x38,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ize="8" /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x52,0x65, /* ..<div><label>Re */ \
	0x63,0x65,0x69,0x76,0x65,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* ceive Port:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65, /* el>..<input type */ \
	0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6f,0x70, /* ="text" name="op */ \
	0x72,0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x69,0x6e,0x5f,0x70, /* rt" value="~in_p */ \
	0x6f,0x72,0x74,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* ort~" class="ad1 */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* " size="5"/></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x53,0x65,0x6e,0x64,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* Send Port:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x72, /* "text" name="ipr */ \
	0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6f,0x75,0x74,0x5f,0x70, /* t" value="~out_p */ \
	0x6f,0x72,0x74,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* ort~" class="ad1 */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69  /* " size="5"/></di */
#define DATACHUNK000006 \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x4c,0x6f,0x67,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a, /* Log Server Name: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74, /* </label>..<input */ \
	0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d, /*  type="text" nam */ \
	0x65,0x3d,0x22,0x6c,0x6f,0x67,0x68,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22, /* e="logh" value=" */ \
	0x7e,0x4c,0x6f,0x67,0x4e,0x61,0x6d,0x65,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* ~LogName~" /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x4c,0x6f,0x67,0x20,0x50,0x6f,0x72,0x74,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* >Log Port:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6c,0x70,0x72, /* "text" name="lpr */ \
	0x74,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x6c,0x6f,0x67,0x5f,0x70, /* t" value="~log_p */ \
	0x6f,0x72,0x74,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31, /* ort~" class="ad1 */ \
	0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x35,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69, /* " size="5"/></di */ \
	0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e, /* v>..<div><label> */ \
	0x4e,0x54,0x50,0x20,0x53,0x65,0x72,0x76,0x65,0x72,0x20,0x4e,0x61,0x6d,0x65,0x3a, /* NTP Server Name: */ \
	0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e, /* </label>&nbsp;&n */ \
	0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b, /* bsp;&nbsp;&nbsp; */ \
	0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73, /* &nbsp;&nbsp;&nbs */ \
	0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a, /* p;&nbsp;&nbsp;.. */ \
	0x3c,0x73,0x65,0x6c,0x65,0x63,0x74,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x6e,0x74, /* <select name="nt */ \
	0x70,0x22,0x3e,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c, /* p">..<option val */ \
	0x75,0x65,0x3d,0x22,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67, /* ue="pool.ntp.org */ \
	0x22,0x3e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a, /* ">pool.ntp.org.. */ \
	0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x65, /* <option value="e */ \
	0x75,0x72,0x6f,0x70,0x65,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f, /* urope.pool.ntp.o */ \
	0x72,0x67,0x22,0x3e,0x65,0x75,0x72,0x6f,0x70,0x65,0x2e,0x70,0x6f,0x6f,0x6c,0x2e, /* rg">europe.pool. */ \
	0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* ntp.org..<option */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x61,0x73,0x69,0x61,0x2e,0x70,0x6f,0x6f, /*  value="asia.poo */ \
	0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x61,0x73,0x69,0x61,0x2e, /* l.ntp.org">asia. */ \
	0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f, /* pool.ntp.org..<o */ \
	0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x6f,0x63,0x65, /* ption value="oce */ \
	0x61,0x6e,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72, /* ania.pool.ntp.or */ \
	0x67,0x22,0x3e,0x6f,0x63,0x65,0x61,0x6e,0x69,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e, /* g">oceania.pool. */ \
	0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e, /* ntp.org..<option */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x6e,0x6f,0x72,0x74,0x68,0x2d,0x61,0x6d, /*  value="north-am */ \
	0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f, /* erica.pool.ntp.o */ \
	0x72,0x67,0x22,0x3e,0x6e,0x6f,0x72,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63, /* rg">north-americ */ \
	0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a, /* a.pool.ntp.org.. */ \
	0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x73, /* <option value="s */ \
	0x6f,0x75,0x74,0x68,0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f, /* outh-america.poo */ \
	0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x73,0x6f,0x75,0x74,0x68, /* l.ntp.org">south */ \
	0x2d,0x61,0x6d,0x65,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74, /* -america.pool.nt */ \
	0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a,0x3c,0x6f,0x70,0x74,0x69,0x6f,0x6e,0x20,0x76, /* p.org..<option v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x61,0x66,0x72,0x69,0x63,0x61,0x2e,0x70,0x6f,0x6f, /* alue="africa.poo */ \
	0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x22,0x3e,0x61,0x66,0x72,0x69,0x63, /* l.ntp.org">afric */ \
	0x61,0x2e,0x70,0x6f,0x6f,0x6c,0x2e,0x6e,0x74,0x70,0x2e,0x6f,0x72,0x67,0x0d,0x0a, /* a.pool.ntp.org.. */ \
	0x3c,0x2f,0x73,0x65,0x6c,0x65,0x63,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76, /* </select>..</div */ \
	0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x54, /* >..<div><label>T */ \
	0x69,0x6d,0x65,0x20,0x5a,0x6f,0x6e,0x65,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c, /* ime Zone:</label */ \
	0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22, /* >..<input type=" */ \
	0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x7a,0x6f,0x6e,0x65, /* text" name="zone */ \
	0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f, /* " value="~TimeZo */ \
	0x6e,0x65,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64,0x31,0x22, /* ne~" class="ad1" */ \
	0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x33,0x22,0x2f,0x3e,0x26,0x6e,0x62,0x73,0x70, /*  size="3"/>&nbsp */ \
	0x3b,0x68,0x6f,0x75,0x72,0x73,0x26,0x6e,0x62,0x73,0x70,0x3b,0x0d,0x0a,0x3c,0x69, /* ;hours&nbsp;..<i */ \
	0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22, /* nput type="text" */ \
	0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x7a,0x6e,0x65,0x4d,0x22,0x20,0x76,0x61,0x6c, /*  name="zneM" val */ \
	0x75,0x65,0x3d,0x22,0x7e,0x54,0x69,0x6d,0x65,0x5a,0x6f,0x6e,0x65,0x4d,0x69,0x6e, /* ue="~TimeZoneMin */ \
	0x75,0x74,0x65,0x73,0x7e,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x61,0x64, /* utes~" class="ad */ \
	0x33,0x22,0x20,0x73,0x69,0x7a,0x65,0x3d,0x22,0x32,0x22,0x2f,0x3e,0x26,0x6e,0x62, /* 3" size="2"/>&nb */ \
	0x73,0x70,0x3b,0x6d,0x69,0x6e,0x75,0x74,0x65,0x73,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* sp;minutes</div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x26,0x6e,0x62,0x73,0x70,0x3b,0x26,0x6e,0x62, /* ..<div>&nbsp;&nb */ \
	0x73,0x70,0x3b,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e, /* sp;</div>..<div> */ \
	0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x63  /* ..<input type="c */
#define DATACHUNK000007 \
	0x68,0x65,0x63,0x6b,0x62,0x6f,0x78,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22, /* heckbox" class=" */ \
	0x73,0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x64,0x68,0x63,0x70,0x22,0x20, /* sm" name="dhcp"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x31,0x22,0x20,0x6f,0x6e,0x63,0x6c,0x69,0x63, /* value="1" onclic */ \
	0x6b,0x3d,0x22,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73, /* k="configIPBoxes */ \
	0x28,0x29,0x22,0x20,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x68,0x63,0x70, /* ()" ~config_dhcp */ \
	0x63,0x68,0x65,0x63,0x6b,0x65,0x64,0x7e,0x20,0x2f,0x3e,0x20,0x45,0x6e,0x61,0x62, /* checked~ /> Enab */ \
	0x6c,0x65,0x20,0x44,0x48,0x43,0x50,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* le DHCP</div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x49,0x50,0x20,0x41,0x64, /* div><label>IP Ad */ \
	0x64,0x72,0x65,0x73,0x73,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a, /* dress:</label>.. */ \
	0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* <td><input type= */ \
	0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x69,0x70,0x22, /* "text" name="ip" */ \
	0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f, /*  value="~config_ */ \
	0x69,0x70,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c, /* ip~" /></div>..< */ \
	0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x47,0x61,0x74,0x65,0x77, /* div><label>Gatew */ \
	0x61,0x79,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64, /* ay:</label>..<td */ \
	0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65, /* ><input type="te */ \
	0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x67,0x77,0x22,0x20,0x76,0x61, /* xt" name="gw" va */ \
	0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x67,0x77,0x7e, /* lue="~config_gw~ */ \
	0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76, /* " /></div>..<div */ \
	0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x53,0x75,0x62,0x6e,0x65,0x74,0x20,0x4d, /* ><label>Subnet M */ \
	0x61,0x73,0x6b,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x74, /* ask:</label>..<t */ \
	0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74, /* d><input type="t */ \
	0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x73,0x75,0x62,0x22,0x20, /* ext" name="sub"  */ \
	0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x73, /* value="~config_s */ \
	0x75,0x62,0x6e,0x65,0x74,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e, /* ubnet~" /></div> */ \
	0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x50,0x72, /* ..<div><label>Pr */ \
	0x69,0x6d,0x61,0x72,0x79,0x20,0x44,0x4e,0x53,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* imary DNS:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x74,0x64,0x3e,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74, /* l>..<td><input t */ \
	0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* ype="text" name= */ \
	0x22,0x64,0x6e,0x73,0x31,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x63, /* "dns1" value="~c */ \
	0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x31,0x7e,0x22,0x20,0x2f,0x3e,0x3c, /* onfig_dns1~" />< */ \
	0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62, /* /div>..<div><lab */ \
	0x65,0x6c,0x3e,0x53,0x65,0x63,0x6f,0x6e,0x64,0x61,0x72,0x79,0x20,0x44,0x4e,0x53, /* el>Secondary DNS */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x64,0x6e,0x73,0x32,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="dns2" value= */ \
	0x22,0x7e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x5f,0x64,0x6e,0x73,0x32,0x7e,0x22,0x20, /* "~config_dns2~"  */ \
	0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c, /* /></div>..<div>< */ \
	0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x73,0x75,0x62,0x6d, /* input type="subm */ \
	0x69,0x74,0x22,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x73,0x6d,0x22,0x20,0x76, /* it" class="sm" v */ \
	0x61,0x6c,0x75,0x65,0x3d,0x22,0x53,0x61,0x76,0x65,0x20,0x43,0x6f,0x6e,0x66,0x69, /* alue="Save Confi */ \
	0x67,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66, /* g" /></div>..</f */ \
	0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d, /* ieldset>..</form */ \
	0x3e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63, /* >..</div>....<sc */ \
	0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75,0x61,0x67,0x65,0x3d,0x22,0x6a, /* ript language="j */ \
	0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d, /* avascript">..<!- */ \
	0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x63,0x6f,0x6e,0x66, /* -..function conf */ \
	0x69,0x67,0x49,0x50,0x42,0x6f,0x78,0x65,0x73,0x28,0x29,0x20,0x7b,0x0d,0x0a,0x09, /* igIPBoxes() {... */ \
	0x65,0x20,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x66,0x6f,0x72, /* e = document.for */ \
	0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x3b,0x0d,0x0a,0x09,0x73,0x74,0x20, /* ms.config;...st  */ \
	0x3d,0x20,0x65,0x2e,0x64,0x68,0x63,0x70,0x2e,0x63,0x68,0x65,0x63,0x6b,0x65,0x64, /* = e.dhcp.checked */ \
	0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x69,0x70,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65, /* ;...e.ip.disable */ \
	0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x67,0x77,0x2e,0x64, /* d = st;...e.gw.d */ \
	0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09, /* isabled = st;... */ \
	0x65,0x2e,0x73,0x75,0x62,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* e.sub.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65,0x2e,0x64,0x6e,0x73,0x31,0x2e,0x64,0x69, /*  st;...e.dns1.di */ \
	0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x73,0x74,0x3b,0x0d,0x0a,0x09,0x65, /* sabled = st;...e */ \
	0x2e,0x64,0x6e,0x73,0x32,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d, /* .dns2.disabled = */ \
	0x20,0x73,0x74,0x3b,0x0d,0x0a,0x7d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /*  st;..}..documen */ \
	0x74,0x2e,0x66,0x6f,0x72,0x6d,0x73,0x2e,0x63,0x6f,0x6e,0x66,0x69,0x67,0x2e,0x6d, /* t.forms.config.m */ \
	0x61,0x63,0x2e,0x64,0x69,0x73,0x61,0x62,0x6c,0x65,0x64,0x20,0x3d,0x20,0x74,0x72, /* ac.disabled = tr */ \
	0x75,0x65,0x3b,0x0d,0x0a,0x0d,0x0a,0x63,0x6f,0x6e,0x66,0x69,0x67,0x49,0x50,0x42, /* ue;....configIPB */ \
	0x6f,0x78,0x65,0x73,0x28,0x29,0x3b,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e, /* oxes();..documen */ \
	0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64  /* t.getElementById */
#define DATACHUNK000008 \
	0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48, /* ('hello').innerH */ \
	0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67, /* TML = "~hellomsg */ \
	0x7e,0x22,0x3b,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63, /* ~";..//-->..</sc */ \
	0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74, /* ript>..~inc:foot */ \
	0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xde, /* er.inc~....3.... */ \
	0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x3c,0x01,0x00,0x00,0x4d,0x00,0x00,0x00,0xb0, /* ...%...<...M.... */ \
	0x01,0x00,0x00,0x4c,0x00,0x00,0x00,0x1f,0x02,0x00,0x00,0x4b,0x00,0x00,0x00,0x95, /* ...L.......K.... */ \
	0x02,0x00,0x00,0x8b,0x00,0x00,0x00,0xef,0x02,0x00,0x00,0x8a,0x00,0x00,0x00,0x7e, /* ...............~ */ \
	0x05,0x00,0x00,0x61,0x00,0x00,0x00,0xd9,0x05,0x00,0x00,0x6d,0x00,0x00,0x00,0x89, /* ...a.......m.... */ \
	0x06,0x00,0x00,0x27,0x00,0x00,0x00,0xfd,0x06,0x00,0x00,0x28,0x00,0x00,0x00,0x5a, /* ...'.......(...Z */ \
	0x07,0x00,0x00,0x29,0x00,0x00,0x00,0xbc,0x07,0x00,0x00,0x2a,0x00,0x00,0x00,0x23, /* ...)...........# */ \
	0x08,0x00,0x00,0x2b,0x00,0x00,0x00,0x86,0x08,0x00,0x00,0x2c,0x00,0x00,0x00,0x5c, /* ...+.......,...\ */ \
	0x0a,0x00,0x00,0x01,0x00,0x00,0x00,0x7c,0x0a,0x00,0x00,0x02,0x00,0x00,0x00,0x7e, /* .......|.......~ */ \
	0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d, /* inc:header.inc~. */ \
	0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e, /* .<div id="conten */ \
	0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x4c,0x6f,0x67,0x69,0x6e, /* t">....<h1>Login */ \
	0x20,0x53,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x3c,0x2f,0x68,0x31,0x3e, /*  Successful</h1> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x20,0x68,0x61,0x76,0x65,0x20, /* ....<p>You have  */ \
	0x73,0x75,0x63,0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x6c,0x6f,0x67, /* successfully log */ \
	0x67,0x65,0x64,0x20,0x69,0x6e,0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x77,0x65, /* ged in to the we */ \
	0x62,0x20,0x73,0x65,0x72,0x76,0x65,0x72,0x2e,0x20,0x20,0x54,0x68,0x69,0x73,0x20, /* b server.  This  */ \
	0x61,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x0d, /* authentication . */ \
	0x0a,0x69,0x73,0x20,0x76,0x61,0x6c,0x69,0x64,0x20,0x75,0x6e,0x74,0x69,0x6c,0x20, /* .is valid until  */ \
	0x79,0x6f,0x75,0x20,0x63,0x6c,0x6f,0x73,0x65,0x20,0x79,0x6f,0x75,0x72,0x20,0x62, /* you close your b */ \
	0x72,0x6f,0x77,0x73,0x65,0x72,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c, /* rowser.</p>....< */ \
	0x70,0x3e,0x43,0x72,0x65,0x64,0x65,0x6e,0x74,0x69,0x61,0x6c,0x73,0x20,0x61,0x72, /* p>Credentials ar */ \
	0x65,0x20,0x76,0x65,0x72,0x69,0x66,0x69,0x65,0x64,0x20,0x69,0x6e,0x20,0x79,0x6f, /* e verified in yo */ \
	0x75,0x72,0x20,0x6f,0x77,0x6e,0x20,0x63,0x75,0x73,0x74,0x6f,0x6d,0x20,0x63,0x61, /* ur own custom ca */ \
	0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20, /* llback function  */ \
	0x63,0x61,0x6c,0x6c,0x65,0x64,0x20,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48, /* called ..<code>H */ \
	0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c, /* TTPAuthenticate< */ \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x20,0x20,0x49,0x6e,0x20,0x68,0x65,0x72,0x65, /* /code>.  In here */ \
	0x2c,0x20,0x79,0x6f,0x75,0x20,0x63,0x61,0x6e,0x20,0x64,0x65,0x74,0x65,0x72,0x6d, /* , you can determ */ \
	0x69,0x6e,0x65,0x20,0x69,0x66,0x20,0x74,0x68,0x65,0x20,0x73,0x75,0x70,0x70,0x6c, /* ine if the suppl */ \
	0x69,0x65,0x64,0x0d,0x0a,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61, /* ied..user name a */ \
	0x6e,0x64,0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x61,0x72,0x65,0x20, /* nd password are  */ \
	0x76,0x61,0x6c,0x69,0x64,0x20,0x66,0x6f,0x72,0x20,0x61,0x63,0x63,0x65,0x73,0x73, /* valid for access */ \
	0x20,0x74,0x6f,0x20,0x74,0x68,0x65,0x20,0x72,0x65,0x71,0x75,0x65,0x73,0x74,0x65, /*  to the requeste */ \
	0x64,0x20,0x70,0x61,0x67,0x65,0x2e,0x20,0x20,0x59,0x6f,0x75,0x20,0x63,0x61,0x6e, /* d page.  You can */ \
	0x20,0x0d,0x0a,0x61,0x64,0x64,0x20,0x6d,0x75,0x6c,0x74,0x69,0x70,0x6c,0x65,0x20, /*  ..add multiple  */ \
	0x75,0x73,0x65,0x72,0x73,0x20,0x61,0x6e,0x64,0x20,0x72,0x65,0x73,0x74,0x72,0x69, /* users and restri */ \
	0x63,0x74,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x75,0x73,0x65, /* ct different use */ \
	0x72,0x73,0x20,0x74,0x6f,0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20, /* rs to different  */ \
	0x70,0x61,0x67,0x65,0x73,0x2e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70, /* pages.</p>....<p */ \
	0x20,0x63,0x6c,0x61,0x73,0x73,0x3d,0x22,0x65,0x78,0x65,0x72,0x63,0x69,0x73,0x65, /*  class="exercise */ \
	0x22,0x3e,0x3c,0x62,0x3e,0x45,0x78,0x65,0x72,0x63,0x69,0x73,0x65,0x3a,0x3c,0x2f, /* "><b>Exercise:</ */ \
	0x62,0x3e,0x20,0x43,0x68,0x61,0x6e,0x67,0x65,0x20,0x74,0x68,0x65,0x20,0x75,0x73, /* b> Change the us */ \
	0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64,0x20,0x70,0x61,0x73,0x73, /* er name and pass */ \
	0x77,0x6f,0x72,0x64,0x20,0x69,0x6e,0x0d,0x0a,0x3c,0x63,0x6f,0x64,0x65,0x3e,0x48, /* word in..<code>H */ \
	0x54,0x54,0x50,0x41,0x75,0x74,0x68,0x65,0x6e,0x74,0x69,0x63,0x61,0x74,0x65,0x3c, /* TTPAuthenticate< */ \
	0x2f,0x63,0x6f,0x64,0x65,0x3e,0x20,0x74,0x6f,0x20,0x6f,0x6e,0x65,0x20,0x6f,0x66, /* /code> to one of */ \
	0x20,0x79,0x6f,0x75,0x72,0x20,0x63,0x68,0x6f,0x6f,0x73,0x69,0x6e,0x67,0x2e,0x20, /*  your choosing.  */ \
	0x20,0x28,0x54,0x68,0x65,0x20,0x63,0x61,0x6c,0x6c,0x62,0x61,0x63,0x6b,0x20,0x69, /*  (The callback i */ \
	0x73,0x20,0x0d,0x0a,0x6c,0x6f,0x63,0x61,0x74,0x65,0x64,0x20,0x69,0x6e,0x20,0x3c, /* s ..located in < */ \
	0x63,0x6f,0x64,0x65,0x3e,0x43,0x75,0x73,0x74,0x6f,0x6d,0x48,0x54,0x54,0x50,0x41, /* code>CustomHTTPA */ \
	0x70,0x70,0x2e,0x63,0x3c,0x2f,0x63,0x6f,0x64,0x65,0x3e,0x2e,0x29,0x3c,0x2f,0x70, /* pp.c</code>.)</p */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x63,0x6c,0x61,0x73,0x73,0x3d, /* >....<div class= */ \
	0x22,0x65,0x78,0x61,0x6d,0x70,0x6c,0x65,0x62,0x6f,0x78,0x22,0x3e,0x0d,0x0a,0x57, /* "examplebox">..W */ \
	0x68,0x65,0x6e,0x20,0x79,0x6f,0x75,0x20,0x66,0x69,0x6e,0x69,0x73,0x68,0x2c,0x20, /* hen you finish,  */ \
	0x72,0x65,0x66,0x72,0x65,0x73,0x68,0x20,0x74,0x68,0x69,0x73,0x20,0x70,0x61,0x67, /* refresh this pag */ \
	0x65,0x20,0x74,0x6f,0x20,0x74,0x65,0x73,0x74,0x20,0x79,0x6f,0x75,0x72,0x20,0x6e, /* e to test your n */ \
	0x65,0x77,0x20,0x75,0x73,0x65,0x72,0x20,0x6e,0x61,0x6d,0x65,0x20,0x61,0x6e,0x64, /* ew user name and */ \
	0x20,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x20,0x0d,0x0a,0x63,0x6f,0x6d,0x62, /*  password ..comb */ \
	0x69,0x6e,0x61,0x74,0x69,0x6f,0x6e,0x2e,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e  /* ination...</div> */
#define DATACHUNK000009 \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73, /* ....</div>....<s */ \
	0x63,0x72,0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74, /* cript type="text */ \
	0x2f,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c, /* /javascript">..< */ \
	0x21,0x2d,0x2d,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x67,0x65, /* !--..document.ge */ \
	0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49,0x64,0x28,0x27,0x68,0x65, /* tElementById('he */ \
	0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72,0x48,0x54,0x4d,0x4c,0x20, /* llo').innerHTML  */ \
	0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73,0x67,0x7e,0x22,0x3b,0x0d, /* = "~hellomsg~";. */ \
	0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* .//-->..</script */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72, /* >....~inc:footer */ \
	0x2e,0x69,0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x94,0x03,0x00, /* .inc~....3...... */ \
	0x00,0x01,0x00,0x00,0x00,0xb6,0x03,0x00,0x00,0x02,0x00,0x00,0x00,0x7e,0x72,0x65, /* .............~re */ \
	0x62,0x6f,0x6f,0x74,0x7e,0x00,0x00,0x00,0x00,0x2d,0x00,0x00,0x00,0x7e,0x69,0x6e, /* boot~....-...~in */ \
	0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x0d,0x0a,0x3c, /* c:header.inc~..< */ \
	0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f,0x6e,0x74,0x65,0x6e,0x74,0x22, /* div id="content" */ \
	0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x52,0x65,0x62,0x6f,0x6f,0x74,0x20, /* >....<h1>Reboot  */ \
	0x49,0x6e,0x20,0x50,0x72,0x6f,0x67,0x72,0x65,0x73,0x73,0x2e,0x2e,0x2e,0x3c,0x2f, /* In Progress...</ */ \
	0x68,0x31,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x3e,0x59,0x6f,0x75,0x72,0x20,0x73, /* h1>....<p>Your s */ \
	0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x20,0x77,0x65,0x72,0x65,0x20,0x73,0x75,0x63, /* ettings were suc */ \
	0x63,0x65,0x73,0x73,0x66,0x75,0x6c,0x6c,0x79,0x20,0x73,0x61,0x76,0x65,0x64,0x2c, /* cessfully saved, */ \
	0x20,0x61,0x6e,0x64,0x20,0x74,0x68,0x65,0x20,0x62,0x6f,0x61,0x72,0x64,0x20,0x69, /*  and the board i */ \
	0x73,0x20,0x6e,0x6f,0x77,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x69,0x6e,0x67,0x20, /* s now rebooting  */ \
	0x0d,0x0a,0x74,0x6f,0x20,0x63,0x6f,0x6e,0x66,0x69,0x67,0x75,0x72,0x65,0x20,0x69, /* ..to configure i */ \
	0x74,0x73,0x65,0x6c,0x66,0x20,0x77,0x69,0x74,0x68,0x20,0x74,0x68,0x65,0x20,0x6e, /* tself with the n */ \
	0x65,0x77,0x20,0x73,0x65,0x74,0x74,0x69,0x6e,0x67,0x73,0x2e,0x3c,0x2f,0x70,0x3e, /* ew settings.</p> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x70,0x20,0x61,0x6c,0x69,0x67,0x6e,0x3d,0x22,0x63,0x65, /* ....<p align="ce */ \
	0x6e,0x74,0x65,0x72,0x22,0x3e,0x3c,0x62,0x3e,0x59,0x6f,0x75,0x72,0x20,0x62,0x6f, /* nter"><b>Your bo */ \
	0x61,0x72,0x64,0x20,0x69,0x73,0x20,0x6e,0x6f,0x77,0x20,0x6c,0x6f,0x63,0x61,0x74, /* ard is now locat */ \
	0x65,0x64,0x20,0x61,0x74,0x3a,0x20,0x0d,0x0a,0x3c,0x61,0x20,0x68,0x72,0x65,0x66, /* ed at: ..<a href */ \
	0x3d,0x22,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x7e,0x72,0x65,0x62,0x6f,0x6f,0x74, /* ="http://~reboot */ \
	0x61,0x64,0x64,0x72,0x7e,0x2f,0x22,0x3e,0x68,0x74,0x74,0x70,0x3a,0x2f,0x2f,0x7e, /* addr~/">http://~ */ \
	0x72,0x65,0x62,0x6f,0x6f,0x74,0x61,0x64,0x64,0x72,0x7e,0x2f,0x3c,0x2f,0x61,0x3e, /* rebootaddr~/</a> */ \
	0x3c,0x2f,0x62,0x3e,0x3c,0x2f,0x70,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x36,0x3e, /* </b></p>....<h6> */ \
	0x3c,0x2f,0x68,0x36,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d, /* </h6>....</div>. */ \
	0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72,0x69,0x70,0x74,0x20,0x6c,0x61,0x6e,0x67,0x75, /* ...<script langu */ \
	0x61,0x67,0x65,0x3d,0x22,0x6a,0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22, /* age="javascript" */ \
	0x3e,0x0d,0x0a,0x3c,0x21,0x2d,0x2d,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f, /* >..<!--..functio */ \
	0x6e,0x20,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79,0x28,0x78,0x29, /* n rebootDummy(x) */ \
	0x7b,0x7d,0x0d,0x0a,0x73,0x65,0x74,0x54,0x69,0x6d,0x65,0x6f,0x75,0x74,0x28,0x22, /* {}..setTimeout(" */ \
	0x6e,0x65,0x77,0x41,0x4a,0x41,0x58,0x43,0x6f,0x6d,0x6d,0x61,0x6e,0x64,0x28,0x27, /* newAJAXCommand(' */ \
	0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x72,0x65,0x62,0x6f,0x6f,0x74,0x2e, /* /protect/reboot. */ \
	0x63,0x67,0x69,0x27,0x2c,0x72,0x65,0x62,0x6f,0x6f,0x74,0x44,0x75,0x6d,0x6d,0x79, /* cgi',rebootDummy */ \
	0x2c,0x66,0x61,0x6c,0x73,0x65,0x29,0x3b,0x22,0x2c,0x35,0x30,0x30,0x29,0x3b,0x0d, /* ,false);",500);. */ \
	0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74, /* .//-->..</script */ \
	0x3e,0x0d,0x0a,0x7e,0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69, /* >..~inc:footer.i */ \
	0x6e,0x63,0x7e,0x00,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x0c,0x01,0x00,0x00,0x2e, /* nc~....3........ */ \
	0x00,0x00,0x00,0x22,0x01,0x00,0x00,0x2e,0x00,0x00,0x00,0xf6,0x01,0x00,0x00,0x02, /* ..."............ */ \
	0x00,0x00,0x00,0x7e,0x69,0x6e,0x63,0x3a,0x68,0x65,0x61,0x64,0x65,0x72,0x2e,0x69, /* ...~inc:header.i */ \
	0x6e,0x63,0x7e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x20,0x69,0x64,0x3d,0x22,0x63,0x6f, /* nc~..<div id="co */ \
	0x6e,0x74,0x65,0x6e,0x74,0x22,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x68,0x31,0x3e,0x55, /* ntent">....<h1>U */ \
	0x73,0x65,0x72,0x20,0x49,0x44,0x20,0x61,0x6e,0x64,0x20,0x50,0x61,0x73,0x73,0x77, /* ser ID and Passw */ \
	0x6f,0x72,0x64,0x20,0x53,0x65,0x74,0x74,0x69,0x6e,0x67,0x3c,0x2f,0x68,0x31,0x3e, /* ord Setting</h1> */ \
	0x0d,0x0a,0x0d,0x0a,0x3c,0x66,0x6f,0x72,0x6d,0x20,0x6d,0x65,0x74,0x68,0x6f,0x64, /* ....<form method */ \
	0x3d,0x22,0x70,0x6f,0x73,0x74,0x22,0x20,0x61,0x63,0x74,0x69,0x6f,0x6e,0x3d,0x22, /* ="post" action=" */ \
	0x2f,0x70,0x72,0x6f,0x74,0x65,0x63,0x74,0x2f,0x75,0x73,0x65,0x72,0x2e,0x68,0x74, /* /protect/user.ht */ \
	0x6d,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d,0x22,0x75,0x73,0x65,0x72,0x22,0x3e,0x0d, /* m" name="user">. */ \
	0x0a,0x3c,0x66,0x69,0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x64,0x69, /* .<fieldset>..<di */ \
	0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x55,0x73,0x65,0x72,0x20,0x49,0x44, /* v><label>User ID */ \
	0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75, /* :</label>..<inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x22,0x20,0x6e,0x61, /* t type="text" na */ \
	0x6d,0x65,0x3d,0x22,0x75,0x73,0x65,0x72,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d, /* me="user" value= */ \
	0x22,0x7e,0x75,0x73,0x65,0x72,0x5f,0x69,0x64,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* "~user_id~" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65, /* div>..<div><labe */ \
	0x6c,0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62, /* l>Password:</lab */ \
	0x65,0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65  /* el>..<input type */
#define DATACHUNK00000a \
	0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65, /* ="password" name */ \
	0x3d,0x22,0x70,0x77,0x64,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75, /* ="pwd" value="~u */ \
	0x73,0x65,0x72,0x5f,0x70,0x61,0x73,0x73,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f,0x64, /* ser_pass~" /></d */ \
	0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x6c,0x61,0x62,0x65,0x6c, /* iv>..<div><label */ \
	0x3e,0x50,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x3a,0x3c,0x2f,0x6c,0x61,0x62,0x65, /* >Password:</labe */ \
	0x6c,0x3e,0x0d,0x0a,0x3c,0x69,0x6e,0x70,0x75,0x74,0x20,0x74,0x79,0x70,0x65,0x3d, /* l>..<input type= */ \
	0x22,0x70,0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x22,0x20,0x6e,0x61,0x6d,0x65,0x3d, /* "password" name= */ \
	0x22,0x70,0x77,0x64,0x43,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x7e,0x75, /* "pwdC" value="~u */ \
	0x73,0x65,0x72,0x5f,0x70,0x61,0x73,0x73,0x43,0x7e,0x22,0x20,0x2f,0x3e,0x3c,0x2f, /* ser_passC~" /></ */ \
	0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x64,0x69,0x76,0x3e,0x3c,0x69,0x6e,0x70,0x75, /* div>..<div><inpu */ \
	0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x62,0x75,0x74,0x74,0x6f,0x6e,0x22,0x20, /* t type="button"  */ \
	0x20,0x6f,0x6e,0x43,0x6c,0x69,0x63,0x6b,0x3d,0x22,0x70,0x61,0x73,0x73,0x77,0x6f, /*  onClick="passwo */ \
	0x72,0x64,0x43,0x68,0x65,0x63,0x6b,0x28,0x29,0x22,0x20,0x63,0x6c,0x61,0x73,0x73, /* rdCheck()" class */ \
	0x3d,0x22,0x61,0x64,0x31,0x62,0x22,0x20,0x76,0x61,0x6c,0x75,0x65,0x3d,0x22,0x53, /* ="ad1b" value="S */ \
	0x61,0x76,0x65,0x20,0x49,0x44,0x20,0x26,0x20,0x50,0x61,0x73,0x73,0x77,0x6f,0x72, /* ave ID & Passwor */ \
	0x64,0x22,0x2f,0x3e,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x69, /* d"/></div>..</fi */ \
	0x65,0x6c,0x64,0x73,0x65,0x74,0x3e,0x0d,0x0a,0x3c,0x2f,0x66,0x6f,0x72,0x6d,0x3e, /* eldset>..</form> */ \
	0x0d,0x0a,0x3c,0x2f,0x64,0x69,0x76,0x3e,0x0d,0x0a,0x0d,0x0a,0x3c,0x73,0x63,0x72, /* ..</div>....<scr */ \
	0x69,0x70,0x74,0x20,0x74,0x79,0x70,0x65,0x3d,0x22,0x74,0x65,0x78,0x74,0x2f,0x6a, /* ipt type="text/j */ \
	0x61,0x76,0x61,0x73,0x63,0x72,0x69,0x70,0x74,0x22,0x3e,0x0d,0x0a,0x3c,0x21,0x2d, /* avascript">..<!- */ \
	0x2d,0x0d,0x0a,0x2f,0x2f,0x2d,0x2d,0x3e,0x0d,0x0a,0x64,0x6f,0x63,0x75,0x6d,0x65, /* -..//-->..docume */ \
	0x6e,0x74,0x2e,0x67,0x65,0x74,0x45,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x42,0x79,0x49, /* nt.getElementByI */ \
	0x64,0x28,0x27,0x68,0x65,0x6c,0x6c,0x6f,0x27,0x29,0x2e,0x69,0x6e,0x6e,0x65,0x72, /* d('hello').inner */ \
	0x48,0x54,0x4d,0x4c,0x20,0x3d,0x20,0x22,0x7e,0x68,0x65,0x6c,0x6c,0x6f,0x6d,0x73, /* HTML = "~helloms */ \
	0x67,0x7e,0x22,0x3b,0x0d,0x0a,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x20,0x70, /* g~";..function p */ \
	0x61,0x73,0x73,0x77,0x6f,0x72,0x64,0x43,0x68,0x65,0x63,0x6b,0x28,0x29,0x0d,0x0a, /* asswordCheck().. */ \
	0x7b,0x0d,0x0a,0x09,0x69,0x66,0x20,0x28,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74, /* {...if (document */ \
	0x2e,0x75,0x73,0x65,0x72,0x2e,0x70,0x77,0x64,0x2e,0x76,0x61,0x6c,0x75,0x65,0x20, /* .user.pwd.value  */ \
	0x21,0x3d,0x20,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73,0x65,0x72, /* != document.user */ \
	0x2e,0x70,0x77,0x64,0x43,0x2e,0x76,0x61,0x6c,0x75,0x65,0x29,0x0d,0x0a,0x09,0x7b, /* .pwdC.value)...{ */ \
	0x0d,0x0a,0x09,0x09,0x61,0x6c,0x65,0x72,0x74,0x20,0x28,0x22,0x50,0x61,0x73,0x73, /* ....alert ("Pass */ \
	0x77,0x6f,0x72,0x64,0x20,0x6d,0x69,0x73,0x73,0x6d,0x61,0x74,0x63,0x68,0x21,0x22, /* word missmatch!" */ \
	0x29,0x3b,0x0d,0x0a,0x09,0x09,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0d,0x0a,0x09, /* );....return;... */ \
	0x7d,0x0d,0x0a,0x09,0x64,0x6f,0x63,0x75,0x6d,0x65,0x6e,0x74,0x2e,0x75,0x73,0x65, /* }...document.use */ \
	0x72,0x2e,0x73,0x75,0x62,0x6d,0x69,0x74,0x28,0x29,0x3b,0x0d,0x0a,0x0d,0x0a,0x7d, /* r.submit();....} */ \
	0x0d,0x0a,0x3c,0x2f,0x73,0x63,0x72,0x69,0x70,0x74,0x3e,0x0d,0x0a,0x0d,0x0a,0x7e, /* ..</script>....~ */ \
	0x69,0x6e,0x63,0x3a,0x66,0x6f,0x6f,0x74,0x65,0x72,0x2e,0x69,0x6e,0x63,0x7e,0x00, /* inc:footer.inc~. */ \
	0x00,0x00,0x00,0x33,0x00,0x00,0x00,0xde,0x00,0x00,0x00,0x6a,0x00,0x00,0x00,0x3b, /* ...3.......j...; */ \
	0x01,0x00,0x00,0x6b,0x00,0x00,0x00,0x9b,0x01,0x00,0x00,0x6c,0x00,0x00,0x00,0x95, /* ...k.......l.... */ \
	0x02,0x00,0x00,0x01,0x00,0x00,0x00,0x5c,0x03,0x00,0x00,0x02,0x00,0x00,0x00       /* .......\.......  */


/**************************************
 * MPFS2 C linkable symbols
 **************************************/
// For C18, these are split into seperate arrays because it speeds up compilation a lot.  
// For other compilers, the entire data array must be defined as a single variable to 
// ensure that the linker does not reorder the data chunks in Flash when compiler 
// optimizations are turned on.
#if defined(__18CXX)
	ROM BYTE MPFS_Start[] = {DATACHUNK000000};
	ROM BYTE MPFS_000001[] = {DATACHUNK000001};
	ROM BYTE MPFS_000002[] = {DATACHUNK000002};
	ROM BYTE MPFS_000003[] = {DATACHUNK000003};
	ROM BYTE MPFS_000004[] = {DATACHUNK000004};
	ROM BYTE MPFS_000005[] = {DATACHUNK000005};
	ROM BYTE MPFS_000006[] = {DATACHUNK000006};
	ROM BYTE MPFS_000007[] = {DATACHUNK000007};
	ROM BYTE MPFS_000008[] = {DATACHUNK000008};
	ROM BYTE MPFS_000009[] = {DATACHUNK000009};
	ROM BYTE MPFS_00000a[] = {DATACHUNK00000a};
#else
	ROM BYTE MPFS_Start[] = {DATACHUNK000000, DATACHUNK000001, DATACHUNK000002, DATACHUNK000003, DATACHUNK000004, DATACHUNK000005, DATACHUNK000006, DATACHUNK000007, DATACHUNK000008, DATACHUNK000009, DATACHUNK00000a};
#endif


/**************************************************************
 * End of MPFS
 **************************************************************/
#endif // #if defined(STACK_USE_MPFS2)
#endif // #if !defined(MPFS_USE_EEPROM) && !defined(MPFS_USE_SPI_FLASH)
