package tamanegisoul.pl.action;

import java.util.ArrayList;
import java.util.List;

import tamanegisoul.pl.AppContext;
import tamanegisoul.pl.R;
import tamanegisoul.pl.data.AlbumInfo;
import tamanegisoul.pl.picasa.Picasa;
import tamanegisoul.pl.widget.AlbumInfoAdapter;
import tamanegisoul.pl.widget.CacheMenuDialogBuilder;
import android.app.ListActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;

public class SynchronizeActivity extends ListActivity {

    private ArrayList<AlbumInfo> mAlbumInfos;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        Log.d(AppContext.NAME, "SynchronizeActivity.onCreate");
        super.onCreate(savedInstanceState);
        setContentView(R.layout.synchronize);
    }

    @Override
    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putSerializable("albumInfos", mAlbumInfos);
    }

    @SuppressWarnings("unchecked")
    @Override
    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        mAlbumInfos = (ArrayList<AlbumInfo>) savedInstanceState.getSerializable("albumInfos");
    }

    @Override
    public void onResume() {
        Log.d(AppContext.NAME, "SynchronizeActivity.onResume");
        super.onResume();
        if (mAlbumInfos == null)
            mAlbumInfos = Picasa.getInstance().getAlbumInfos();
        setListAdapter(new AlbumInfoAdapter(this, (List<AlbumInfo>) mAlbumInfos));
        getListView().setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(final AdapterView<?> arg0, View arg1, final int arg2, long arg3) {
                AlbumInfo info = ((AlbumInfoAdapter) arg0.getAdapter()).getItem(arg2);
                Log.d(AppContext.NAME, String.format("(%s) item clicked: %s", SynchronizeActivity.class, info));
                new CacheMenuDialogBuilder(arg0.getContext(), info).show();
            }
        });
    }
}