package tamanegisoul.pl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.ContentValues;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Bitmap.CompressFormat;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.provider.MediaStore.Images;
import android.util.Log;

public final class CacheUtils {

    private static final File ROOT = new File(Environment.getExternalStorageDirectory(), "PicasaLife");
    private static final File CACHE = new File(ROOT, "cache");

    public static long getSize(String albumTitle) {
        File f = new File(CACHE, albumTitle);
        return getSize(f);
    }

    public static void cache(String albumTitle, String title, InputStream in) throws IOException {
        Bitmap bm = BitmapFactory.decodeStream(in);

        int w = bm.getWidth();
        int h = bm.getHeight();
        float scale = 800f / Math.max(w, h);
        Log.d(AppContext.NAME, String.format("hogehoge %d %d %f", w, h, scale));
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        bm = Bitmap.createBitmap(bm, 0, 0, w, h, matrix, true);

        File p = new File(CACHE, albumTitle);
        p.mkdirs();
        File f = new File(p, title);
        Log.d(AppContext.NAME, String.format("caching %s", f.getAbsolutePath()));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
        bm.compress(CompressFormat.JPEG, 80, out);
        out.flush();
        out.close();

        ContentResolver contentResolver = AppContext.instance.getContext().getContentResolver();
        ContentValues values = new ContentValues();
        values.put(Images.Media.DATA, f.getPath());
        values.put(Images.Media.SIZE, f.length());
        values.put(Images.Media.DISPLAY_NAME, f.getName());
        values.put(Images.Media.MIME_TYPE, "image/jpeg");
        values.put(Images.Media.TITLE, f.getName());
        contentResolver.insert(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, values);
    }

    public static void clearCache(String albumTitle) {
        deleteFile(new File(CACHE, albumTitle));
    }

    private static long getSize(File file) {
        if (!file.exists()) {
            return 0;
        } else if (file.isDirectory()) {
            long size = 0;
            for (File f : file.listFiles()) {
                size += getSize(f);
            }
            return size;
        } else {
            return file.length();
        }
    }

    private static void deleteFile(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    deleteFile(f);
                }
            }
            if(file.isFile()){
                ContentResolver contentResolver = AppContext.instance.getContext().getContentResolver();
                Cursor cursor = null;
                try{
                    cursor = contentResolver.query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI,
                            new String[] {MediaStore.Images.Media._ID},
                                MediaStore.Images.Media.DATA + " = ?",
                                new String[]{file.getAbsolutePath()},
                                null);
                    if(cursor.getCount() != 0) {
                        cursor.moveToFirst();
                        Uri uri = ContentUris.appendId(
                                MediaStore.Images.Media.EXTERNAL_CONTENT_URI.buildUpon(),
                                cursor.getLong(cursor.getColumnIndex(MediaStore.Images.Media._ID))).build();
                        contentResolver.delete(uri, null, null);
                    }
                }finally {
                     if(cursor != null)
                     cursor.close();
                    }
                }
//                MediaScannerConnection.scanFile(AppContext.instance.getContext(), new String[] { file.getAbsolutePath() }, null, new MediaScannerConnection.OnScanCompletedListener() {
//                    @Override
//                    public void onScanCompleted(String path, Uri uri) {
//                        Log.d(AppContext.NAME, "hogehoge");
//                        Log.d(AppContext.NAME, path);
//                        Log.d(AppContext.NAME, uri.toString());
//                    }
//                });
            file.delete();
        }
    }
}
