package tamanegisoul.pl.action;

import tamanegisoul.pl.R;
import android.accounts.Account;
import android.accounts.AccountManager;
import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.PreferenceActivity;

public class AppPreferenceActivity extends PreferenceActivity implements OnSharedPreferenceChangeListener {
	
    private static final String KEY_ACCOUNT = "account";
    private static final String KEY_DOWNLOAD_SIZE = "download_size";
	
	/** Called when the activity is first created. */
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		addPreferencesFromResource(R.layout.preferences);
	}
	
	@Override
	public void onResume() {
		super.onResume();
		AccountManager accountManager = AccountManager.get(this);
		Account[] accounts = accountManager.getAccountsByType("com.google");
		String[] accountStrings = new String[accounts.length];
		for (int i = 0; i < accountStrings.length; i++){
			accountStrings[i] = accounts[i].name;
		}
		ListPreference accountPreference = (ListPreference)findPreference(KEY_ACCOUNT);
		accountPreference.setEntries(accountStrings);
		accountPreference.setEntryValues(accountStrings);

		setPreferenceSummary();
		getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener(this);
	}

	@Override
	public void onPause(){
		super.onPause();
		getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);
	}

	@Override
	public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
		setPreferenceSummary();
	}
	
	private void setPreferenceSummary(){
		SharedPreferences sharedPreferences = getPreferenceScreen().getSharedPreferences();
        ((ListPreference)findPreference(KEY_ACCOUNT)).setSummary(sharedPreferences.getString(KEY_ACCOUNT, getResources().getString(R.string.not_selected)));
        ((ListPreference)findPreference(KEY_DOWNLOAD_SIZE)).setSummary(sharedPreferences.getString(KEY_DOWNLOAD_SIZE, getResources().getString(R.string.not_selected)));
	}
}