/*
 * Created on 2006/03/16
 *
 * Copyright (C) 2005- Monami software, LP.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Monami software, LP. - Initial API and implementation
 */
package jp.pizzafactory.crosschains;

import org.eclipse.cdt.core.ICExtension;
import org.eclipse.cdt.utils.DefaultGnuToolFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class PizzaGnuToolFactory extends DefaultGnuToolFactory {
	static final String CMDNAME_ADDR2LINE = "-addr2line"; //$NON-NLS-1$
	static final String CMDNAME_CPPFILT   = "-c++filt"; //$NON-NLS-1$
	static final String CMDNAME_NM        = "-nm"; //$NON-NLS-1$
	static final String CMDNAME_OBJDUMP   = "-objdump"; //$NON-NLS-1$
	static final String CMDNAME_STRIP     = "-strip"; //$NON-NLS-1$
	static final String CMDEXT_EXE = "exe";  //$NON-NLS-1$
	private final IPath binDirPath;
	private final String arch;
	
	public PizzaGnuToolFactory(Bundle bundle, String arch, ICExtension ext) {
		super(ext);

		PizzaBinPath pizzaBinPath = new PizzaBinPath();
		String binPathStr = pizzaBinPath.getValue(bundle);
		binDirPath = Path.fromOSString(binPathStr);
		this.arch = arch;
	}

	protected IPath getAddr2linePath() {
		return getPath(CMDNAME_ADDR2LINE);
	}

	protected IPath getCPPFiltPath() {
		return getPath(CMDNAME_CPPFILT);
	}

	protected IPath getNMPath() {
		return getPath(CMDNAME_NM);
	}

	protected IPath getObjdumpPath() {
		return getPath(CMDNAME_OBJDUMP);
	}
	
	protected IPath getStripPath() {
		return getPath(CMDNAME_STRIP);
	}

	private IPath getPath(String cmdName) {
		IPath fullPath = binDirPath.append(arch + cmdName);
		if (isWindows()) {
			fullPath = fullPath.addFileExtension(CMDEXT_EXE);
		}
		return fullPath;
	}
	
	private boolean isWindows() {
		return Platform.getOS().equals(Platform.OS_WIN32);
	}
}
