package jp.pizzafactory.crosschains.managedbuild;

import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.makegen.gnu.GnuMakefileGenerator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class PizzaGnuMakefileGenerator extends GnuMakefileGenerator {

	private static final String EXTENSION_MACROFILEPROVIDER = "jp.pizzafactory.crosschains.managedBuildMacroContentProvider"; //$NON-NLS-1$
	private static final String NATUREID = "natureID"; //$NON-NLS-1$
	private static final String CLASS = "class"; //$NON-NLS-1$
	private static final String ERROR_MESSAGE = "ERROR_MESSAGE := $(error internal error in addTopHeader().";

	private IProject project;
	
	public void initialize(IProject project, IManagedBuildInfo info, IProgressMonitor monitor) {
		super.initialize(project, info, monitor);
		this.project = project;
	}

	private IManagedBuildMacroContentProvider getManagedBuildMacroFileProvider() throws CoreException {
		IManagedBuildMacroContentProvider result = null;
		int count = 0;
		IExtensionRegistry registry = Platform.getExtensionRegistry();
		IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_MACROFILEPROVIDER);
		for (IConfigurationElement element : extensionPoint.getConfigurationElements()) {
			String natureId = element.getAttribute(NATUREID);
			if (natureId != null &&
					project.isNatureEnabled(natureId)) {
				Object o = element.createExecutableExtension(CLASS);
				if (o instanceof IManagedBuildMacroContentProvider) {
					result = (IManagedBuildMacroContentProvider)o;
					count++;
				}
			}
		}
		
		Assert.isTrue(count < 2);
		
		return result;
	}
	@Override
	protected StringBuffer addTopHeader() {

		StringBuffer buffer = super.addTopHeader();
		try {
			IManagedBuildMacroContentProvider provider = getManagedBuildMacroFileProvider();
			StringBuffer macros = provider.generateMacroContents(project);
			buffer.append(macros);
		} catch (CoreException e) {
			buffer.append(ERROR_MESSAGE + e.getMessage());
		}
		
		return buffer;
	}

}
