/*
 * Created on 2007/02/09
 *
 * Copyright (C) 2005- Monami software, LP.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Monami software, LP. - Initial API and implementation
 */
package jp.pizzafactory.crosschains.managedbuild.ui;

import java.util.ArrayList;

import org.eclipse.cdt.managedbuilder.ui.wizards.CProjectPlatformPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPage;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageData;
import org.eclipse.cdt.managedbuilder.ui.wizards.MBSCustomPageManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class WizardSelectSamplePage extends MBSCustomPage {
	public static final String PAGE_ID = "jp.pizzafactory.crosschains.managedbuild.ui.wizardPage"; //$NON-NLS-1$
	private final String TEMPLATE_ID = "jp.pizzafactory.crosschains.codeTemplate"; //$NON-NLS-1$
	public static final String ELEMENT = "element"; //$NON-NLS-1$
	private Composite composite;
	private String description;
	private ImageDescriptor imageDescriptor;
	private String title = "Templates selection";
	private String errorMessage;
	private org.eclipse.swt.widgets.List templateList;
	private IConfigurationElement[] configurationElements;
	private String projectTypeId;
	
	public WizardSelectSamplePage() {
		super(PAGE_ID);
	}

	public boolean isPageComplete() {
		int i = templateList.getSelectionCount();
		return (i >= 0);
	}

	protected boolean isCustomPageComplete() {
		return isPageComplete();
	}
	
	public String getName() {
		return "name";
	}

	public void createControl(Composite parent) {
        composite = new Composite(parent, SWT.NONE);
        composite.setLayout(new FillLayout());
 
        new Label(composite, SWT.NONE).setText("Select template.");
        templateList = new org.eclipse.swt.widgets.List(composite, SWT.SINGLE|SWT.BORDER|SWT.V_SCROLL);
        templateList.addSelectionListener(new SelectionListener() {

			public void widgetDefaultSelected(SelectionEvent e) {
				// TODO Auto-generated method stub
				
			}

			public void widgetSelected(SelectionEvent e) {
				int index = templateList.getSelectionIndex();
				if (index >= 0) {
					MBSCustomPageManager.addPageProperty(PAGE_ID, ELEMENT, configurationElements[index]);
				}
			}});
        
	}

	public void dispose() {
	}

	public Control getControl() {
		return composite;
	}

	public String getDescription() {
		return description;
	}

	public String getErrorMessage() {
		return errorMessage ;
	}

	public Image getImage() {
		IWizard wizard = getWizard();
		if (wizard != null)
            return wizard.getDefaultPageImage();
		return null;
	}

	public String getMessage() {
		return "Select the environment template.";
	}

	public String getTitle() {
		return title;
	}

	public void performHelp() {
	}

	public void setDescription(String description) {
		this.description = description;
		wizard.getContainer().updateTitleBar();
	}

	public void setImageDescriptor(ImageDescriptor image) {
        		imageDescriptor = image;
	}

	public void setTitle(String title) {
		this.title  = title;
	}

	public void setVisible(boolean visible) {
		if (visible) {
			
	        MBSCustomPageData pageData = MBSCustomPageManager.getPageData(CProjectPlatformPage.PAGE_ID);
			IWizardPage wizardPage = pageData.getWizardPage();
			CProjectPlatformPage cProjectPlatformPage = (CProjectPlatformPage)wizardPage;
			String id = cProjectPlatformPage.getSelectedProjectType().getId();
			if (projectTypeId == null || !projectTypeId.equals(id)) {
				projectTypeId = id;
		        IExtensionRegistry registry = Platform.getExtensionRegistry();
		        IExtensionPoint extensionPoint =
		        	registry.getExtensionPoint(TEMPLATE_ID);
		        IExtension[] extensions = extensionPoint.getExtensions();
		        ArrayList elementList = new ArrayList();
		        
		        templateList.removeAll();
				MBSCustomPageManager.addPageProperty(PAGE_ID, ELEMENT, null);
				
		        for (int i = 0; i < extensions.length; i++) {
		        	IConfigurationElement[] elements =
		        		extensions[i].getConfigurationElements();
		        	for (int j = 0; j < elements.length; j++) {
		        		if (elements[j].getName().equals("template")) { //$NON-NLS-1$
		    				String typeId = elements[j].getAttribute("projectTypeId"); //$NON-NLS-1$
		    				if (typeId == null || typeId.equals(projectTypeId)) {
		        				String name = elements[j].getAttribute("name"); //$NON-NLS-1$
		        				templateList.add(name);
		        				elementList.add(elements[j]);
		        			}
		        		}
		        	}
		        }
		        configurationElements = (IConfigurationElement[]) elementList.toArray(new IConfigurationElement[elementList.size()]);
			}			
		}
		composite.setVisible(visible);
	}

	public void modifyText(ModifyEvent e) {
		errorMessage = null;
		
		IWizard wizard = getWizard();
		wizard.getContainer().updateTitleBar();
		wizard.getContainer().updateButtons();
	}
}
