/*
 * Created on 2006/09/23
 *
 * Copyright (C) 2005- Monami software, LP.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Monami software, LP. - Initial API and implementation
 */
package jp.pizzafactory.debug.core;

import org.eclipse.cdt.core.IBinaryParser.IBinaryObject;
import org.eclipse.cdt.debug.core.ICDTLaunchConfigurationConstants;
import org.eclipse.cdt.debug.core.cdi.model.ICDITarget;
import org.eclipse.cdt.debug.core.cdi.model.ICDITargetConfiguration;
import org.eclipse.cdt.debug.internal.core.model.CDebugTarget;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;

public class StubRemoteDebugTarget extends CDebugTarget {

	public StubRemoteDebugTarget(ILaunch launch, IProject project, ICDITarget cdiTarget, String name, IProcess debuggeeProcess, IBinaryObject file, boolean allowsTerminate, boolean allowsDisconnect) {
		super(launch, project, cdiTarget, name, debuggeeProcess, file, allowsTerminate,
				allowsDisconnect);
	}

	public void ready( boolean stopInMain) throws DebugException {
		String stopSymbol = null;
		try {
			if ( stopInMain )
				stopSymbol = getLaunch().getLaunchConfiguration().getAttribute( ICDTLaunchConfigurationConstants.ATTR_DEBUGGER_STOP_AT_MAIN_SYMBOL, ICDTLaunchConfigurationConstants.DEBUGGER_STOP_AT_MAIN_SYMBOL_DEFAULT );
		}
		catch( CoreException e ) {
			throw new DebugException( e.getStatus() );
		}
		ICDITargetConfiguration config = getConfiguration();
		if ( config.supportsBreakpoints() ) {
			getBreakpointManager().setInitialBreakpoints();
			if ( stopSymbol != null && stopSymbol.length() != 0 ) {
				stopAtSymbol( stopSymbol );
			}
		}
	}

	public void ready( String stopSymbol) throws DebugException {
		ICDITargetConfiguration config = getConfiguration();
		if ( config.supportsBreakpoints() ) {
			getBreakpointManager().setInitialBreakpoints();
			if ( stopSymbol != null && stopSymbol.length() != 0 ) {
				stopAtSymbol( stopSymbol );
			}
		}
	}

}
