/*
 * Created on 2006/10/10
 *
 * Copyright (C) 2005- Monami software, LP.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Monami software, LP. - Initial API and implementation
 */
package jp.pizzafactory.debug.core.gdbproxy;

import jp.pizzafactory.debug.core.CorePlugin;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.RefreshTab;

public class LaunchConfigurationDelegate implements
		ILaunchConfigurationDelegate {

	public void launch(ILaunchConfiguration configuration, String mode,
			ILaunch launch, IProgressMonitor monitor) throws CoreException {

		if (monitor.isCanceled()) {
			return;
		}

		String[] cmdLine = buildUpCommandLine(configuration);
		
		Process p = DebugPlugin.exec(cmdLine, null, null);
		IProcess process = null;


		if (p != null) {
			String label = configuration.getAttribute(IGdbProxyResourceConstants.ATTR_LABEL, "GDB proxy"); //$NON-NLS-1$
			
			monitor.beginTask("Launching GDB proxy...", IProgressMonitor.UNKNOWN);
			process = DebugPlugin.newProcess(launch, p, label, null);
			if (process == null) {
				p.destroy();
				String plugin_id = CorePlugin.getUniqueIdentifier();
				throw new CoreException(new Status(IStatus.ERROR, plugin_id, 0, "Failed to call DebugPlugin.newProcess", null));
			}
			
		}


		if (monitor.isCanceled()) {
			process.terminate();
			return;
		}

		// refresh resources after process finishes
		if (RefreshTab.getRefreshScope(configuration) != null) {
			BackgroundResourceRefresher refresher = new BackgroundResourceRefresher(configuration, process);
			refresher.startBackgroundRefresh();
		}				
	}

	private String[] buildUpCommandLine(ILaunchConfiguration configuration) throws CoreException {
		String cmdName = configuration.getAttribute(IGdbProxyResourceConstants.ATTR_LOCATION, "c:/cygwin/usr/local/bin/gdbproxy.exe"); //$NON-NLS-1$
		String argLine = configuration.getAttribute(IGdbProxyResourceConstants.ATTR_TOOL_ARGUMENTS, "invalid"); //$NON-NLS-1$
		String[] arguments = argLine.split(" "); //$NON-NLS-1$
		String[] cmdLine = new String[1 + arguments.length];
		cmdLine[0] = cmdName;
		System.arraycopy(arguments, 0, cmdLine, 1, arguments.length);
		
		return cmdLine;
	}
}
