/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.openxml4j.opc.internal.marshallers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.openxml4j.opc.StreamHelper;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.openxml4j.opc.internal.PartMarshaller;
import org.apache.poi.openxml4j.opc.internal.ZipHelper;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public final class ZipPartMarshaller
implements PartMarshaller {
    private static POILogger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.openxml4j.opc.internal.marshallers.ZipPartMarshaller");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = POILogFactory.getLogger((Class)clazz);
    }

    public boolean marshall(PackagePart part, OutputStream os) throws OpenXML4JException {
        if (!(os instanceof ZipOutputStream)) {
            logger.log(POILogger.ERROR, (Object)("Unexpected class " + os.getClass().getName()));
            throw new OpenXML4JException("ZipOutputStream expected !");
        }
        ZipOutputStream zos = (ZipOutputStream)os;
        ZipEntry partEntry = new ZipEntry(ZipHelper.getZipItemNameFromOPCName(part.getPartName().getURI().getPath()));
        try {
            zos.putNextEntry(partEntry);
            InputStream ins = part.getInputStream();
            byte[] buff = new byte[8192];
            while (ins.available() > 0) {
                int resultRead = ins.read(buff);
                if (resultRead == -1) break;
                zos.write(buff, 0, resultRead);
            }
            zos.closeEntry();
        }
        catch (IOException ioe) {
            logger.log(POILogger.ERROR, (Object)("Cannot write: " + part.getPartName() + ": in ZIP"), (Throwable)ioe);
            return false;
        }
        if (part.hasRelationships()) {
            PackagePartName relationshipPartName = PackagingURIHelper.getRelationshipPartName(part.getPartName());
            ZipPartMarshaller.marshallRelationshipPart(part.getRelationships(), relationshipPartName, zos);
        }
        return true;
    }

    public static boolean marshallRelationshipPart(PackageRelationshipCollection rels, PackagePartName relPartName, ZipOutputStream zos) {
        block7: {
            Document xmlOutDoc = DocumentHelper.createDocument();
            Namespace dfNs = Namespace.get((String)"", (String)"http://schemas.openxmlformats.org/package/2006/relationships");
            Element root = xmlOutDoc.addElement(new QName("Relationships", dfNs));
            URI sourcePartURI = PackagingURIHelper.getSourcePartUriFromRelationshipPartUri(relPartName.getURI());
            Iterator iterator = rels.iterator();
            while (iterator.hasNext()) {
                String targetValue;
                PackageRelationship rel = (PackageRelationship)iterator.next();
                Element relElem = root.addElement("Relationship");
                relElem.addAttribute("Id", rel.getId());
                relElem.addAttribute("Type", rel.getRelationshipType());
                URI uri = rel.getTargetURI();
                if (rel.getTargetMode() == TargetMode.EXTERNAL) {
                    targetValue = uri.toString();
                    relElem.addAttribute("TargetMode", "External");
                } else {
                    URI targetURI = rel.getTargetURI();
                    targetValue = PackagingURIHelper.relativizeURI(sourcePartURI, targetURI, true).getPath();
                    if (targetURI.getRawFragment() != null) {
                        targetValue = String.valueOf(targetValue) + "#" + targetURI.getRawFragment();
                    }
                }
                relElem.addAttribute("Target", targetValue);
            }
            xmlOutDoc.normalize();
            ZipEntry ctEntry = new ZipEntry(ZipHelper.getZipURIFromOPCName(relPartName.getURI().toASCIIString()).getPath());
            try {
                zos.putNextEntry(ctEntry);
                if (StreamHelper.saveXmlInStream(xmlOutDoc, zos)) break block7;
                return false;
            }
            catch (IOException e) {
                logger.log(POILogger.ERROR, (Object)("Cannot create zip entry " + relPartName), (Throwable)e);
                return false;
            }
        }
        zos.closeEntry();
        return true;
    }
}

