/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class EvilUnclosedBRFixingInputStream
extends InputStream {
    private InputStream source;
    private byte[] spare;
    private static byte[] detect = new byte[]{60, 98, 114, 62};

    public EvilUnclosedBRFixingInputStream(InputStream source) {
        this.source = source;
    }

    public int read() throws IOException {
        return this.source.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.spare != null) {
            System.arraycopy(this.spare, 0, b, off, this.spare.length);
            int ret = this.spare.length;
            this.spare = null;
            return ret;
        }
        int read = this.source.read(b, off, len);
        read = this.fixUp(b, off, read);
        return read;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    private int fixUp(byte[] b, int offset, int read) {
        ArrayList<Integer> fixAt = new ArrayList<Integer>();
        int i = offset;
        while (i < offset + read - 4) {
            boolean going = true;
            int j = 0;
            while (j < detect.length && going) {
                if (b[i + j] != detect[j]) {
                    going = false;
                }
                ++j;
            }
            if (going) {
                fixAt.add(new Integer(i));
            }
            ++i;
        }
        if (fixAt.size() == 0) {
            return read;
        }
        int overshoot = offset + read + fixAt.size() - b.length;
        if (overshoot > 0) {
            this.spare = new byte[overshoot];
            System.arraycopy(b, b.length - overshoot, this.spare, 0, overshoot);
            read -= overshoot;
        }
        int j = fixAt.size() - 1;
        while (j >= 0) {
            int i2 = (Integer)fixAt.get(j);
            byte[] tmp = new byte[read - i2 - 3];
            System.arraycopy(b, i2 + 3, tmp, 0, tmp.length);
            b[i2 + 3] = 47;
            System.arraycopy(tmp, 0, b, i2 + 4, tmp.length);
            ++read;
            --j;
        }
        return read;
    }
}

