/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.LittleEndianOutput;

public final class TabIdRecord
extends StandardRecord {
    public static final short sid = 317;
    private static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public short[] _tabids;

    public TabIdRecord() {
        this._tabids = EMPTY_SHORT_ARRAY;
    }

    public TabIdRecord(RecordInputStream in) {
        int nTabs = in.remaining() / 2;
        this._tabids = new short[nTabs];
        int i = 0;
        while (i < this._tabids.length) {
            this._tabids[i] = in.readShort();
            ++i;
        }
    }

    public void setTabIdArray(short[] array) {
        this._tabids = array;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[TABID]\n");
        buffer.append("    .elements        = ").append(this._tabids.length).append("\n");
        int i = 0;
        while (i < this._tabids.length) {
            buffer.append("    .element_").append(i).append(" = ").append(this._tabids[i]).append("\n");
            ++i;
        }
        buffer.append("[/TABID]\n");
        return buffer.toString();
    }

    public void serialize(LittleEndianOutput out) {
        short[] tabids = this._tabids;
        int i = 0;
        while (i < tabids.length) {
            out.writeShort(tabids[i]);
            ++i;
        }
    }

    protected int getDataSize() {
        return this._tabids.length * 2;
    }

    public short getSid() {
        return 317;
    }
}

