/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.ss.formula.TwoDEval;

final class CountUtils {
    private CountUtils() {
    }

    public static int countMatchingCellsInArea(TwoDEval areaEval, I_MatchPredicate criteriaPredicate) {
        int result = 0;
        int height = areaEval.getHeight();
        int width = areaEval.getWidth();
        int rrIx = 0;
        while (rrIx < height) {
            int rcIx = 0;
            while (rcIx < width) {
                ValueEval ve = areaEval.getValue(rrIx, rcIx);
                if (criteriaPredicate.matches(ve)) {
                    ++result;
                }
                ++rcIx;
            }
            ++rrIx;
        }
        return result;
    }

    public static int countMatchingCell(RefEval refEval, I_MatchPredicate criteriaPredicate) {
        if (criteriaPredicate.matches(refEval.getInnerValueEval())) {
            return 1;
        }
        return 0;
    }

    public static int countArg(ValueEval eval, I_MatchPredicate criteriaPredicate) {
        if (eval == null) {
            throw new IllegalArgumentException("eval must not be null");
        }
        if (eval instanceof TwoDEval) {
            return CountUtils.countMatchingCellsInArea((TwoDEval)eval, criteriaPredicate);
        }
        if (eval instanceof RefEval) {
            return CountUtils.countMatchingCell((RefEval)eval, criteriaPredicate);
        }
        return criteriaPredicate.matches(eval) ? 1 : 0;
    }

    public static interface I_MatchPredicate {
        public boolean matches(ValueEval var1);
    }
}

