/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import org.apache.poi.hwpf.model.HDFType;
import org.apache.poi.hwpf.model.StyleDescription;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.hwpf.sprm.CharacterSprmUncompressor;
import org.apache.poi.hwpf.sprm.ParagraphSprmUncompressor;
import org.apache.poi.hwpf.usermodel.CharacterProperties;
import org.apache.poi.hwpf.usermodel.ParagraphProperties;
import org.apache.poi.util.LittleEndian;

public final class StyleSheet
implements HDFType {
    public static final int NIL_STYLE = 4095;
    private static final int PAP_TYPE = 1;
    private static final int CHP_TYPE = 2;
    private static final int SEP_TYPE = 4;
    private static final int TAP_TYPE = 5;
    private static final ParagraphProperties NIL_PAP = new ParagraphProperties();
    private static final CharacterProperties NIL_CHP = new CharacterProperties();
    private int _stshiLength;
    private int _baseLength;
    private int _flags;
    private int _maxIndex;
    private int _maxFixedIndex;
    private int _stylenameVersion;
    private int[] _rgftc;
    StyleDescription[] _styleDescriptions;

    public StyleSheet(byte[] tableStream, int offset) {
        int startOffset = offset;
        this._stshiLength = LittleEndian.getShort((byte[])tableStream, (int)offset);
        int stdCount = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        this._baseLength = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        this._flags = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        this._maxIndex = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        this._maxFixedIndex = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        this._stylenameVersion = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        this._rgftc = new int[3];
        this._rgftc[0] = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        this._rgftc[1] = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        this._rgftc[2] = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        offset += 2;
        offset = startOffset + 2 + this._stshiLength;
        this._styleDescriptions = new StyleDescription[stdCount];
        int x = 0;
        while (x < stdCount) {
            short stdSize = LittleEndian.getShort((byte[])tableStream, (int)offset);
            offset += 2;
            if (stdSize > 0) {
                StyleDescription aStyle;
                this._styleDescriptions[x] = aStyle = new StyleDescription(tableStream, this._baseLength, offset, true);
            }
            offset += stdSize;
            ++x;
        }
        x = 0;
        while (x < this._styleDescriptions.length) {
            if (this._styleDescriptions[x] != null) {
                this.createPap(x);
                this.createChp(x);
            }
            ++x;
        }
    }

    public void writeTo(HWPFOutputStream out) throws IOException {
        int offset = 0;
        byte[] buf = new byte[this._stshiLength + 2];
        LittleEndian.putShort((byte[])buf, (int)offset, (short)((short)this._stshiLength));
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)((short)this._styleDescriptions.length));
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)((short)this._baseLength));
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)((short)this._flags));
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)((short)this._maxIndex));
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)((short)this._maxFixedIndex));
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)((short)this._stylenameVersion));
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)((short)this._rgftc[0]));
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)((short)this._rgftc[1]));
        LittleEndian.putShort((byte[])buf, (int)(offset += 2), (short)((short)this._rgftc[2]));
        out.write(buf);
        byte[] sizeHolder = new byte[2];
        int x = 0;
        while (x < this._styleDescriptions.length) {
            if (this._styleDescriptions[x] != null) {
                byte[] std = this._styleDescriptions[x].toByteArray();
                LittleEndian.putShort((byte[])sizeHolder, (short)((short)(std.length + std.length % 2)));
                out.write(sizeHolder);
                out.write(std);
                if (std.length % 2 == 1) {
                    out.write(0);
                }
            } else {
                sizeHolder[0] = 0;
                sizeHolder[1] = 0;
                out.write(sizeHolder);
            }
            ++x;
        }
    }

    public boolean equals(Object o) {
        StyleSheet ss = (StyleSheet)o;
        if (ss._baseLength == this._baseLength && ss._flags == this._flags && ss._maxFixedIndex == this._maxFixedIndex && ss._maxIndex == this._maxIndex && ss._rgftc[0] == this._rgftc[0] && ss._rgftc[1] == this._rgftc[1] && ss._rgftc[2] == this._rgftc[2] && ss._stshiLength == this._stshiLength && ss._stylenameVersion == this._stylenameVersion && ss._styleDescriptions.length == this._styleDescriptions.length) {
            int x = 0;
            while (x < this._styleDescriptions.length) {
                if (ss._styleDescriptions[x] != this._styleDescriptions[x] && !ss._styleDescriptions[x].equals(this._styleDescriptions[x])) {
                    return false;
                }
                ++x;
            }
            return true;
        }
        return false;
    }

    private void createPap(int istd) {
        StyleDescription sd = this._styleDescriptions[istd];
        ParagraphProperties pap = sd.getPAP();
        byte[] papx = sd.getPAPX();
        int baseIndex = sd.getBaseStyle();
        if (pap == null && papx != null) {
            ParagraphProperties parentPAP = new ParagraphProperties();
            if (baseIndex != 4095 && (parentPAP = this._styleDescriptions[baseIndex].getPAP()) == null) {
                if (baseIndex == istd) {
                    throw new IllegalStateException("Pap style " + istd + " claimed to have itself as its parent, which isn't allowed");
                }
                this.createPap(baseIndex);
                parentPAP = this._styleDescriptions[baseIndex].getPAP();
            }
            pap = ParagraphSprmUncompressor.uncompressPAP(parentPAP, papx, 2);
            sd.setPAP(pap);
        }
    }

    private void createChp(int istd) {
        StyleDescription sd = this._styleDescriptions[istd];
        CharacterProperties chp = sd.getCHP();
        byte[] chpx = sd.getCHPX();
        int baseIndex = sd.getBaseStyle();
        if (baseIndex == istd) {
            baseIndex = 4095;
        }
        if (chp == null && chpx != null) {
            CharacterProperties parentCHP = new CharacterProperties();
            if (baseIndex != 4095 && (parentCHP = this._styleDescriptions[baseIndex].getCHP()) == null) {
                this.createChp(baseIndex);
                parentCHP = this._styleDescriptions[baseIndex].getCHP();
            }
            chp = CharacterSprmUncompressor.uncompressCHP(parentCHP, chpx, 0);
            sd.setCHP(chp);
        }
    }

    public int numStyles() {
        return this._styleDescriptions.length;
    }

    public StyleDescription getStyleDescription(int x) {
        return this._styleDescriptions[x];
    }

    public CharacterProperties getCharacterStyle(int x) {
        if (x == 4095) {
            return NIL_CHP;
        }
        return this._styleDescriptions[x] != null ? this._styleDescriptions[x].getCHP() : null;
    }

    public ParagraphProperties getParagraphStyle(int x) {
        if (x == 4095) {
            return NIL_PAP;
        }
        return this._styleDescriptions[x] != null ? this._styleDescriptions[x].getPAP() : null;
    }
}

