/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public final class RevisionMarkAuthorTable {
    private short fExtend = (short)-1;
    private short cData = 0;
    private short cbExtra = 0;
    private String[] entries;

    public RevisionMarkAuthorTable(byte[] tableStream, int offset, int size) throws IOException {
        this.fExtend = LittleEndian.getShort((byte[])tableStream, (int)offset);
        this.cData = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        this.cbExtra = LittleEndian.getShort((byte[])tableStream, (int)(offset += 2));
        offset += 2;
        this.entries = new String[this.cData];
        int i = 0;
        while (i < this.cData) {
            short len = LittleEndian.getShort((byte[])tableStream, (int)offset);
            String name = StringUtil.getFromUnicodeLE((byte[])tableStream, (int)(offset += 2), (int)len);
            offset += len * 2;
            this.entries[i] = name;
            ++i;
        }
    }

    public List getEntries() {
        return Collections.unmodifiableList(Arrays.asList(this.entries));
    }

    public String getAuthor(int index) {
        String auth = null;
        if (index >= 0 && index < this.entries.length) {
            auth = this.entries[index];
        }
        return auth;
    }

    public int getSize() {
        return this.cData;
    }

    public void writeTo(HWPFOutputStream tableStream) throws IOException {
        byte[] header = new byte[6];
        LittleEndian.putShort((byte[])header, (int)0, (short)this.fExtend);
        LittleEndian.putShort((byte[])header, (int)2, (short)this.cData);
        LittleEndian.putShort((byte[])header, (int)4, (short)this.cbExtra);
        tableStream.write(header);
        int i = 0;
        while (i < this.entries.length) {
            String name = this.entries[i];
            byte[] buf = new byte[name.length() * 2 + 2];
            LittleEndian.putShort((byte[])buf, (int)0, (short)((short)name.length()));
            StringUtil.putUnicodeLE((String)name, (byte[])buf, (int)2);
            tableStream.write(buf);
            ++i;
        }
    }
}

