/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.poi.hwpf.model.SavedByEntry;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.StringUtil;

public final class SavedByTable {
    private short unknownValue = (short)-1;
    private SavedByEntry[] entries;

    public SavedByTable(byte[] tableStream, int offset, int size) {
        this.unknownValue = LittleEndian.getShort((byte[])tableStream, (int)offset);
        int numEntries = LittleEndian.getInt((byte[])tableStream, (int)(offset += 2)) / 2;
        offset += 4;
        this.entries = new SavedByEntry[numEntries];
        int i = 0;
        while (i < numEntries) {
            short len = LittleEndian.getShort((byte[])tableStream, (int)offset);
            String userName = StringUtil.getFromUnicodeLE((byte[])tableStream, (int)(offset += 2), (int)len);
            offset += len * 2;
            len = LittleEndian.getShort((byte[])tableStream, (int)offset);
            String saveLocation = StringUtil.getFromUnicodeLE((byte[])tableStream, (int)(offset += 2), (int)len);
            offset += len * 2;
            this.entries[i] = new SavedByEntry(userName, saveLocation);
            ++i;
        }
    }

    public List getEntries() {
        return Collections.unmodifiableList(Arrays.asList(this.entries));
    }

    public void writeTo(HWPFOutputStream tableStream) throws IOException {
        byte[] header = new byte[6];
        LittleEndian.putShort((byte[])header, (int)0, (short)this.unknownValue);
        LittleEndian.putInt((byte[])header, (int)2, (int)(this.entries.length * 2));
        tableStream.write(header);
        int i = 0;
        while (i < this.entries.length) {
            this.writeStringValue(tableStream, this.entries[i].getUserName());
            this.writeStringValue(tableStream, this.entries[i].getSaveLocation());
            ++i;
        }
    }

    private void writeStringValue(HWPFOutputStream tableStream, String value) throws IOException {
        byte[] buf = new byte[value.length() * 2 + 2];
        LittleEndian.putShort((byte[])buf, (int)0, (short)((short)value.length()));
        StringUtil.putUnicodeLE((String)value, (byte[])buf, (int)2);
        tableStream.write(buf);
    }
}

