/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.extensions;

import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STHorizontalAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STVerticalAlignment;

public class XSSFCellAlignment {
    private CTCellAlignment cellAlignement;

    public XSSFCellAlignment(CTCellAlignment cellAlignment) {
        this.cellAlignement = cellAlignment;
    }

    public VerticalAlignment getVertical() {
        STVerticalAlignment.Enum align = this.cellAlignement.getVertical();
        if (align == null) {
            align = STVerticalAlignment.BOTTOM;
        }
        return VerticalAlignment.values()[align.intValue() - 1];
    }

    public void setVertical(VerticalAlignment align) {
        this.cellAlignement.setVertical(STVerticalAlignment.Enum.forInt((int)(align.getOrdinal() + 1)));
    }

    public HorizontalAlignment getHorizontal() {
        STHorizontalAlignment.Enum align = this.cellAlignement.getHorizontal();
        if (align == null) {
            align = STHorizontalAlignment.GENERAL;
        }
        return HorizontalAlignment.values()[align.intValue() - 1];
    }

    public void setHorizontal(HorizontalAlignment align) {
        this.cellAlignement.setHorizontal(STHorizontalAlignment.Enum.forInt((int)(align.getOrdinal() + 1)));
    }

    public long getIndent() {
        return this.cellAlignement.getIndent();
    }

    public void setIndent(long indent) {
        this.cellAlignement.setIndent(indent);
    }

    public long getTextRotation() {
        return this.cellAlignement.getTextRotation();
    }

    public void setTextRotation(long rotation) {
        this.cellAlignement.setTextRotation(rotation);
    }

    public boolean getWrapText() {
        return this.cellAlignement.getWrapText();
    }

    public void setWrapText(boolean wrapped) {
        this.cellAlignement.setWrapText(wrapped);
    }

    public CTCellAlignment getCTCellAlignment() {
        return this.cellAlignement;
    }
}

