/*
 * Decompiled with CFR 0.152.
 */
package poi.support;

import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class POIFormatterUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private POIFormatterUtil() {
    }

    public static StringBuffer format(StringBuffer s, String fmt, Object[] parts) {
        Pattern pat = Pattern.compile("%[\\-+ #0]?[0-9\\.]*[hljztL]*[diuoxXeEfFgGaAcspn]");
        Matcher matcher = pat.matcher(fmt);
        int pi = 0;
        int previousEnd = 0;
        block7: while (matcher.find()) {
            String dest;
            String src = matcher.group();
            s.append(fmt.substring(previousEnd, matcher.start()));
            char c = src.charAt(src.length() - 1);
            switch (c) {
                case 'd': {
                    StringBuffer dfmt = new StringBuffer();
                    int len = 0;
                    boolean hasLength = false;
                    if (src.charAt(1) == '0') {
                        hasLength = true;
                        len = Integer.parseInt(src.substring(2, src.length() - 1));
                        int i = 0;
                        while (i < len) {
                            dfmt.append('0');
                            ++i;
                        }
                    } else if (src.charAt(1) == 'd') {
                        dfmt.append('0');
                    } else {
                        hasLength = true;
                        len = Integer.parseInt(src.substring(1, src.length() - 1));
                        int i = 0;
                        while (i < len) {
                            dfmt.append(' ');
                            ++i;
                        }
                        dfmt.append('0');
                    }
                    DecimalFormat df = new DecimalFormat(dfmt.toString());
                    dest = df.format((Long)parts[pi]);
                    String dest2 = String.valueOf((Long)parts[pi]);
                    if (hasLength && dest2.length() < len) {
                        dest = dest.substring(dest.length() - len);
                        break;
                    }
                    dest = dest2;
                    break;
                }
                case 'E': 
                case 'e': {
                    int len;
                    DecimalFormat df;
                    int dotIndex = src.indexOf(46);
                    if (dotIndex < 0) {
                        DecimalFormat df2 = new DecimalFormat("0.000000E00");
                        dest = df2.format((Double)parts[pi]);
                    } else {
                        StringBuffer dfmt = new StringBuffer("0.");
                        len = Integer.parseInt(src.substring(dotIndex + 1, src.length() - 1));
                        int i = 0;
                        while (i < len) {
                            dfmt.append('0');
                            ++i;
                        }
                        dfmt.append("E00");
                        df = new DecimalFormat(dfmt.toString());
                        dest = df.format((Double)parts[pi]);
                    }
                    int eIndex = dest.indexOf(69);
                    if (eIndex >= 0 && '-' != dest.charAt(eIndex + 1)) {
                        dest = String.valueOf(dest.substring(0, eIndex)) + c + "+" + dest.substring(eIndex + 1);
                    }
                    if (c != 'e') break;
                    dest = dest.replace('E', 'e');
                    break;
                }
                case 'f': {
                    int dotIndex = src.indexOf(46);
                    if (dotIndex < 0) {
                        DecimalFormat df = new DecimalFormat("0.000000");
                        dest = df.format((Double)parts[pi]);
                        break;
                    }
                    StringBuffer dfmt = new StringBuffer("0");
                    int len = Integer.parseInt(src.substring(dotIndex + 1, src.length() - 1));
                    if (len > 0) {
                        dfmt.append('.');
                    }
                    int i = 0;
                    while (i < len) {
                        dfmt.append('0');
                        ++i;
                    }
                    DecimalFormat df = new DecimalFormat(dfmt.toString());
                    dest = df.format((Double)parts[pi]);
                    break;
                }
                case 'x': {
                    StringBuffer dfmt = new StringBuffer();
                    int len = 0;
                    boolean hasLength = false;
                    if (src.charAt(1) == '0') {
                        hasLength = true;
                        len = Integer.parseInt(src.substring(2, src.length() - 1));
                        int i = 0;
                        while (i < len) {
                            dfmt.append('0');
                            ++i;
                        }
                    } else if (src.charAt(1) != 'x') {
                        hasLength = true;
                        len = Integer.parseInt(src.substring(1, src.length() - 1));
                        int i = 0;
                        while (i < len) {
                            dfmt.append(' ');
                            ++i;
                        }
                    }
                    String hex = Long.toHexString((Long)parts[pi]);
                    dest = String.valueOf(dfmt.toString()) + hex;
                    if (hasLength && hex.length() < len) {
                        dest = dest.substring(dest.length() - len);
                        break;
                    }
                    dest = hex;
                    break;
                }
                case 'n': {
                    s.append(LINE_SEPARATOR);
                    previousEnd = matcher.end();
                    continue block7;
                }
                default: {
                    throw new IllegalArgumentException("Not supported:" + src);
                }
            }
            s.append(dest);
            previousEnd = matcher.end();
            ++pi;
        }
        if (fmt.length() > previousEnd) {
            s.append(fmt.substring(previousEnd));
        }
        return s;
    }
}

