/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.record;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.poi.hslf.record.ExHyperlink;
import org.apache.poi.hslf.record.ExObjListAtom;
import org.apache.poi.hslf.record.Record;
import org.apache.poi.hslf.record.RecordContainer;
import org.apache.poi.util.LittleEndian;

public class ExObjList
extends RecordContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1033L;
    private ExObjListAtom exObjListAtom;

    public ExObjListAtom getExObjListAtom() {
        return this.exObjListAtom;
    }

    public ExHyperlink[] getExHyperlinks() {
        ArrayList<ExHyperlink> links = new ArrayList<ExHyperlink>();
        int i = 0;
        while (i < this._children.length) {
            if (this._children[i] instanceof ExHyperlink) {
                links.add((ExHyperlink)this._children[i]);
            }
            ++i;
        }
        return links.toArray(new ExHyperlink[links.size()]);
    }

    protected ExObjList(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        if (!(this._children[0] instanceof ExObjListAtom)) {
            throw new IllegalStateException("First child record wasn't a ExObjListAtom, was of type " + this._children[0].getRecordType());
        }
        this.exObjListAtom = (ExObjListAtom)this._children[0];
    }

    public ExObjList() {
        this._children = new Record[1];
        this._header[0] = 15;
        LittleEndian.putShort((byte[])this._header, (int)2, (short)((short)_type));
        this._children[0] = new ExObjListAtom();
        this.findInterestingChildren();
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream out) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, out);
    }

    public ExHyperlink get(int id) {
        int i = 0;
        while (i < this._children.length) {
            ExHyperlink rec;
            if (this._children[i] instanceof ExHyperlink && (rec = (ExHyperlink)this._children[i]).getExHyperlinkAtom().getNumber() == id) {
                return rec;
            }
            ++i;
        }
        return null;
    }
}

