/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.converter;

import java.util.Arrays;
import org.apache.poi.hssf.converter.AbstractExcelUtils;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelToHtmlUtils
extends AbstractExcelUtils {
    public static void appendAlign(StringBuffer style, short alignment) {
        String cssAlign = ExcelToHtmlUtils.getAlign(alignment);
        if (ExcelToHtmlUtils.isEmpty(cssAlign)) {
            return;
        }
        style.append("text-align:");
        style.append(cssAlign);
        style.append(";");
    }

    public static CellRangeAddress[][] buildMergedRangesMap(HSSFSheet sheet) {
        CellRangeAddress[][] mergedRanges = new CellRangeAddress[1][];
        int m = 0;
        while (m < sheet.getNumMergedRegions()) {
            CellRangeAddress cellRangeAddress = sheet.getMergedRegion(m);
            int requiredHeight = cellRangeAddress.getLastRow() + 1;
            if (mergedRanges.length < requiredHeight) {
                CellRangeAddress[][] newArray = new CellRangeAddress[requiredHeight][];
                System.arraycopy(mergedRanges, 0, newArray, 0, mergedRanges.length);
                mergedRanges = newArray;
            }
            int r = cellRangeAddress.getFirstRow();
            while (r <= cellRangeAddress.getLastRow()) {
                int requiredWidth = cellRangeAddress.getLastColumn() + 1;
                Object[] rowMerged = mergedRanges[r];
                if (rowMerged == null) {
                    rowMerged = new CellRangeAddress[requiredWidth];
                    mergedRanges[r] = rowMerged;
                } else {
                    int rowMergedLength = rowMerged.length;
                    if (rowMergedLength < requiredWidth) {
                        CellRangeAddress[] newRow = new CellRangeAddress[requiredWidth];
                        System.arraycopy(rowMerged, 0, newRow, 0, rowMergedLength);
                        mergedRanges[r] = newRow;
                        rowMerged = newRow;
                    }
                }
                Arrays.fill(rowMerged, cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastColumn() + 1, cellRangeAddress);
                ++r;
            }
            ++m;
        }
        return mergedRanges;
    }
}

