/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.File;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class POIFSDocumentPath {
    private static final POILogger log;
    private String[] components;
    private int hashcode = 0;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.poifs.filesystem.POIFSDocumentPath");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = POILogFactory.getLogger(clazz);
    }

    public POIFSDocumentPath(String[] components) throws IllegalArgumentException {
        if (components == null) {
            this.components = new String[0];
        } else {
            this.components = new String[components.length];
            int j = 0;
            while (j < components.length) {
                if (components[j] == null || components[j].length() == 0) {
                    throw new IllegalArgumentException("components cannot contain null or empty strings");
                }
                this.components[j] = components[j];
                ++j;
            }
        }
    }

    public POIFSDocumentPath() {
        this.components = new String[0];
    }

    public POIFSDocumentPath(POIFSDocumentPath path, String[] components) throws IllegalArgumentException {
        this.components = components == null ? new String[path.components.length] : new String[path.components.length + components.length];
        int j = 0;
        while (j < path.components.length) {
            this.components[j] = path.components[j];
            ++j;
        }
        if (components != null) {
            j = 0;
            while (j < components.length) {
                if (components[j] == null) {
                    throw new IllegalArgumentException("components cannot contain null");
                }
                if (components[j].length() == 0) {
                    log.log(POILogger.WARN, "Directory under " + path + " has an empty name, " + "not all OLE2 readers will handle this file correctly!");
                }
                this.components[j + path.components.length] = components[j];
                ++j;
            }
        }
    }

    public boolean equals(Object o) {
        boolean rval = false;
        if (o != null && o.getClass() == this.getClass()) {
            if (this == o) {
                rval = true;
            } else {
                POIFSDocumentPath path = (POIFSDocumentPath)o;
                if (path.components.length == this.components.length) {
                    rval = true;
                    int j = 0;
                    while (j < this.components.length) {
                        if (!path.components[j].equals(this.components[j])) {
                            rval = false;
                            break;
                        }
                        ++j;
                    }
                }
            }
        }
        return rval;
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            int j = 0;
            while (j < this.components.length) {
                this.hashcode += this.components[j].hashCode();
                ++j;
            }
        }
        return this.hashcode;
    }

    public int length() {
        return this.components.length;
    }

    public String getComponent(int n) throws ArrayIndexOutOfBoundsException {
        return this.components[n];
    }

    public POIFSDocumentPath getParent() {
        int length = this.components.length - 1;
        if (length < 0) {
            return null;
        }
        POIFSDocumentPath parent = new POIFSDocumentPath(null);
        parent.components = new String[length];
        System.arraycopy(this.components, 0, parent.components, 0, length);
        return parent;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        int l = this.length();
        b.append(File.separatorChar);
        int i = 0;
        while (i < l) {
            b.append(this.getComponent(i));
            if (i < l - 1) {
                b.append(File.separatorChar);
            }
            ++i;
        }
        return b.toString();
    }
}

