/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.poi.POIDocument;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherBitmapBlip;
import org.apache.poi.ddf.EscherBlipRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.hssf.model.DrawingManager2;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.model.InternalSheet;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.AbstractEscherHolderRecord;
import org.apache.poi.hssf.record.BackupRecord;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.RecalcIdRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordBase;
import org.apache.poi.hssf.record.RecordFactory;
import org.apache.poi.hssf.record.SubRecord;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.common.UnicodeString;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFCreationHelper;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFObjectData;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFPrintSetup;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.FormulaShifter;
import org.apache.poi.ss.formula.SheetNameFormatter;
import org.apache.poi.ss.formula.ptg.Area3DPtg;
import org.apache.poi.ss.formula.ptg.MemFuncPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.UnionPtg;
import org.apache.poi.ss.formula.udf.AggregatingUDFFinder;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public final class HSSFWorkbook
extends POIDocument
implements Workbook {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final int MAX_ROW = 65535;
    private static final short MAX_COLUMN = 255;
    private static final int MAX_STYLES = 4030;
    private static final int DEBUG = POILogger.DEBUG;
    public static final int INITIAL_CAPACITY = 3;
    private InternalWorkbook workbook;
    protected List _sheets;
    private ArrayList names;
    private Hashtable fonts;
    private boolean preserveNodes;
    private HSSFDataFormat formatter;
    private Row.MissingCellPolicy missingCellPolicy = HSSFRow.RETURN_NULL_AND_BLANK;
    private static POILogger log;
    private UDFFinder _udfFinder = UDFFinder.DEFAULT;
    private static final String[] WORKBOOK_DIR_ENTRY_NAMES;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hssf.usermodel.HSSFWorkbook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = POILogFactory.getLogger(clazz);
        WORKBOOK_DIR_ENTRY_NAMES = new String[]{"Workbook", "WORKBOOK"};
    }

    public static HSSFWorkbook create(InternalWorkbook book) {
        return new HSSFWorkbook(book);
    }

    public HSSFWorkbook() {
        this(InternalWorkbook.createWorkbook());
    }

    private HSSFWorkbook(InternalWorkbook book) {
        super((DirectoryNode)null);
        this.workbook = book;
        this._sheets = new ArrayList(3);
        this.names = new ArrayList(3);
    }

    public HSSFWorkbook(POIFSFileSystem fs) throws IOException {
        this(fs, true);
    }

    public HSSFWorkbook(POIFSFileSystem fs, boolean preserveNodes) throws IOException {
        this(fs.getRoot(), fs, preserveNodes);
    }

    private static String getWorkbookDirEntryName(DirectoryNode directory) {
        String[] potentialNames = WORKBOOK_DIR_ENTRY_NAMES;
        int i = 0;
        while (i < potentialNames.length) {
            String wbName = potentialNames[i];
            try {
                directory.getEntry(wbName);
                return wbName;
            }
            catch (FileNotFoundException fileNotFoundException) {
                ++i;
            }
        }
        try {
            directory.getEntry("Book");
            throw new OldExcelFormatException("The supplied spreadsheet seems to be Excel 5.0/7.0 (BIFF5) format. POI only supports BIFF8 format (from Excel versions 97/2000/XP/2003)");
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IllegalArgumentException("The supplied POIFSFileSystem does not contain a BIFF8 'Workbook' entry. Is it really an excel file?");
        }
    }

    public HSSFWorkbook(DirectoryNode directory, POIFSFileSystem fs, boolean preserveNodes) throws IOException {
        this(directory, preserveNodes);
    }

    public HSSFWorkbook(DirectoryNode directory, boolean preserveNodes) throws IOException {
        super(directory);
        String workbookName = HSSFWorkbook.getWorkbookDirEntryName(directory);
        this.preserveNodes = preserveNodes;
        if (!preserveNodes) {
            this.directory = null;
        }
        this._sheets = new ArrayList(3);
        this.names = new ArrayList(3);
        DocumentInputStream stream = directory.createDocumentInputStream(workbookName);
        List records = RecordFactory.createRecords(stream);
        this.workbook = InternalWorkbook.createWorkbook(records);
        this.setPropertiesFromWorkbook(this.workbook);
        int recOffset = this.workbook.getNumRecords();
        boolean sheetNum = false;
        this.convertLabelRecords(records, recOffset);
        RecordStream rs = new RecordStream(records, recOffset);
        while (rs.hasNext()) {
            InternalSheet sheet = InternalSheet.createSheet(rs);
            this._sheets.add(new HSSFSheet(this, sheet));
        }
        int i = 0;
        while (i < this.workbook.getNumNames()) {
            NameRecord nameRecord = this.workbook.getNameRecord(i);
            HSSFName name = new HSSFName(this, nameRecord, this.workbook.getNameCommentRecord(nameRecord));
            this.names.add(name);
            ++i;
        }
    }

    public HSSFWorkbook(InputStream s) throws IOException {
        this(s, true);
    }

    public HSSFWorkbook(InputStream s, boolean preserveNodes) throws IOException {
        this(new POIFSFileSystem(s), preserveNodes);
    }

    private void setPropertiesFromWorkbook(InternalWorkbook book) {
        this.workbook = book;
    }

    private void convertLabelRecords(List records, int offset) {
        if (log.check(POILogger.DEBUG)) {
            log.log(POILogger.DEBUG, "convertLabelRecords called");
        }
        int k = offset;
        while (k < records.size()) {
            Record rec = (Record)records.get(k);
            if (rec.getSid() == 516) {
                LabelRecord oldrec = (LabelRecord)rec;
                records.remove(k);
                LabelSSTRecord newrec = new LabelSSTRecord();
                int stringid = this.workbook.addSSTString(new UnicodeString(oldrec.getValue()));
                newrec.setRow(oldrec.getRow());
                newrec.setColumn(oldrec.getColumn());
                newrec.setXFIndex(oldrec.getXFIndex());
                newrec.setSSTIndex(stringid);
                records.add(k, newrec);
            }
            ++k;
        }
        if (log.check(POILogger.DEBUG)) {
            log.log(POILogger.DEBUG, "convertLabelRecords exit");
        }
    }

    public Row.MissingCellPolicy getMissingCellPolicy() {
        return this.missingCellPolicy;
    }

    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        this.missingCellPolicy = missingCellPolicy;
    }

    public void setSheetOrder(String sheetname, int pos) {
        int oldSheetIndex = this.getSheetIndex(sheetname);
        this._sheets.add(pos, this._sheets.remove(oldSheetIndex));
        this.workbook.setSheetOrder(sheetname, pos);
        FormulaShifter shifter = FormulaShifter.createForSheetShift(oldSheetIndex, pos);
        Iterator iterator = this._sheets.iterator();
        while (iterator.hasNext()) {
            HSSFSheet sheet = (HSSFSheet)iterator.next();
            sheet.getSheet().updateFormulasAfterCellShift(shifter, -1);
        }
        this.workbook.updateNamesAfterCellShift(shifter);
    }

    private void validateSheetIndex(int index) {
        int lastSheetIx = this._sheets.size() - 1;
        if (index < 0 || index > lastSheetIx) {
            throw new IllegalArgumentException("Sheet index (" + index + ") is out of range (0.." + lastSheetIx + ")");
        }
    }

    public void setSelectedTab(int index) {
        this.validateSheetIndex(index);
        int nSheets = this._sheets.size();
        int i = 0;
        while (i < nSheets) {
            this.getSheetAt(i).setSelected(i == index);
            ++i;
        }
        this.workbook.getWindowOne().setNumSelectedTabs((short)1);
    }

    public void setSelectedTab(short index) {
        this.setSelectedTab((int)index);
    }

    public void setSelectedTabs(int[] indexes) {
        int i = 0;
        while (i < indexes.length) {
            this.validateSheetIndex(indexes[i]);
            ++i;
        }
        int nSheets = this._sheets.size();
        int i2 = 0;
        while (i2 < nSheets) {
            boolean bSelect = false;
            int j = 0;
            while (j < indexes.length) {
                if (indexes[j] == i2) {
                    bSelect = true;
                    break;
                }
                ++j;
            }
            this.getSheetAt(i2).setSelected(bSelect);
            ++i2;
        }
        this.workbook.getWindowOne().setNumSelectedTabs((short)indexes.length);
    }

    public void setActiveSheet(int index) {
        this.validateSheetIndex(index);
        int nSheets = this._sheets.size();
        int i = 0;
        while (i < nSheets) {
            ((HSSFSheet)this.getSheetAt(i)).setActive(i == index);
            ++i;
        }
        this.workbook.getWindowOne().setActiveSheetIndex(index);
    }

    public int getActiveSheetIndex() {
        return this.workbook.getWindowOne().getActiveSheetIndex();
    }

    public short getSelectedTab() {
        return (short)this.getActiveSheetIndex();
    }

    public void setFirstVisibleTab(int index) {
        this.workbook.getWindowOne().setFirstVisibleTab(index);
    }

    public void setDisplayedTab(short index) {
        this.setFirstVisibleTab(index);
    }

    public int getFirstVisibleTab() {
        return this.workbook.getWindowOne().getFirstVisibleTab();
    }

    public short getDisplayedTab() {
        return (short)this.getFirstVisibleTab();
    }

    public void setSheetName(int sheetIx, String name) {
        if (name == null) {
            throw new IllegalArgumentException("sheetName must not be null");
        }
        if (this.workbook.doesContainsSheetName(name, sheetIx)) {
            throw new IllegalArgumentException("The workbook already contains a sheet with this name");
        }
        this.validateSheetIndex(sheetIx);
        this.workbook.setSheetName(sheetIx, name);
    }

    public String getSheetName(int sheetIndex) {
        this.validateSheetIndex(sheetIndex);
        return this.workbook.getSheetName(sheetIndex);
    }

    public boolean isHidden() {
        return this.workbook.getWindowOne().getHidden();
    }

    public void setHidden(boolean hiddenFlag) {
        this.workbook.getWindowOne().setHidden(hiddenFlag);
    }

    public boolean isSheetHidden(int sheetIx) {
        this.validateSheetIndex(sheetIx);
        return this.workbook.isSheetHidden(sheetIx);
    }

    public boolean isSheetVeryHidden(int sheetIx) {
        this.validateSheetIndex(sheetIx);
        return this.workbook.isSheetVeryHidden(sheetIx);
    }

    public void setSheetHidden(int sheetIx, boolean hidden) {
        this.validateSheetIndex(sheetIx);
        this.workbook.setSheetHidden(sheetIx, hidden);
    }

    public void setSheetHidden(int sheetIx, int hidden) {
        this.validateSheetIndex(sheetIx);
        WorkbookUtil.validateSheetState(hidden);
        this.workbook.setSheetHidden(sheetIx, hidden);
    }

    public int getSheetIndex(String name) {
        return this.workbook.getSheetIndex(name);
    }

    public int getSheetIndex(Sheet sheet) {
        int i = 0;
        while (i < this._sheets.size()) {
            if (this._sheets.get(i) == sheet) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getExternalSheetIndex(int internalSheetIndex) {
        return this.workbook.checkExternSheet(internalSheetIndex);
    }

    public String findSheetNameFromExternSheet(int externSheetIndex) {
        return this.workbook.findSheetNameFromExternSheet(externSheetIndex);
    }

    public String resolveNameXText(int refIndex, int definedNameIndex) {
        return this.workbook.resolveNameXText(refIndex, definedNameIndex);
    }

    public Sheet createSheet() {
        HSSFSheet sheet = new HSSFSheet(this);
        this._sheets.add(sheet);
        this.workbook.setSheetName(this._sheets.size() - 1, "Sheet" + (this._sheets.size() - 1));
        boolean isOnlySheet = this._sheets.size() == 1;
        sheet.setSelected(isOnlySheet);
        sheet.setActive(isOnlySheet);
        return sheet;
    }

    public Sheet cloneSheet(int sheetIndex) {
        this.validateSheetIndex(sheetIndex);
        HSSFSheet srcSheet = (HSSFSheet)this._sheets.get(sheetIndex);
        String srcName = this.workbook.getSheetName(sheetIndex);
        HSSFSheet clonedSheet = srcSheet.cloneSheet(this);
        clonedSheet.setSelected(false);
        clonedSheet.setActive(false);
        String name = this.getUniqueSheetName(srcName);
        int newSheetIndex = this._sheets.size();
        this._sheets.add(clonedSheet);
        this.workbook.setSheetName(newSheetIndex, name);
        int filterDbNameIndex = this.findExistingBuiltinNameRecordIdx(sheetIndex, (byte)13);
        if (filterDbNameIndex != -1) {
            NameRecord newNameRecord = this.workbook.cloneFilter(filterDbNameIndex, newSheetIndex);
            HSSFName newName = new HSSFName(this, newNameRecord);
            this.names.add(newName);
        }
        this.workbook.cloneDrawings(clonedSheet.getSheet());
        return clonedSheet;
    }

    private String getUniqueSheetName(String srcName) {
        String index;
        String name;
        int uniqueIndex = 2;
        String baseName = srcName;
        int bracketPos = srcName.lastIndexOf(40);
        if (bracketPos > 0 && srcName.endsWith(")")) {
            String suffix = srcName.substring(bracketPos + 1, srcName.length() - ")".length());
            try {
                uniqueIndex = Integer.parseInt(suffix.trim());
                baseName = srcName.substring(0, bracketPos).trim();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        do {
            int n = ++uniqueIndex;
            ++uniqueIndex;
            index = Integer.toString(n);
        } while (this.workbook.getSheetIndex(name = baseName.length() + index.length() + 2 < 31 ? String.valueOf(baseName) + " (" + index + ")" : String.valueOf(baseName.substring(0, 31 - index.length() - 2)) + "(" + index + ")") != -1);
        return name;
    }

    public Sheet createSheet(String sheetname) {
        if (sheetname == null) {
            throw new IllegalArgumentException("sheetName must not be null");
        }
        if (this.workbook.doesContainsSheetName(sheetname, this._sheets.size())) {
            throw new IllegalArgumentException("The workbook already contains a sheet of this name");
        }
        HSSFSheet sheet = new HSSFSheet(this);
        this.workbook.setSheetName(this._sheets.size(), sheetname);
        this._sheets.add(sheet);
        boolean isOnlySheet = this._sheets.size() == 1;
        sheet.setSelected(isOnlySheet);
        sheet.setActive(isOnlySheet);
        return sheet;
    }

    public int getNumberOfSheets() {
        return this._sheets.size();
    }

    public int getSheetIndexFromExternSheetIndex(int externSheetNumber) {
        return this.workbook.getSheetIndexFromExternSheetIndex(externSheetNumber);
    }

    private HSSFSheet[] getSheets() {
        HSSFSheet[] result = new HSSFSheet[this._sheets.size()];
        this._sheets.toArray(result);
        return result;
    }

    public Sheet getSheetAt(int index) {
        this.validateSheetIndex(index);
        return (HSSFSheet)this._sheets.get(index);
    }

    public Sheet getSheet(String name) {
        HSSFSheet retval = null;
        int k = 0;
        while (k < this._sheets.size()) {
            String sheetname = this.workbook.getSheetName(k);
            if (sheetname.equalsIgnoreCase(name)) {
                retval = (HSSFSheet)this._sheets.get(k);
            }
            ++k;
        }
        return retval;
    }

    public void removeSheetAt(int index) {
        this.validateSheetIndex(index);
        boolean wasActive = ((HSSFSheet)this.getSheetAt(index)).isActive();
        boolean wasSelected = this.getSheetAt(index).isSelected();
        this._sheets.remove(index);
        this.workbook.removeSheet(index);
        int nSheets = this._sheets.size();
        if (nSheets < 1) {
            return;
        }
        int newSheetIndex = index;
        if (newSheetIndex >= nSheets) {
            newSheetIndex = nSheets - 1;
        }
        if (wasActive) {
            this.setActiveSheet(newSheetIndex);
        }
        if (wasSelected) {
            boolean someOtherSheetIsStillSelected = false;
            int i = 0;
            while (i < nSheets) {
                if (this.getSheetAt(i).isSelected()) {
                    someOtherSheetIsStillSelected = true;
                    break;
                }
                ++i;
            }
            if (!someOtherSheetIsStillSelected) {
                this.setSelectedTab(newSheetIndex);
            }
        }
    }

    public void setBackupFlag(boolean backupValue) {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        backupRecord.setBackup(backupValue ? (short)1 : 0);
    }

    public boolean getBackupFlag() {
        BackupRecord backupRecord = this.workbook.getBackupRecord();
        return backupRecord.getBackup() != 0;
    }

    public void setRepeatingRowsAndColumns(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        boolean isNewRecord;
        NameRecord nameRecord;
        if (startColumn == -1 && endColumn != -1) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (startRow == -1 && endRow != -1) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (startColumn < -1 || startColumn >= 255) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (endColumn < -1 || endColumn >= 255) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (startRow < -1 || startRow > 65535) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (endRow < -1 || endRow > 65535) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        if (startColumn > endColumn) {
            throw new IllegalArgumentException("Invalid column range specification");
        }
        if (startRow > endRow) {
            throw new IllegalArgumentException("Invalid row range specification");
        }
        HSSFSheet sheet = (HSSFSheet)this.getSheetAt(sheetIndex);
        short externSheetIndex = this.getWorkbook().checkExternSheet(sheetIndex);
        boolean settingRowAndColumn = startColumn != -1 && endColumn != -1 && startRow != -1 && endRow != -1;
        boolean removingRange = startColumn == -1 && endColumn == -1 && startRow == -1 && endRow == -1;
        int rowColHeaderNameIndex = this.findExistingBuiltinNameRecordIdx(sheetIndex, (byte)7);
        if (removingRange) {
            if (rowColHeaderNameIndex >= 0) {
                this.workbook.removeName(rowColHeaderNameIndex);
            }
            return;
        }
        if (rowColHeaderNameIndex < 0) {
            nameRecord = this.workbook.createBuiltInName((byte)7, sheetIndex + 1);
            isNewRecord = true;
        } else {
            nameRecord = this.workbook.getNameRecord(rowColHeaderNameIndex);
            isNewRecord = false;
        }
        ArrayList<Ptg> temp = new ArrayList<Ptg>();
        if (settingRowAndColumn) {
            int exprsSize = 23;
            temp.add(new MemFuncPtg(23));
        }
        if (startColumn >= 0) {
            Area3DPtg colArea = new Area3DPtg(0, 65535, startColumn, endColumn, false, false, false, false, externSheetIndex);
            temp.add(colArea);
        }
        if (startRow >= 0) {
            Area3DPtg rowArea = new Area3DPtg(startRow, endRow, 0, 255, false, false, false, false, externSheetIndex);
            temp.add(rowArea);
        }
        if (settingRowAndColumn) {
            temp.add(UnionPtg.instance);
        }
        Ptg[] ptgs = new Ptg[temp.size()];
        temp.toArray(ptgs);
        nameRecord.setNameDefinition(ptgs);
        if (isNewRecord) {
            HSSFName newName = new HSSFName(this, nameRecord, nameRecord.isBuiltInName() ? null : this.workbook.getNameCommentRecord(nameRecord));
            this.names.add(newName);
        }
        HSSFPrintSetup printSetup = (HSSFPrintSetup)sheet.getPrintSetup();
        printSetup.setValidSettings(false);
        sheet.setActive(true);
    }

    private int findExistingBuiltinNameRecordIdx(int sheetIndex, byte builtinCode) {
        int defNameIndex = 0;
        while (defNameIndex < this.names.size()) {
            NameRecord r = this.workbook.getNameRecord(defNameIndex);
            if (r == null) {
                throw new RuntimeException("Unable to find all defined names to iterate over");
            }
            if (r.isBuiltInName() && r.getBuiltInName() == builtinCode && r.getSheetNumber() - 1 == sheetIndex) {
                return defNameIndex;
            }
            ++defNameIndex;
        }
        return -1;
    }

    public Font createFont() {
        FontRecord font = this.workbook.createNewFont();
        short fontindex = (short)(this.getNumberOfFonts() - 1);
        if (fontindex > 3) {
            fontindex = (short)(fontindex + 1);
        }
        if (fontindex == Short.MAX_VALUE) {
            throw new IllegalArgumentException("Maximum number of fonts was exceeded");
        }
        return this.getFontAt(fontindex);
    }

    public Font findFont(short boldWeight, short color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        short i = 0;
        while (i <= this.getNumberOfFonts()) {
            HSSFFont hssfFont;
            if (i != 4 && (hssfFont = (HSSFFont)this.getFontAt(i)).getBoldweight() == boldWeight && hssfFont.getColor() == color && hssfFont.getFontHeight() == fontHeight && hssfFont.getFontName().equals(name) && hssfFont.getItalic() == italic && hssfFont.getStrikeout() == strikeout && hssfFont.getTypeOffset() == typeOffset && hssfFont.getUnderline() == underline) {
                return hssfFont;
            }
            i = (short)(i + 1);
        }
        return null;
    }

    public short getNumberOfFonts() {
        return (short)this.workbook.getNumberOfFontRecords();
    }

    public Font getFontAt(short idx) {
        Short sIdx;
        if (this.fonts == null) {
            this.fonts = new Hashtable();
        }
        if (this.fonts.containsKey(sIdx = new Short(idx))) {
            return (HSSFFont)this.fonts.get(sIdx);
        }
        FontRecord font = this.workbook.getFontRecordAt(idx);
        HSSFFont retval = new HSSFFont(idx, font);
        this.fonts.put(sIdx, retval);
        return retval;
    }

    protected void resetFontCache() {
        this.fonts = new Hashtable();
    }

    public CellStyle createCellStyle() {
        if (this.workbook.getNumExFormats() == 4030) {
            throw new IllegalStateException("The maximum number of cell styles was exceeded. You can define up to 4000 styles in a .xls workbook");
        }
        ExtendedFormatRecord xfr = this.workbook.createCellXF();
        short index = (short)(this.getNumCellStyles() - 1);
        HSSFCellStyle style = new HSSFCellStyle(index, xfr, this);
        return style;
    }

    public short getNumCellStyles() {
        return (short)this.workbook.getNumExFormats();
    }

    public CellStyle getCellStyleAt(short idx) {
        ExtendedFormatRecord xfr = this.workbook.getExFormatAt(idx);
        HSSFCellStyle style = new HSSFCellStyle(idx, xfr, this);
        return style;
    }

    public void write(OutputStream stream) throws IOException {
        byte[] bytes = this.getBytes();
        POIFSFileSystem fs = new POIFSFileSystem();
        ArrayList<String> excepts = new ArrayList<String>(1);
        fs.createDocument(new ByteArrayInputStream(bytes), "Workbook");
        this.writeProperties(fs, excepts);
        if (this.preserveNodes) {
            excepts.add("Workbook");
            excepts.add("WORKBOOK");
            this.copyNodes(this.directory, fs.getRoot(), excepts);
            fs.getRoot().setStorageClsid(this.directory.getStorageClsid());
        }
        fs.writeFilesystem(stream);
    }

    public byte[] getBytes() {
        if (log.check(POILogger.DEBUG)) {
            log.log(DEBUG, "HSSFWorkbook.getBytes()");
        }
        HSSFSheet[] sheets = this.getSheets();
        int nSheets = sheets.length;
        int i = 0;
        while (i < nSheets) {
            sheets[i].getSheet().preSerialize();
            ++i;
        }
        int totalsize = this.workbook.getSize();
        SheetRecordCollector[] srCollectors = new SheetRecordCollector[nSheets];
        int k = 0;
        while (k < nSheets) {
            this.workbook.setSheetBof(k, totalsize);
            SheetRecordCollector src = new SheetRecordCollector();
            sheets[k].getSheet().visitContainedRecords(src, totalsize);
            totalsize += src.getTotalSize();
            srCollectors[k] = src;
            ++k;
        }
        byte[] retval = new byte[totalsize];
        int pos = this.workbook.serialize(0, retval);
        int k2 = 0;
        while (k2 < nSheets) {
            SheetRecordCollector src = srCollectors[k2];
            int serializedSize = src.serialize(pos, retval);
            if (serializedSize != src.getTotalSize()) {
                throw new IllegalStateException("Actual serialized sheet size (" + serializedSize + ") differs from pre-calculated size (" + src.getTotalSize() + ") for sheet (" + k2 + ")");
            }
            pos += serializedSize;
            ++k2;
        }
        return retval;
    }

    public int addSSTString(String string) {
        return this.workbook.addSSTString(new UnicodeString(string));
    }

    public String getSSTString(int index) {
        return this.workbook.getSSTString(index).getString();
    }

    InternalWorkbook getWorkbook() {
        return this.workbook;
    }

    public int getNumberOfNames() {
        int result = this.names.size();
        return result;
    }

    public Name getName(String name) {
        int nameIndex = this.getNameIndex(name);
        if (nameIndex < 0) {
            return null;
        }
        return (HSSFName)this.names.get(nameIndex);
    }

    public Name getNameAt(int nameIndex) {
        int nNames = this.names.size();
        if (nNames < 1) {
            throw new IllegalStateException("There are no defined names in this workbook");
        }
        if (nameIndex < 0 || nameIndex > nNames) {
            throw new IllegalArgumentException("Specified name index " + nameIndex + " is outside the allowable range (0.." + (nNames - 1) + ").");
        }
        return (HSSFName)this.names.get(nameIndex);
    }

    public NameRecord getNameRecord(int nameIndex) {
        return this.getWorkbook().getNameRecord(nameIndex);
    }

    public String getNameName(int index) {
        String result = this.getNameAt(index).getNameName();
        return result;
    }

    public void setPrintArea(int sheetIndex, String reference) {
        NameRecord name = this.workbook.getSpecificBuiltinRecord((byte)6, sheetIndex + 1);
        if (name == null) {
            name = this.workbook.createBuiltInName((byte)6, sheetIndex + 1);
        }
        String[] parts = COMMA_PATTERN.split(reference);
        StringBuffer sb = new StringBuffer(32);
        int i = 0;
        while (i < parts.length) {
            if (i > 0) {
                sb.append(",");
            }
            SheetNameFormatter.appendFormat(sb, this.getSheetName(sheetIndex));
            sb.append("!");
            sb.append(parts[i]);
            ++i;
        }
        name.setNameDefinition(HSSFFormulaParser.parse(sb.toString(), this, 4, sheetIndex));
    }

    public void setPrintArea(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        CellReference cell = new CellReference(startRow, startColumn, true, true);
        String reference = cell.formatAsString();
        cell = new CellReference(endRow, endColumn, true, true);
        reference = String.valueOf(reference) + ":" + cell.formatAsString();
        this.setPrintArea(sheetIndex, reference);
    }

    public String getPrintArea(int sheetIndex) {
        NameRecord name = this.workbook.getSpecificBuiltinRecord((byte)6, sheetIndex + 1);
        if (name == null) {
            return null;
        }
        return HSSFFormulaParser.toFormulaString(this, name.getNameDefinition());
    }

    public void removePrintArea(int sheetIndex) {
        this.getWorkbook().removeBuiltinRecord((byte)6, sheetIndex + 1);
    }

    public Name createName() {
        NameRecord nameRecord = this.workbook.createName();
        HSSFName newName = new HSSFName(this, nameRecord);
        this.names.add(newName);
        return newName;
    }

    public int getNameIndex(String name) {
        int k = 0;
        while (k < this.names.size()) {
            String nameName = this.getNameName(k);
            if (nameName.equalsIgnoreCase(name)) {
                return k;
            }
            ++k;
        }
        return -1;
    }

    public void removeName(int index) {
        this.names.remove(index);
        this.workbook.removeName(index);
    }

    public DataFormat createDataFormat() {
        if (this.formatter == null) {
            this.formatter = new HSSFDataFormat(this.workbook);
        }
        return this.formatter;
    }

    public void removeName(String name) {
        int index = this.getNameIndex(name);
        this.removeName(index);
    }

    public HSSFPalette getCustomPalette() {
        return new HSSFPalette(this.workbook.getCustomPalette());
    }

    public void insertChartRecord() {
        int loc = this.workbook.findFirstRecordLocBySid((short)252);
        byte[] byArray = new byte[90];
        byArray[0] = 15;
        byArray[3] = -16;
        byArray[4] = 82;
        byArray[10] = 6;
        byArray[11] = -16;
        byArray[12] = 24;
        byArray[16] = 1;
        byArray[17] = 8;
        byArray[20] = 2;
        byArray[24] = 2;
        byArray[28] = 1;
        byArray[32] = 1;
        byArray[36] = 3;
        byArray[40] = 51;
        byArray[42] = 11;
        byArray[43] = -16;
        byArray[44] = 18;
        byArray[48] = -65;
        byArray[50] = 8;
        byArray[52] = 8;
        byArray[54] = -127;
        byArray[55] = 1;
        byArray[56] = 9;
        byArray[59] = 8;
        byArray[60] = -64;
        byArray[61] = 1;
        byArray[62] = 64;
        byArray[65] = 8;
        byArray[66] = 64;
        byArray[68] = 30;
        byArray[69] = -15;
        byArray[70] = 16;
        byArray[74] = 13;
        byArray[77] = 8;
        byArray[78] = 12;
        byArray[81] = 8;
        byArray[82] = 23;
        byArray[85] = 8;
        byArray[86] = -9;
        byArray[89] = 16;
        byte[] data = byArray;
        UnknownRecord r = new UnknownRecord(235, data);
        this.workbook.getRecords().add(loc, r);
    }

    public void dumpDrawingGroupRecords(boolean fat) {
        DrawingGroupRecord r = (DrawingGroupRecord)this.workbook.findFirstRecordBySid((short)235);
        r.decode();
        List escherRecords = r.getEscherRecords();
        PrintWriter w = new PrintWriter(System.out);
        Iterator iterator = escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (fat) {
                System.out.println(escherRecord.toString());
                continue;
            }
            escherRecord.display(w, 0);
        }
        w.flush();
    }

    void initDrawings() {
        DrawingManager2 mgr = this.workbook.findDrawingGroup();
        if (mgr != null) {
            int i = 0;
            while (i < this.getNumberOfSheets()) {
                ((HSSFSheet)this.getSheetAt(i)).getDrawingPatriarch();
                ++i;
            }
        } else {
            this.workbook.createDrawingGroup();
        }
    }

    public int addPicture(byte[] pictureData, int format) {
        this.initDrawings();
        byte[] uid = DigestUtils.md5((byte[])pictureData);
        EscherBitmapBlip blipRecord = new EscherBitmapBlip();
        blipRecord.setRecordId((short)(-4072 + format));
        switch (format) {
            case 2: {
                blipRecord.setOptions((short)15680);
                break;
            }
            case 3: {
                blipRecord.setOptions((short)8544);
                break;
            }
            case 4: {
                blipRecord.setOptions((short)21536);
                break;
            }
            case 6: {
                blipRecord.setOptions((short)28160);
                break;
            }
            case 5: {
                blipRecord.setOptions((short)18080);
                break;
            }
            case 7: {
                blipRecord.setOptions((short)31360);
            }
        }
        blipRecord.setUID(uid);
        blipRecord.setMarker((byte)-1);
        blipRecord.setPictureData(pictureData);
        EscherBSERecord r = new EscherBSERecord();
        r.setRecordId((short)-4089);
        r.setOptions((short)(2 | format << 4));
        r.setBlipTypeMacOS((byte)format);
        r.setBlipTypeWin32((byte)format);
        r.setUid(uid);
        r.setTag((short)255);
        r.setSize(pictureData.length + 25);
        r.setRef(1);
        r.setOffset(0);
        r.setBlipRecord(blipRecord);
        return this.workbook.addBSERecord(r);
    }

    public List getAllPictures() {
        ArrayList pictures = new ArrayList();
        Iterator recordIter = this.workbook.getRecords().iterator();
        while (recordIter.hasNext()) {
            Record r = (Record)recordIter.next();
            if (!(r instanceof AbstractEscherHolderRecord)) continue;
            ((AbstractEscherHolderRecord)r).decode();
            List escherRecords = ((AbstractEscherHolderRecord)r).getEscherRecords();
            this.searchForPictures(escherRecords, pictures);
        }
        return pictures;
    }

    private void searchForPictures(List escherRecords, List pictures) {
        Iterator iterator = escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherBlipRecord blip;
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (escherRecord instanceof EscherBSERecord && (blip = ((EscherBSERecord)escherRecord).getBlipRecord()) != null) {
                HSSFPictureData picture = new HSSFPictureData(blip);
                pictures.add(picture);
            }
            this.searchForPictures(escherRecord.getChildRecords(), pictures);
        }
    }

    public boolean isWriteProtected() {
        return this.workbook.isWriteProtected();
    }

    public void writeProtectWorkbook(String password, String username) {
        this.workbook.writeProtectWorkbook(password, username);
    }

    public void unwriteProtectWorkbook() {
        this.workbook.unwriteProtectWorkbook();
    }

    public List getAllEmbeddedObjects() {
        ArrayList objects = new ArrayList();
        int i = 0;
        while (i < this.getNumberOfSheets()) {
            this.getAllEmbeddedObjects(((HSSFSheet)this.getSheetAt(i)).getSheet().getRecords(), objects);
            ++i;
        }
        return objects;
    }

    private void getAllEmbeddedObjects(List records, List objects) {
        Iterator iterator = records.iterator();
        while (iterator.hasNext()) {
            RecordBase obj = (RecordBase)iterator.next();
            if (!(obj instanceof ObjRecord)) continue;
            Iterator subRecordIter = ((ObjRecord)obj).getSubRecords().iterator();
            while (subRecordIter.hasNext()) {
                SubRecord sub = (SubRecord)subRecordIter.next();
                if (!(sub instanceof EmbeddedObjectRefSubRecord)) continue;
                objects.add(new HSSFObjectData((ObjRecord)obj, this.directory));
            }
        }
    }

    public CreationHelper getCreationHelper() {
        return new HSSFCreationHelper(this);
    }

    UDFFinder getUDFFinder() {
        return this._udfFinder;
    }

    public void addToolPack(UDFFinder toopack) {
        AggregatingUDFFinder udfs = (AggregatingUDFFinder)this._udfFinder;
        udfs.add(toopack);
    }

    public void setForceFormulaRecalculation(boolean value) {
        InternalWorkbook iwb = this.getWorkbook();
        RecalcIdRecord recalc = iwb.getRecalcId();
        recalc.setEngineId(0);
    }

    public boolean getForceFormulaRecalculation() {
        InternalWorkbook iwb = this.getWorkbook();
        RecalcIdRecord recalc = (RecalcIdRecord)iwb.findFirstRecordBySid((short)449);
        return recalc != null && recalc.getEngineId() != 0;
    }

    public boolean changeExternalReference(String oldUrl, String newUrl) {
        return this.workbook.changeExternalReference(oldUrl, newUrl);
    }

    private static final class SheetRecordCollector
    implements RecordAggregate.RecordVisitor {
        private List _list = new ArrayList(128);
        private int _totalSize = 0;

        public int getTotalSize() {
            return this._totalSize;
        }

        public void visitRecord(Record r) {
            this._list.add(r);
            this._totalSize += r.getRecordSize();
        }

        public int serialize(int offset, byte[] data) {
            int result = 0;
            int nRecs = this._list.size();
            int i = 0;
            while (i < nRecs) {
                Record rec = (Record)this._list.get(i);
                result += rec.serialize(offset + result, data);
                ++i;
            }
            return result;
        }
    }
}

