/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula;

import java.util.Stack;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.WorkbookDependentFormula;
import org.apache.poi.ss.formula.ptg.AttrPtg;
import org.apache.poi.ss.formula.ptg.MemAreaPtg;
import org.apache.poi.ss.formula.ptg.MemErrPtg;
import org.apache.poi.ss.formula.ptg.MemFuncPtg;
import org.apache.poi.ss.formula.ptg.OperationPtg;
import org.apache.poi.ss.formula.ptg.ParenthesisPtg;
import org.apache.poi.ss.formula.ptg.Ptg;

public class FormulaRenderer {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String toFormulaString(FormulaRenderingWorkbook book, Ptg[] ptgs) {
        if (ptgs == null || ptgs.length == 0) {
            throw new IllegalArgumentException("ptgs must not be null");
        }
        Stack<String> stack = new Stack<String>();
        int i = 0;
        while (i < ptgs.length) {
            Ptg ptg = ptgs[i];
            if (!(ptg instanceof MemAreaPtg || ptg instanceof MemFuncPtg || ptg instanceof MemErrPtg)) {
                String[] operands;
                if (ptg instanceof ParenthesisPtg) {
                    String contents = (String)stack.pop();
                    stack.push("(" + contents + ")");
                } else if (ptg instanceof AttrPtg) {
                    AttrPtg attrPtg = (AttrPtg)ptg;
                    if (!(attrPtg.isOptimizedIf() || attrPtg.isOptimizedChoose() || attrPtg.isSkip() || attrPtg.isSpace() || attrPtg.isSemiVolatile())) {
                        if (!attrPtg.isSum()) throw new RuntimeException("Unexpected tAttr: " + attrPtg.toString());
                        operands = FormulaRenderer.getOperands(stack, attrPtg.getNumberOfOperands());
                        stack.push(attrPtg.toFormulaString(operands));
                    }
                } else if (ptg instanceof WorkbookDependentFormula) {
                    WorkbookDependentFormula optg = (WorkbookDependentFormula)((Object)ptg);
                    stack.push(optg.toFormulaString(book));
                } else if (!(ptg instanceof OperationPtg)) {
                    stack.push(ptg.toFormulaString());
                } else {
                    OperationPtg o = (OperationPtg)ptg;
                    operands = FormulaRenderer.getOperands(stack, o.getNumberOfOperands());
                    stack.push(o.toFormulaString(operands));
                }
            }
            ++i;
        }
        if (stack.isEmpty()) {
            throw new IllegalStateException("Stack underflow");
        }
        String result = (String)stack.pop();
        if (stack.isEmpty()) return result;
        throw new IllegalStateException("too much stuff left on the stack");
    }

    private static String[] getOperands(Stack stack, int nOperands) {
        String[] operands = new String[nOperands];
        int j = nOperands - 1;
        while (j >= 0) {
            if (stack.isEmpty()) {
                String msg = "Too few arguments supplied to operation. Expected (" + nOperands + ") operands but got (" + (nOperands - j - 1) + ")";
                throw new IllegalStateException(msg);
            }
            operands[j] = (String)stack.pop();
            --j;
        }
        return operands;
    }
}

