/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.TwoDEval;
import org.apache.poi.ss.formula.eval.AreaEval;
import org.apache.poi.ss.formula.eval.BlankEval;
import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.NumericValueEval;
import org.apache.poi.ss.formula.eval.RefEval;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Function;

public final class Sumproduct
implements Function {
    public ValueEval evaluate(ValueEval[] args, int srcCellRow, int srcCellCol) {
        int maxN = args.length;
        if (maxN < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        ValueEval firstArg = args[0];
        try {
            if (firstArg instanceof NumericValueEval) {
                return Sumproduct.evaluateSingleProduct(args);
            }
            if (firstArg instanceof RefEval) {
                return Sumproduct.evaluateSingleProduct(args);
            }
            if (firstArg instanceof TwoDEval) {
                TwoDEval ae = (TwoDEval)firstArg;
                if (ae.isRow() && ae.isColumn()) {
                    return Sumproduct.evaluateSingleProduct(args);
                }
                return Sumproduct.evaluateAreaSumProduct(args);
            }
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        throw new RuntimeException("Invalid arg type for SUMPRODUCT: (" + firstArg.getClass().getName() + ")");
    }

    private static ValueEval evaluateSingleProduct(ValueEval[] evalArgs) throws EvaluationException {
        int maxN = evalArgs.length;
        double term = 1.0;
        int n = 0;
        while (n < maxN) {
            double val = Sumproduct.getScalarValue(evalArgs[n]);
            term *= val;
            ++n;
        }
        return new NumberEval(term);
    }

    private static double getScalarValue(ValueEval arg) throws EvaluationException {
        ValueEval eval;
        if (arg instanceof RefEval) {
            RefEval re = (RefEval)arg;
            eval = re.getInnerValueEval();
        } else {
            eval = arg;
        }
        if (eval == null) {
            throw new RuntimeException("parameter may not be null");
        }
        if (eval instanceof AreaEval) {
            AreaEval ae = (AreaEval)eval;
            if (!ae.isColumn() || !ae.isRow()) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            eval = ae.getRelativeValue(0, 0);
        }
        return Sumproduct.getProductTerm(eval, true);
    }

    private static ValueEval evaluateAreaSumProduct(ValueEval[] evalArgs) throws EvaluationException {
        int maxN = evalArgs.length;
        TwoDEval[] args = new TwoDEval[maxN];
        try {
            System.arraycopy(evalArgs, 0, args, 0, maxN);
        }
        catch (ArrayStoreException e) {
            return ErrorEval.VALUE_INVALID;
        }
        TwoDEval firstArg = args[0];
        int height = firstArg.getHeight();
        int width = firstArg.getWidth();
        if (!Sumproduct.areasAllSameSize(args, height, width)) {
            int i = 1;
            while (i < args.length) {
                Sumproduct.throwFirstError(args[i]);
                ++i;
            }
            return ErrorEval.VALUE_INVALID;
        }
        double acc = 0.0;
        int rrIx = 0;
        while (rrIx < height) {
            int rcIx = 0;
            while (rcIx < width) {
                double term = 1.0;
                int n = 0;
                while (n < maxN) {
                    double val = Sumproduct.getProductTerm(args[n].getValue(rrIx, rcIx), false);
                    term *= val;
                    ++n;
                }
                acc += term;
                ++rcIx;
            }
            ++rrIx;
        }
        return new NumberEval(acc);
    }

    private static void throwFirstError(TwoDEval areaEval) throws EvaluationException {
        int height = areaEval.getHeight();
        int width = areaEval.getWidth();
        int rrIx = 0;
        while (rrIx < height) {
            int rcIx = 0;
            while (rcIx < width) {
                ValueEval ve = areaEval.getValue(rrIx, rcIx);
                if (ve instanceof ErrorEval) {
                    throw new EvaluationException((ErrorEval)ve);
                }
                ++rcIx;
            }
            ++rrIx;
        }
    }

    private static boolean areasAllSameSize(TwoDEval[] args, int height, int width) {
        int i = 0;
        while (i < args.length) {
            TwoDEval areaEval = args[i];
            if (areaEval.getHeight() != height) {
                return false;
            }
            if (areaEval.getWidth() != width) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static double getProductTerm(ValueEval ve, boolean isScalarProduct) throws EvaluationException {
        if (ve instanceof BlankEval || ve == null) {
            if (isScalarProduct) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return 0.0;
        }
        if (ve instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)ve);
        }
        if (ve instanceof StringEval) {
            if (isScalarProduct) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return 0.0;
        }
        if (ve instanceof NumericValueEval) {
            NumericValueEval nve = (NumericValueEval)ve;
            return nve.getNumberValue();
        }
        throw new RuntimeException("Unexpected value eval class (" + ve.getClass().getName() + ")");
    }
}

