/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import org.apache.poi.hpsf.IllegalPropertySetDataException;
import org.apache.poi.hpsf.TypedPropertyValue;
import org.apache.poi.util.LittleEndian;

class Array {
    private ArrayHeader _header;
    private TypedPropertyValue[] _values;

    Array() {
    }

    Array(byte[] data, int offset) {
        this.read(data, offset);
    }

    int read(byte[] data, int startOffset) {
        int offset = startOffset;
        this._header = new ArrayHeader(data, offset);
        offset += this._header.getSize();
        long numberOfScalarsLong = this._header.getNumberOfScalarValues();
        if (numberOfScalarsLong > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Sorry, but POI can't store array of properties with size of " + numberOfScalarsLong + " in memory");
        }
        int numberOfScalars = (int)numberOfScalarsLong;
        this._values = new TypedPropertyValue[numberOfScalars];
        int type = this._header._type;
        if (type == 12) {
            int i = 0;
            while (i < numberOfScalars) {
                TypedPropertyValue typedPropertyValue = new TypedPropertyValue();
                offset += typedPropertyValue.read(data, offset);
                ++i;
            }
        } else {
            int i = 0;
            while (i < numberOfScalars) {
                TypedPropertyValue typedPropertyValue = new TypedPropertyValue(type, null);
                offset += typedPropertyValue.readValuePadded(data, offset);
                ++i;
            }
        }
        return offset - startOffset;
    }

    static class ArrayDimension {
        static final int SIZE = 8;
        private int _indexOffset;
        private long _size;

        ArrayDimension(byte[] data, int offset) {
            this._size = LittleEndian.getUInt(data, offset);
            this._indexOffset = LittleEndian.getInt(data, offset + 4);
        }
    }

    static class ArrayHeader {
        private ArrayDimension[] _dimensions;
        private int _type;

        ArrayHeader(byte[] data, int startOffset) {
            int offset = startOffset;
            this._type = LittleEndian.getInt(data, offset);
            long numDimensionsUnsigned = LittleEndian.getUInt(data, offset += 4);
            offset += 4;
            if (1L > numDimensionsUnsigned || numDimensionsUnsigned > 31L) {
                throw new IllegalPropertySetDataException("Array dimension number " + numDimensionsUnsigned + " is not in [1; 31] range");
            }
            int numDimensions = (int)numDimensionsUnsigned;
            this._dimensions = new ArrayDimension[numDimensions];
            int i = 0;
            while (i < numDimensions) {
                this._dimensions[i] = new ArrayDimension(data, offset);
                offset += 8;
                ++i;
            }
        }

        long getNumberOfScalarValues() {
            long result = 1L;
            int i = 0;
            while (i < this._dimensions.length) {
                ArrayDimension dimension = this._dimensions[i];
                result *= dimension._size;
                ++i;
            }
            return result;
        }

        int getSize() {
            return 8 + this._dimensions.length * 8;
        }

        int getType() {
            return this._type;
        }
    }
}

