/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class FontMetricsDumper {
    public static void main(String[] args) throws IOException {
        Properties props = new Properties();
        Font[] allFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        int i = 0;
        while (i < allFonts.length) {
            String fontName = allFonts[i].getFontName();
            Font font = new Font(fontName, 1, 10);
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            int fontHeight = fontMetrics.getHeight();
            props.setProperty("font." + fontName + ".height", String.valueOf(fontHeight));
            StringBuffer characters = new StringBuffer();
            char c = 'a';
            while (c <= 'z') {
                characters.append(String.valueOf(c) + ", ");
                c = (char)(c + '\u0001');
            }
            c = 'A';
            while (c <= 'Z') {
                characters.append(String.valueOf(c) + ", ");
                c = (char)(c + '\u0001');
            }
            c = '0';
            while (c <= '9') {
                characters.append(String.valueOf(c) + ", ");
                c = (char)(c + '\u0001');
            }
            StringBuffer widths = new StringBuffer();
            int c2 = 97;
            while (c2 <= 122) {
                widths.append(String.valueOf(fontMetrics.getWidths()[c2]) + ", ");
                c2 = (char)(c2 + 1);
            }
            c2 = 65;
            while (c2 <= 90) {
                widths.append(String.valueOf(fontMetrics.getWidths()[c2]) + ", ");
                c2 = (char)(c2 + 1);
            }
            c2 = 48;
            while (c2 <= 57) {
                widths.append(String.valueOf(fontMetrics.getWidths()[c2]) + ", ");
                c2 = (char)(c2 + 1);
            }
            props.setProperty("font." + fontName + ".characters", characters.toString());
            props.setProperty("font." + fontName + ".widths", widths.toString());
            ++i;
        }
        FileOutputStream fileOut = new FileOutputStream("font_metrics.properties");
        try {
            props.store(fileOut, "Font Metrics");
        }
        finally {
            fileOut.close();
        }
    }
}

