/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.xssf.usermodel.XSSFMap;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMap;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTMapInfo;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTSchema;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.MapInfoDocument;

public class MapInfo
extends POIXMLDocumentPart {
    private CTMapInfo mapInfo;
    private Map maps;

    public MapInfo() {
        this.mapInfo = CTMapInfo.Factory.newInstance();
    }

    public MapInfo(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        this.readFrom(part.getInputStream());
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            MapInfoDocument doc = MapInfoDocument.Factory.parse((InputStream)is);
            this.mapInfo = doc.getMapInfo();
            this.maps = new HashMap();
            Iterator<CTMap> iterator = Arrays.asList(this.mapInfo.getMapArray()).iterator();
            while (iterator.hasNext()) {
                CTMap map = iterator.next();
                this.maps.put(new Integer((int)map.getID()), new XSSFMap(map, this));
            }
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public XSSFWorkbook getWorkbook() {
        return (XSSFWorkbook)this.getParent();
    }

    public CTMapInfo getCTMapInfo() {
        return this.mapInfo;
    }

    public CTSchema getCTSchemaById(String schemaId) {
        CTSchema xmlSchema = null;
        Iterator<CTSchema> iterator = Arrays.asList(this.mapInfo.getSchemaArray()).iterator();
        while (iterator.hasNext()) {
            CTSchema schema = iterator.next();
            if (!schema.getID().equals(schemaId)) continue;
            xmlSchema = schema;
            break;
        }
        return xmlSchema;
    }

    public XSSFMap getXSSFMapById(int id) {
        return (XSSFMap)this.maps.get(new Integer(id));
    }

    public XSSFMap getXSSFMapByName(String name) {
        XSSFMap matchedMap = null;
        Iterator iterator = this.maps.values().iterator();
        while (iterator.hasNext()) {
            XSSFMap map = (XSSFMap)iterator.next();
            if (map.getCtMap().getName() == null || !map.getCtMap().getName().equals(name)) continue;
            matchedMap = map;
        }
        return matchedMap;
    }

    public Collection getAllXSSFMaps() {
        return this.maps.values();
    }

    protected void writeTo(OutputStream out) throws IOException {
        MapInfoDocument doc = MapInfoDocument.Factory.newInstance();
        doc.setMapInfo(this.mapInfo);
        doc.save(out, DEFAULT_XML_OPTIONS);
    }

    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }
}

