/* ====================================================================
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
==================================================================== */
package org.apache.poi.xslf.usermodel;

/**
 *  Represents the shape decoration that appears at the ends of lines.
 */
public class LineDecoration {

	public static final LineDecoration NONE = new LineDecoration(0);
	public static final LineDecoration TRIANGLE = new LineDecoration(1);
	public static final LineDecoration STEALTH = new LineDecoration(2);
	public static final LineDecoration DIAMOND = new LineDecoration(3);
	public static final LineDecoration OVAL = new LineDecoration(4);
	public static final LineDecoration ARROW = new LineDecoration(5);

	private int _ordinal;

	public LineDecoration(int ordinal) {
		this._ordinal = ordinal;
	}

	public int ordinal() {
		return this._ordinal;
	}

	public static LineDecoration[] values() {
		return new LineDecoration[] { NONE, TRIANGLE, STEALTH, DIAMOND, OVAL,
				ARROW };
	}

}
