/*
 *  ====================================================================
 *    Licensed to the Apache Software Foundation (ASF) under one or more
 *    contributor license agreements.  See the NOTICE file distributed with
 *    this work for additional information regarding copyright ownership.
 *    The ASF licenses this file to You under the Apache License, Version 2.0
 *    (the "License"); you may not use this file except in compliance with
 *    the License.  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 * ====================================================================
 */
package org.apache.poi.xslf.usermodel;

/**
 * Specifies type of automatic numbered bullet points that should be applied to a paragraph.
 *
 * @author Yegor Kozlov
 */
public class ListAutoNumber {
    /**
     * (a), (b), (c), ...
     */
	public static final ListAutoNumber ALPHA_LC_PARENT_BOTH = new ListAutoNumber(0);
    /**
     * (A), (B), (C), ...
     */
	public static final ListAutoNumber ALPHA_UC_PARENT_BOTH = new ListAutoNumber(1);
    /**
     * a), b), c), ...
     */
	public static final ListAutoNumber ALPHA_LC_PARENT_R = new ListAutoNumber(2);
    /**
     * A), B), C), ...
     */
	public static final ListAutoNumber ALPHA_UC_PARENT_R = new ListAutoNumber(3);
    /**
     *  a., b., c., ...
     */
	public static final ListAutoNumber ALPHA_LC_PERIOD = new ListAutoNumber(4);
    /**
     * A., B., C., ...
     */
	public static final ListAutoNumber ALPHA_UC_PERIOD = new ListAutoNumber(5);
    /**
     * (1), (2), (3), ...
     */
	public static final ListAutoNumber ARABIC_PARENT_BOTH = new ListAutoNumber(6);
    /**
     * 1), 2), 3), ...
     */
	public static final ListAutoNumber ARABIC_PARENT_R = new ListAutoNumber(7);

    /**
     * 1., 2., 3., ...
     */
	public static final ListAutoNumber ARABIC_PERIOD = new ListAutoNumber(8);
    /**
     * 1, 2, 3, ...
     */
	public static final ListAutoNumber ARABIC_PLAIN = new ListAutoNumber(9);

    /**
     * (i), (ii), (iii), ...
     */
	public static final ListAutoNumber ROMAN_LC_PARENT_BOTH = new ListAutoNumber(10);
    /**
     * (I), (II), (III), ...
     */
	public static final ListAutoNumber ROMAN_UC_PARENT_BOTH = new ListAutoNumber(11);
    /**
     * i), ii), iii), ...
     */
	public static final ListAutoNumber ROMAN_LC_PARENT_R = new ListAutoNumber(12);
    /**
     * I), II), III), ...
     */
	public static final ListAutoNumber ROMAN_UC_PARENT_R = new ListAutoNumber(13);
    /**
     *  i., ii., iii., ...
     */
	public static final ListAutoNumber ROMAN_LC_PERIOD  = new ListAutoNumber(14);
    /**
     * I., II., III., ...
     */
	public static final ListAutoNumber ROMAN_UC_PERIOD = new ListAutoNumber(15);
    /**
     * Dbl-byte circle numbers
     */
	public static final ListAutoNumber CIRCLE_NUM_DB_PLAIN = new ListAutoNumber(16);
    /**
     * Wingdings black circle numbers
     */
	public static final ListAutoNumber CIRCLE_NUM_WD_BLACK_PLAIN = new ListAutoNumber(17);
    /**
     * Wingdings white circle numbers
     */
	public static final ListAutoNumber CIRCLE_NUM_WD_WHITE_PLAIN = new ListAutoNumber(18);

	private int _ordinal;

	public ListAutoNumber(int ordinal) {
		this._ordinal = ordinal;
	}

	public int ordinal() {
		return this._ordinal;
	}

	public static ListAutoNumber[] values() {
		return new ListAutoNumber[] { ALPHA_LC_PARENT_BOTH,
				ALPHA_UC_PARENT_BOTH, ALPHA_LC_PARENT_R, ALPHA_UC_PARENT_R,
				ALPHA_LC_PERIOD, ALPHA_UC_PERIOD, ARABIC_PARENT_BOTH,
				ARABIC_PARENT_R, ARABIC_PERIOD, ARABIC_PLAIN,
				ROMAN_LC_PARENT_BOTH, ROMAN_UC_PARENT_BOTH, ROMAN_LC_PARENT_R,
				ROMAN_UC_PARENT_R, ROMAN_LC_PERIOD, ROMAN_UC_PERIOD,
				CIRCLE_NUM_DB_PLAIN, CIRCLE_NUM_WD_BLACK_PLAIN,
				CIRCLE_NUM_WD_WHITE_PLAIN };
	}
}
