/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hdf.extractor;

import org.apache.poi.hdf.extractor.CHP;
import org.apache.poi.hdf.extractor.PAP;
import org.apache.poi.hdf.extractor.SEP;
import org.apache.poi.hdf.extractor.StyleDescription;
import org.apache.poi.hdf.extractor.TAP;
import org.apache.poi.hdf.extractor.TC;
import org.apache.poi.hdf.extractor.Utils;

public final class StyleSheet {
    private static final int NIL_STYLE = 4095;
    private static final int PAP_TYPE = 1;
    private static final int CHP_TYPE = 2;
    private static final int SEP_TYPE = 4;
    private static final int TAP_TYPE = 5;
    StyleDescription _nilStyle = new StyleDescription();
    StyleDescription[] _styleDescriptions;

    public StyleSheet(byte[] styleSheet) {
        short stshiLength = Utils.convertBytesToShort(styleSheet, 0);
        int stdCount = Utils.convertBytesToShort(styleSheet, 2);
        short baseLength = Utils.convertBytesToShort(styleSheet, 4);
        int[] rgftc = new int[]{Utils.convertBytesToInt(styleSheet, 14), Utils.convertBytesToInt(styleSheet, 18), Utils.convertBytesToInt(styleSheet, 22)};
        int offset = 0;
        this._styleDescriptions = new StyleDescription[stdCount];
        int x = 0;
        while (x < stdCount) {
            int stdOffset = 2 + stshiLength + offset;
            short stdSize = Utils.convertBytesToShort(styleSheet, stdOffset);
            if (stdSize > 0) {
                StyleDescription aStyle;
                byte[] std = new byte[stdSize];
                System.arraycopy(styleSheet, stdOffset += 2, std, 0, stdSize);
                this._styleDescriptions[x] = aStyle = new StyleDescription(std, baseLength, true);
            }
            offset += stdSize + 2;
            ++x;
        }
        x = 0;
        while (x < this._styleDescriptions.length) {
            if (this._styleDescriptions[x] != null) {
                this.createPap(x);
                this.createChp(x);
            }
            ++x;
        }
    }

    private void createPap(int istd) {
        StyleDescription sd = this._styleDescriptions[istd];
        PAP pap = sd.getPAP();
        byte[] papx = sd.getPAPX();
        int baseIndex = sd.getBaseStyle();
        if (pap == null && papx != null) {
            PAP parentPAP = this._nilStyle.getPAP();
            if (baseIndex != 4095 && (parentPAP = this._styleDescriptions[baseIndex].getPAP()) == null) {
                this.createPap(baseIndex);
                parentPAP = this._styleDescriptions[baseIndex].getPAP();
            }
            pap = (PAP)StyleSheet.uncompressProperty(papx, parentPAP, this);
            sd.setPAP(pap);
        }
    }

    private void createChp(int istd) {
        StyleDescription sd = this._styleDescriptions[istd];
        CHP chp = sd.getCHP();
        byte[] chpx = sd.getCHPX();
        int baseIndex = sd.getBaseStyle();
        if (chp == null && chpx != null) {
            CHP parentCHP = this._nilStyle.getCHP();
            if (baseIndex != 4095 && (parentCHP = this._styleDescriptions[baseIndex].getCHP()) == null) {
                this.createChp(baseIndex);
                parentCHP = this._styleDescriptions[baseIndex].getCHP();
            }
            chp = (CHP)StyleSheet.uncompressProperty(chpx, parentCHP, this);
            sd.setCHP(chp);
        }
    }

    public StyleDescription getStyleDescription(int x) {
        return this._styleDescriptions[x];
    }

    static void doCHPOperation(CHP oldCHP, CHP newCHP, int operand, int param, byte[] varParam, byte[] grpprl, int offset, StyleSheet styleSheet) {
        switch (operand) {
            case 0: {
                newCHP._fRMarkDel = StyleSheet.getFlag(param);
                break;
            }
            case 1: {
                newCHP._fRMark = StyleSheet.getFlag(param);
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                newCHP._fcPic = param;
                newCHP._fSpec = true;
                break;
            }
            case 4: {
                newCHP._ibstRMark = (short)param;
                break;
            }
            case 5: {
                newCHP._dttmRMark[0] = Utils.convertBytesToShort(grpprl, offset - 4);
                newCHP._dttmRMark[1] = Utils.convertBytesToShort(grpprl, offset - 2);
                break;
            }
            case 6: {
                newCHP._fData = StyleSheet.getFlag(param);
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                short chsDiff = (short)((param & 0xFF0000) >>> 8);
                newCHP._fChsDiff = StyleSheet.getFlag(chsDiff);
                newCHP._chse = (short)(param & 0xFFFF);
                break;
            }
            case 9: {
                newCHP._fSpec = true;
                newCHP._ftcSym = Utils.convertBytesToShort(varParam, 0);
                newCHP._xchSym = Utils.convertBytesToShort(varParam, 2);
                break;
            }
            case 10: {
                newCHP._fOle2 = StyleSheet.getFlag(param);
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                newCHP._icoHighlight = (byte)param;
                newCHP._highlighted = StyleSheet.getFlag(param);
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                newCHP._fcObj = param;
                break;
            }
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                break;
            }
            case 20: {
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                break;
            }
            case 23: {
                break;
            }
            case 24: {
                break;
            }
            case 25: {
                break;
            }
            case 26: {
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                break;
            }
            case 29: {
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                break;
            }
            case 32: {
                break;
            }
            case 33: {
                break;
            }
            case 34: {
                break;
            }
            case 35: {
                break;
            }
            case 36: {
                break;
            }
            case 37: {
                break;
            }
            case 38: {
                break;
            }
            case 39: {
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                break;
            }
            case 44: {
                break;
            }
            case 45: {
                break;
            }
            case 46: {
                break;
            }
            case 47: {
                break;
            }
            case 48: {
                newCHP._istd = param;
                break;
            }
            case 49: {
                break;
            }
            case 50: {
                newCHP._bold = false;
                newCHP._italic = false;
                newCHP._fOutline = false;
                newCHP._fStrike = false;
                newCHP._fShadow = false;
                newCHP._fSmallCaps = false;
                newCHP._fCaps = false;
                newCHP._fVanish = false;
                newCHP._kul = 0;
                newCHP._ico = 0;
                break;
            }
            case 51: {
                newCHP.copy(oldCHP);
                return;
            }
            case 52: {
                break;
            }
            case 53: {
                newCHP._bold = StyleSheet.getCHPFlag((byte)param, oldCHP._bold);
                break;
            }
            case 54: {
                newCHP._italic = StyleSheet.getCHPFlag((byte)param, oldCHP._italic);
                break;
            }
            case 55: {
                newCHP._fStrike = StyleSheet.getCHPFlag((byte)param, oldCHP._fStrike);
                break;
            }
            case 56: {
                newCHP._fOutline = StyleSheet.getCHPFlag((byte)param, oldCHP._fOutline);
                break;
            }
            case 57: {
                newCHP._fShadow = StyleSheet.getCHPFlag((byte)param, oldCHP._fShadow);
                break;
            }
            case 58: {
                newCHP._fSmallCaps = StyleSheet.getCHPFlag((byte)param, oldCHP._fSmallCaps);
                break;
            }
            case 59: {
                newCHP._fCaps = StyleSheet.getCHPFlag((byte)param, oldCHP._fCaps);
                break;
            }
            case 60: {
                newCHP._fVanish = StyleSheet.getCHPFlag((byte)param, oldCHP._fVanish);
                break;
            }
            case 61: {
                newCHP._ftc = (short)param;
                break;
            }
            case 62: {
                newCHP._kul = (byte)param;
                break;
            }
            case 63: {
                boolean fAdjust;
                byte hpsPos;
                byte cInc;
                int hps = param & 0xFF;
                if (hps != 0) {
                    newCHP._hps = hps;
                }
                if ((cInc = (byte)((byte)(param & 0xFE00) >>> 4 >> 1)) != 0) {
                    newCHP._hps = Math.max(newCHP._hps + cInc * 2, 2);
                }
                if ((hpsPos = (byte)((param & 0xFF0000) >>> 8)) != 128) {
                    newCHP._hpsPos = hpsPos;
                }
                boolean bl = fAdjust = (param & 0x100) > 0;
                if (fAdjust && hpsPos != 128 && hpsPos != 0 && oldCHP._hpsPos == 0) {
                    newCHP._hps = Math.max(newCHP._hps + -2, 2);
                }
                if (!fAdjust || hpsPos != 0 || oldCHP._hpsPos == 0) break;
                newCHP._hps = Math.max(newCHP._hps + 2, 2);
                break;
            }
            case 64: {
                newCHP._dxaSpace = param;
                break;
            }
            case 65: {
                newCHP._lidDefault = (short)param;
                break;
            }
            case 66: {
                newCHP._ico = (byte)param;
                break;
            }
            case 67: {
                newCHP._hps = param;
                break;
            }
            case 68: {
                byte hpsLvl = (byte)param;
                newCHP._hps = Math.max(newCHP._hps + hpsLvl * 2, 2);
                break;
            }
            case 69: {
                newCHP._hpsPos = (short)param;
                break;
            }
            case 70: {
                if (param != 0) {
                    if (oldCHP._hpsPos != 0) break;
                    newCHP._hps = Math.max(newCHP._hps + -2, 2);
                    break;
                }
                if (oldCHP._hpsPos == 0) break;
                newCHP._hps = Math.max(newCHP._hps + 2, 2);
                break;
            }
            case 71: {
                CHP genCHP = new CHP();
                genCHP._ftc = (short)4;
                genCHP = (CHP)StyleSheet.uncompressProperty(varParam, genCHP, styleSheet);
                CHP styleCHP = styleSheet.getStyleDescription(oldCHP._baseIstd).getCHP();
                if (genCHP._bold == newCHP._bold) {
                    newCHP._bold = styleCHP._bold;
                }
                if (genCHP._italic == newCHP._italic) {
                    newCHP._italic = styleCHP._italic;
                }
                if (genCHP._fSmallCaps == newCHP._fSmallCaps) {
                    newCHP._fSmallCaps = styleCHP._fSmallCaps;
                }
                if (genCHP._fVanish == newCHP._fVanish) {
                    newCHP._fVanish = styleCHP._fVanish;
                }
                if (genCHP._fStrike == newCHP._fStrike) {
                    newCHP._fStrike = styleCHP._fStrike;
                }
                if (genCHP._fCaps == newCHP._fCaps) {
                    newCHP._fCaps = styleCHP._fCaps;
                }
                if (genCHP._ftcAscii == newCHP._ftcAscii) {
                    newCHP._ftcAscii = styleCHP._ftcAscii;
                }
                if (genCHP._ftcFE == newCHP._ftcFE) {
                    newCHP._ftcFE = styleCHP._ftcFE;
                }
                if (genCHP._ftcOther == newCHP._ftcOther) {
                    newCHP._ftcOther = styleCHP._ftcOther;
                }
                if (genCHP._hps == newCHP._hps) {
                    newCHP._hps = styleCHP._hps;
                }
                if (genCHP._hpsPos == newCHP._hpsPos) {
                    newCHP._hpsPos = styleCHP._hpsPos;
                }
                if (genCHP._kul == newCHP._kul) {
                    newCHP._kul = styleCHP._kul;
                }
                if (genCHP._dxaSpace == newCHP._dxaSpace) {
                    newCHP._dxaSpace = styleCHP._dxaSpace;
                }
                if (genCHP._ico == newCHP._ico) {
                    newCHP._ico = styleCHP._ico;
                }
                if (genCHP._lidDefault == newCHP._lidDefault) {
                    newCHP._lidDefault = styleCHP._lidDefault;
                }
                if (genCHP._lidFE != newCHP._lidFE) break;
                newCHP._lidFE = styleCHP._lidFE;
                break;
            }
            case 72: {
                newCHP._iss = (byte)param;
                break;
            }
            case 73: {
                newCHP._hps = Utils.convertBytesToShort(varParam, 0);
                break;
            }
            case 74: {
                short increment = Utils.convertBytesToShort(varParam, 0);
                newCHP._hps = Math.max(newCHP._hps + increment, 8);
                break;
            }
            case 75: {
                newCHP._hpsKern = param;
                break;
            }
            case 76: {
                StyleSheet.doCHPOperation(oldCHP, newCHP, 71, param, varParam, grpprl, offset, styleSheet);
                break;
            }
            case 77: {
                float percentage = (float)param / 100.0f;
                int add = (int)(percentage * (float)newCHP._hps);
                newCHP._hps += add;
                break;
            }
            case 78: {
                newCHP._ysr = (byte)param;
                break;
            }
            case 79: {
                newCHP._ftcAscii = (short)param;
                break;
            }
            case 80: {
                newCHP._ftcFE = (short)param;
                break;
            }
            case 81: {
                newCHP._ftcOther = (short)param;
                break;
            }
            case 82: {
                break;
            }
            case 83: {
                newCHP._fDStrike = StyleSheet.getFlag(param);
                break;
            }
            case 84: {
                newCHP._fImprint = StyleSheet.getFlag(param);
                break;
            }
            case 85: {
                newCHP._fSpec = StyleSheet.getFlag(param);
                break;
            }
            case 86: {
                newCHP._fObj = StyleSheet.getFlag(param);
                break;
            }
            case 87: {
                newCHP._fPropMark = StyleSheet.getFlag(varParam[0]);
                newCHP._ibstPropRMark = Utils.convertBytesToShort(varParam, 1);
                newCHP._dttmPropRMark = Utils.convertBytesToInt(varParam, 3);
                break;
            }
            case 88: {
                newCHP._fEmboss = StyleSheet.getFlag(param);
                break;
            }
            case 89: {
                newCHP._sfxtText = (byte)param;
                break;
            }
            case 90: {
                break;
            }
            case 91: {
                break;
            }
            case 92: {
                break;
            }
            case 93: {
                break;
            }
            case 94: {
                break;
            }
            case 95: {
                break;
            }
            case 96: {
                break;
            }
            case 97: {
                break;
            }
            case 98: {
                newCHP._fDispFldRMark = StyleSheet.getFlag(varParam[0]);
                newCHP._ibstDispFldRMark = Utils.convertBytesToShort(varParam, 1);
                newCHP._dttmDispFldRMark = Utils.convertBytesToInt(varParam, 3);
                System.arraycopy(varParam, 7, newCHP._xstDispFldRMark, 0, 32);
                break;
            }
            case 99: {
                newCHP._ibstRMarkDel = (short)param;
                break;
            }
            case 100: {
                newCHP._dttmRMarkDel[0] = Utils.convertBytesToShort(grpprl, offset - 4);
                newCHP._dttmRMarkDel[1] = Utils.convertBytesToShort(grpprl, offset - 2);
                break;
            }
            case 101: {
                newCHP._brc[0] = Utils.convertBytesToShort(grpprl, offset - 4);
                newCHP._brc[1] = Utils.convertBytesToShort(grpprl, offset - 2);
                break;
            }
            case 102: {
                newCHP._shd = (short)param;
                break;
            }
            case 103: {
                break;
            }
            case 104: {
                break;
            }
            case 105: {
                break;
            }
            case 106: {
                break;
            }
            case 107: {
                break;
            }
            case 108: {
                break;
            }
            case 109: {
                newCHP._lidDefault = (short)param;
                break;
            }
            case 110: {
                newCHP._lidFE = (short)param;
                break;
            }
            case 111: {
                newCHP._idctHint = (byte)param;
            }
        }
    }

    static Object uncompressProperty(byte[] grpprl, Object parent, StyleSheet styleSheet) {
        return StyleSheet.uncompressProperty(grpprl, parent, styleSheet, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Object uncompressProperty(byte[] grpprl, Object parent, StyleSheet styleSheet, boolean doIstd) {
        Object newProperty = null;
        int offset = 0;
        int propertyType = 1;
        if (parent instanceof PAP) {
            try {
                newProperty = ((PAP)parent).clone();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (doIstd) {
                ((PAP)newProperty)._istd = Utils.convertBytesToShort(grpprl, 0);
                offset = 2;
            }
        } else if (parent instanceof CHP) {
            try {
                newProperty = ((CHP)parent).clone();
                ((CHP)newProperty)._baseIstd = ((CHP)parent)._istd;
            }
            catch (Exception exception) {
                // empty catch block
            }
            propertyType = 2;
        } else if (parent instanceof SEP) {
            newProperty = parent;
            propertyType = 4;
        } else {
            if (!(parent instanceof TAP)) {
                return null;
            }
            newProperty = parent;
            propertyType = 5;
            offset = 2;
        }
        block18: while (offset < grpprl.length) {
            short sprm = Utils.convertBytesToShort(grpprl, offset);
            offset += 2;
            byte spra = (byte)((sprm & 0xE000) >> 13);
            int opSize = 0;
            int param = 0;
            byte[] varParam = null;
            switch (spra) {
                case 0: 
                case 1: {
                    opSize = 1;
                    param = grpprl[offset];
                    break;
                }
                case 2: {
                    opSize = 2;
                    param = Utils.convertBytesToShort(grpprl, offset);
                    break;
                }
                case 3: {
                    opSize = 4;
                    param = Utils.convertBytesToInt(grpprl, offset);
                    break;
                }
                case 4: 
                case 5: {
                    opSize = 2;
                    param = Utils.convertBytesToShort(grpprl, offset);
                    break;
                }
                case 6: {
                    if (sprm != -10744) {
                        opSize = Utils.convertUnsignedByteToInt(grpprl[offset]);
                        ++offset;
                    } else {
                        opSize = Utils.convertBytesToShort(grpprl, offset) - 1;
                        offset += 2;
                    }
                    varParam = new byte[opSize];
                    System.arraycopy(grpprl, offset, varParam, 0, opSize);
                    break;
                }
                case 7: {
                    opSize = 3;
                    param = Utils.convertBytesToInt((byte)0, grpprl[offset + 2], grpprl[offset + 1], grpprl[offset]);
                    break;
                }
                default: {
                    throw new RuntimeException("unrecognized pap opcode");
                }
            }
            offset += opSize;
            short operand = (short)(sprm & 0x1FF);
            byte type = (byte)((sprm & 0x1C00) >> 10);
            switch (propertyType) {
                case 1: {
                    if (type != 1) continue block18;
                    StyleSheet.doPAPOperation((PAP)newProperty, operand, param, varParam, grpprl, offset, spra);
                    break;
                }
                case 2: {
                    StyleSheet.doCHPOperation((CHP)parent, (CHP)newProperty, operand, param, varParam, grpprl, offset, styleSheet);
                    break;
                }
                case 4: {
                    StyleSheet.doSEPOperation((SEP)newProperty, operand, param, varParam);
                    break;
                }
                case 5: {
                    if (type != 5) continue block18;
                    StyleSheet.doTAPOperation((TAP)newProperty, operand, param, varParam);
                    break;
                }
            }
        }
        return newProperty;
    }

    static void doPAPOperation(PAP newPAP, int operand, int param, byte[] varParam, byte[] grpprl, int offset, int spra) {
        switch (operand) {
            case 0: {
                newPAP._istd = param;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (newPAP._istd > 9 && newPAP._istd < 1) break;
                newPAP._istd += param;
                if (param > 0) {
                    newPAP._istd = Math.max(newPAP._istd, 9);
                    break;
                }
                newPAP._istd = Math.min(newPAP._istd, 1);
                break;
            }
            case 3: {
                newPAP._jc = (byte)param;
                break;
            }
            case 4: {
                newPAP._fSideBySide = (byte)param;
                break;
            }
            case 5: {
                newPAP._fKeep = (byte)param;
                break;
            }
            case 6: {
                newPAP._fKeepFollow = (byte)param;
                break;
            }
            case 7: {
                newPAP._fPageBreakBefore = (byte)param;
                break;
            }
            case 8: {
                newPAP._brcl = (byte)param;
                break;
            }
            case 9: {
                newPAP._brcp = (byte)param;
                break;
            }
            case 10: {
                newPAP._ilvl = (byte)param;
                break;
            }
            case 11: {
                newPAP._ilfo = param;
                break;
            }
            case 12: {
                newPAP._fNoLnn = (byte)param;
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                newPAP._dxaRight = param;
                break;
            }
            case 15: {
                newPAP._dxaLeft = param;
                break;
            }
            case 16: {
                newPAP._dxaLeft += param;
                newPAP._dxaLeft = Math.max(0, newPAP._dxaLeft);
                break;
            }
            case 17: {
                newPAP._dxaLeft1 = param;
                break;
            }
            case 18: {
                newPAP._lspd[0] = Utils.convertBytesToShort(grpprl, offset - 4);
                newPAP._lspd[1] = Utils.convertBytesToShort(grpprl, offset - 2);
                break;
            }
            case 19: {
                newPAP._dyaBefore = param;
                break;
            }
            case 20: {
                newPAP._dyaAfter = param;
                break;
            }
            case 21: {
                break;
            }
            case 22: {
                newPAP._fInTable = (byte)param;
                break;
            }
            case 23: {
                newPAP._fTtp = (byte)param;
                break;
            }
            case 24: {
                newPAP._dxaAbs = param;
                break;
            }
            case 25: {
                newPAP._dyaAbs = param;
                break;
            }
            case 26: {
                newPAP._dxaWidth = param;
                break;
            }
            case 27: {
                break;
            }
            case 28: {
                newPAP._brcTop1 = (short)param;
                break;
            }
            case 29: {
                newPAP._brcLeft1 = (short)param;
                break;
            }
            case 30: {
                newPAP._brcBottom1 = (short)param;
                break;
            }
            case 31: {
                newPAP._brcRight1 = (short)param;
                break;
            }
            case 32: {
                newPAP._brcBetween1 = (short)param;
                break;
            }
            case 33: {
                newPAP._brcBar1 = (byte)param;
                break;
            }
            case 34: {
                newPAP._dxaFromText = param;
                break;
            }
            case 35: {
                newPAP._wr = (byte)param;
                break;
            }
            case 36: {
                newPAP._brcTop[0] = Utils.convertBytesToShort(grpprl, offset - 4);
                newPAP._brcTop[1] = Utils.convertBytesToShort(grpprl, offset - 2);
                break;
            }
            case 37: {
                newPAP._brcLeft[0] = Utils.convertBytesToShort(grpprl, offset - 4);
                newPAP._brcLeft[1] = Utils.convertBytesToShort(grpprl, offset - 2);
                break;
            }
            case 38: {
                newPAP._brcBottom[0] = Utils.convertBytesToShort(grpprl, offset - 4);
                newPAP._brcBottom[1] = Utils.convertBytesToShort(grpprl, offset - 2);
                break;
            }
            case 39: {
                newPAP._brcRight[0] = Utils.convertBytesToShort(grpprl, offset - 4);
                newPAP._brcRight[1] = Utils.convertBytesToShort(grpprl, offset - 2);
                break;
            }
            case 40: {
                newPAP._brcBetween[0] = Utils.convertBytesToShort(grpprl, offset - 4);
                newPAP._brcBetween[1] = Utils.convertBytesToShort(grpprl, offset - 2);
                break;
            }
            case 41: {
                newPAP._brcBar[0] = Utils.convertBytesToShort(grpprl, offset - 4);
                newPAP._brcBar[1] = Utils.convertBytesToShort(grpprl, offset - 2);
                break;
            }
            case 42: {
                newPAP._fNoAutoHyph = (byte)param;
                break;
            }
            case 43: {
                newPAP._dyaHeight = param;
                break;
            }
            case 44: {
                newPAP._dcs = param;
                break;
            }
            case 45: {
                newPAP._shd = param;
                break;
            }
            case 46: {
                newPAP._dyaFromText = param;
                break;
            }
            case 47: {
                newPAP._dxaFromText = param;
                break;
            }
            case 48: {
                newPAP._fLocked = (byte)param;
                break;
            }
            case 49: {
                newPAP._fWindowControl = (byte)param;
                break;
            }
            case 50: {
                break;
            }
            case 51: {
                newPAP._fKinsoku = (byte)param;
                break;
            }
            case 52: {
                newPAP._fWordWrap = (byte)param;
                break;
            }
            case 53: {
                newPAP._fOverflowPunct = (byte)param;
                break;
            }
            case 54: {
                newPAP._fTopLinePunct = (byte)param;
                break;
            }
            case 55: {
                newPAP._fAutoSpaceDE = (byte)param;
                break;
            }
            case 56: {
                newPAP._fAutoSpaceDN = (byte)param;
                break;
            }
            case 57: {
                newPAP._wAlignFont = param;
                break;
            }
            case 58: {
                newPAP._fontAlign = (short)param;
                break;
            }
            case 59: {
                break;
            }
            case 62: {
                newPAP._anld = varParam;
                break;
            }
            case 63: {
                break;
            }
            case 64: {
                break;
            }
            case 65: {
                break;
            }
            case 67: {
                break;
            }
            case 68: {
                break;
            }
            case 69: {
                if (spra != 6) break;
                newPAP._numrm = varParam;
                break;
            }
            case 71: {
                newPAP._fUsePgsuSettings = (byte)param;
                break;
            }
            case 72: {
                newPAP._fAdjustRight = (byte)param;
                break;
            }
        }
    }

    static void doTAPOperation(TAP newTAP, int operand, int param, byte[] varParam) {
        switch (operand) {
            case 0: {
                newTAP._jc = (short)param;
                break;
            }
            case 1: {
                int adjust = param - (newTAP._rgdxaCenter[0] + newTAP._dxaGapHalf);
                int x = 0;
                while (x < newTAP._itcMac) {
                    int n = x++;
                    newTAP._rgdxaCenter[n] = (short)(newTAP._rgdxaCenter[n] + adjust);
                }
                break;
            }
            case 2: {
                if (newTAP._rgdxaCenter != null) {
                    int adjust = newTAP._dxaGapHalf - param;
                    newTAP._rgdxaCenter[0] = (short)(newTAP._rgdxaCenter[0] + adjust);
                }
                newTAP._dxaGapHalf = param;
                break;
            }
            case 3: {
                newTAP._fCantSplit = StyleSheet.getFlag(param);
                break;
            }
            case 4: {
                newTAP._fTableHeader = StyleSheet.getFlag(param);
                break;
            }
            case 5: {
                newTAP._brcTop[0] = Utils.convertBytesToShort(varParam, 0);
                newTAP._brcTop[1] = Utils.convertBytesToShort(varParam, 2);
                newTAP._brcLeft[0] = Utils.convertBytesToShort(varParam, 4);
                newTAP._brcLeft[1] = Utils.convertBytesToShort(varParam, 6);
                newTAP._brcBottom[0] = Utils.convertBytesToShort(varParam, 8);
                newTAP._brcBottom[1] = Utils.convertBytesToShort(varParam, 10);
                newTAP._brcRight[0] = Utils.convertBytesToShort(varParam, 12);
                newTAP._brcRight[1] = Utils.convertBytesToShort(varParam, 14);
                newTAP._brcHorizontal[0] = Utils.convertBytesToShort(varParam, 16);
                newTAP._brcHorizontal[1] = Utils.convertBytesToShort(varParam, 18);
                newTAP._brcVertical[0] = Utils.convertBytesToShort(varParam, 20);
                newTAP._brcVertical[1] = Utils.convertBytesToShort(varParam, 22);
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                newTAP._dyaRowHeight = param;
                break;
            }
            case 8: {
                newTAP._itcMac = varParam[0];
                newTAP._rgdxaCenter = new short[varParam[0] + 1];
                newTAP._rgtc = new TC[varParam[0]];
                int x = 0;
                while (x < newTAP._itcMac) {
                    newTAP._rgdxaCenter[x] = Utils.convertBytesToShort(varParam, 1 + x * 2);
                    newTAP._rgtc[x] = TC.convertBytesToTC(varParam, 1 + (varParam[0] + 1) * 2 + x * 20);
                    ++x;
                }
                newTAP._rgdxaCenter[newTAP._itcMac] = Utils.convertBytesToShort(varParam, 1 + newTAP._itcMac * 2);
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 32: {
                int x = varParam[0];
                while (x < varParam[1]) {
                    if ((varParam[2] & 8) > 0) {
                        newTAP._rgtc[x]._brcRight[0] = Utils.convertBytesToShort(varParam, 6);
                        newTAP._rgtc[x]._brcRight[1] = Utils.convertBytesToShort(varParam, 8);
                    } else if ((varParam[2] & 4) > 0) {
                        newTAP._rgtc[x]._brcBottom[0] = Utils.convertBytesToShort(varParam, 6);
                        newTAP._rgtc[x]._brcBottom[1] = Utils.convertBytesToShort(varParam, 8);
                    } else if ((varParam[2] & 2) > 0) {
                        newTAP._rgtc[x]._brcLeft[0] = Utils.convertBytesToShort(varParam, 6);
                        newTAP._rgtc[x]._brcLeft[1] = Utils.convertBytesToShort(varParam, 8);
                    } else if ((varParam[2] & 1) > 0) {
                        newTAP._rgtc[x]._brcTop[0] = Utils.convertBytesToShort(varParam, 6);
                        newTAP._rgtc[x]._brcTop[1] = Utils.convertBytesToShort(varParam, 8);
                    }
                    ++x;
                }
                break;
            }
            case 33: {
                int index = (param & 0xFF000000) >> 24;
                int count = (param & 0xFF0000) >> 16;
                int width = param & 0xFFFF;
                short[] rgdxaCenter = new short[newTAP._itcMac + count + 1];
                TC[] rgtc = new TC[newTAP._itcMac + count];
                if (index >= newTAP._itcMac) {
                    index = newTAP._itcMac;
                    System.arraycopy(newTAP._rgdxaCenter, 0, rgdxaCenter, 0, newTAP._itcMac + 1);
                    System.arraycopy(newTAP._rgtc, 0, rgtc, 0, newTAP._itcMac);
                } else {
                    System.arraycopy(newTAP._rgdxaCenter, 0, rgdxaCenter, 0, index + 1);
                    System.arraycopy(newTAP._rgdxaCenter, index + 1, rgdxaCenter, index + count, newTAP._itcMac - index);
                    System.arraycopy(newTAP._rgtc, 0, rgtc, 0, index);
                    System.arraycopy(newTAP._rgtc, index, rgtc, index + count, newTAP._itcMac - index);
                }
                int x = index;
                while (x < index + count) {
                    rgtc[x] = new TC();
                    rgdxaCenter[x] = (short)(rgdxaCenter[x - 1] + width);
                    ++x;
                }
                rgdxaCenter[index + count] = (short)(rgdxaCenter[index + count - 1] + width);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                break;
            }
        }
    }

    static void doSEPOperation(SEP newSEP, int operand, int param, byte[] varParam) {
        switch (operand) {
            case 0: {
                newSEP._cnsPgn = (byte)param;
                break;
            }
            case 1: {
                newSEP._iHeadingPgn = (byte)param;
                break;
            }
            case 2: {
                newSEP._olstAnn = varParam;
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                newSEP._fEvenlySpaced = StyleSheet.getFlag(param);
                break;
            }
            case 6: {
                newSEP._fUnlocked = StyleSheet.getFlag(param);
                break;
            }
            case 7: {
                newSEP._dmBinFirst = (short)param;
                break;
            }
            case 8: {
                newSEP._dmBinOther = (short)param;
                break;
            }
            case 9: {
                newSEP._bkc = (byte)param;
                break;
            }
            case 10: {
                newSEP._fTitlePage = StyleSheet.getFlag(param);
                break;
            }
            case 11: {
                newSEP._ccolM1 = (short)param;
                break;
            }
            case 12: {
                newSEP._dxaColumns = param;
                break;
            }
            case 13: {
                newSEP._fAutoPgn = StyleSheet.getFlag(param);
                break;
            }
            case 14: {
                newSEP._nfcPgn = (byte)param;
                break;
            }
            case 15: {
                newSEP._dyaPgn = (short)param;
                break;
            }
            case 16: {
                newSEP._dxaPgn = (short)param;
                break;
            }
            case 17: {
                newSEP._fPgnRestart = StyleSheet.getFlag(param);
                break;
            }
            case 18: {
                newSEP._fEndNote = StyleSheet.getFlag(param);
                break;
            }
            case 19: {
                newSEP._lnc = (byte)param;
                break;
            }
            case 20: {
                newSEP._grpfIhdt = (byte)param;
                break;
            }
            case 21: {
                newSEP._nLnnMod = (short)param;
                break;
            }
            case 22: {
                newSEP._dxaLnn = param;
                break;
            }
            case 23: {
                newSEP._dyaHdrTop = param;
                break;
            }
            case 24: {
                newSEP._dyaHdrBottom = param;
                break;
            }
            case 25: {
                newSEP._fLBetween = StyleSheet.getFlag(param);
                break;
            }
            case 26: {
                newSEP._vjc = (byte)param;
                break;
            }
            case 27: {
                newSEP._lnnMin = (short)param;
                break;
            }
            case 28: {
                newSEP._pgnStart = (short)param;
                break;
            }
            case 29: {
                newSEP._dmOrientPage = (byte)param;
                break;
            }
            case 30: {
                break;
            }
            case 31: {
                newSEP._xaPage = param;
                break;
            }
            case 32: {
                newSEP._yaPage = param;
                break;
            }
            case 33: {
                newSEP._dxaLeft = param;
                break;
            }
            case 34: {
                newSEP._dxaRight = param;
                break;
            }
            case 35: {
                newSEP._dyaTop = param;
                break;
            }
            case 36: {
                newSEP._dyaBottom = param;
                break;
            }
            case 37: {
                newSEP._dzaGutter = param;
                break;
            }
            case 38: {
                newSEP._dmPaperReq = (short)param;
                break;
            }
            case 39: {
                newSEP._fPropMark = StyleSheet.getFlag(varParam[0]);
                break;
            }
            case 40: {
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                break;
            }
            case 43: {
                newSEP._brcTop[0] = (short)(param & 0xFFFF);
                newSEP._brcTop[1] = (short)((param & 0xFFFF0000) >> 16);
                break;
            }
            case 44: {
                newSEP._brcLeft[0] = (short)(param & 0xFFFF);
                newSEP._brcLeft[1] = (short)((param & 0xFFFF0000) >> 16);
                break;
            }
            case 45: {
                newSEP._brcBottom[0] = (short)(param & 0xFFFF);
                newSEP._brcBottom[1] = (short)((param & 0xFFFF0000) >> 16);
                break;
            }
            case 46: {
                newSEP._brcRight[0] = (short)(param & 0xFFFF);
                newSEP._brcRight[1] = (short)((param & 0xFFFF0000) >> 16);
                break;
            }
            case 47: {
                newSEP._pgbProp = (short)param;
                break;
            }
            case 48: {
                newSEP._dxtCharSpace = param;
                break;
            }
            case 49: {
                newSEP._dyaLinePitch = param;
                break;
            }
            case 51: {
                newSEP._wTextFlow = (short)param;
                break;
            }
        }
    }

    private static boolean getCHPFlag(byte x, boolean oldVal) {
        switch (x) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case -128: {
                return oldVal;
            }
            case -127: {
                return !oldVal;
            }
        }
        return false;
    }

    public static boolean getFlag(int x) {
        return x != 0;
    }
}

