/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.extractor;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.POIDocument;
import org.apache.poi.POIOLE2TextExtractor;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.hwpf.converter.WordToTextConverter;
import org.apache.poi.hwpf.usermodel.HeaderStories;
import org.apache.poi.hwpf.usermodel.Paragraph;
import org.apache.poi.hwpf.usermodel.Range;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class WordExtractor
extends POIOLE2TextExtractor {
    private HWPFDocument doc;

    public WordExtractor(InputStream is) throws IOException {
        this(HWPFDocument.verifyAndBuildPOIFS(is));
    }

    public WordExtractor(POIFSFileSystem fs) throws IOException {
        this(new HWPFDocument(fs));
    }

    public WordExtractor(DirectoryNode dir, POIFSFileSystem fs) throws IOException {
        this(dir);
    }

    public WordExtractor(DirectoryNode dir) throws IOException {
        this(new HWPFDocument(dir));
    }

    public WordExtractor(HWPFDocument doc) {
        super((POIDocument)doc);
        this.doc = doc;
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Use:");
            System.err.println("   java org.apache.poi.hwpf.extractor.WordExtractor <filename>");
            System.exit(1);
        }
        FileInputStream fin = new FileInputStream(args[0]);
        WordExtractor extractor = new WordExtractor(fin);
        System.out.println(extractor.getText());
    }

    public String[] getParagraphText() {
        String[] ret;
        try {
            Range r = this.doc.getRange();
            ret = WordExtractor.getParagraphText(r);
        }
        catch (Exception e) {
            ret = new String[]{this.getTextFromPieces()};
        }
        return ret;
    }

    public String[] getFootnoteText() {
        Range r = this.doc.getFootnoteRange();
        return WordExtractor.getParagraphText(r);
    }

    public String[] getMainTextboxText() {
        Range r = this.doc.getMainTextboxRange();
        return WordExtractor.getParagraphText(r);
    }

    public String[] getEndnoteText() {
        Range r = this.doc.getEndnoteRange();
        return WordExtractor.getParagraphText(r);
    }

    public String[] getCommentsText() {
        Range r = this.doc.getCommentsRange();
        return WordExtractor.getParagraphText(r);
    }

    protected static String[] getParagraphText(Range r) {
        String[] ret = new String[r.numParagraphs()];
        int i = 0;
        while (i < ret.length) {
            Paragraph p = r.getParagraph(i);
            ret[i] = p.text();
            if (ret[i].endsWith("\r")) {
                ret[i] = String.valueOf(ret[i]) + "\n";
            }
            ++i;
        }
        return ret;
    }

    private void appendHeaderFooter(String text, StringBuffer out) {
        if (text == null || text.length() == 0) {
            return;
        }
        if (!(text = text.replace('\r', '\n')).endsWith("\n")) {
            out.append(text);
            out.append('\n');
            return;
        }
        if (text.endsWith("\n\n")) {
            out.append(text.substring(0, text.length() - 1));
            return;
        }
        out.append(text);
    }

    public String getHeaderText() {
        HeaderStories hs = new HeaderStories(this.doc);
        StringBuffer ret = new StringBuffer();
        if (hs.getFirstHeader() != null) {
            this.appendHeaderFooter(hs.getFirstHeader(), ret);
        }
        if (hs.getEvenHeader() != null) {
            this.appendHeaderFooter(hs.getEvenHeader(), ret);
        }
        if (hs.getOddHeader() != null) {
            this.appendHeaderFooter(hs.getOddHeader(), ret);
        }
        return ret.toString();
    }

    public String getFooterText() {
        HeaderStories hs = new HeaderStories(this.doc);
        StringBuffer ret = new StringBuffer();
        if (hs.getFirstFooter() != null) {
            this.appendHeaderFooter(hs.getFirstFooter(), ret);
        }
        if (hs.getEvenFooter() != null) {
            this.appendHeaderFooter(hs.getEvenFooter(), ret);
        }
        if (hs.getOddFooter() != null) {
            this.appendHeaderFooter(hs.getOddFooter(), ret);
        }
        return ret.toString();
    }

    public String getTextFromPieces() {
        String text = this.doc.getDocumentText();
        text = text.replaceAll("\r\r\r", "\r\n\r\n\r\n");
        if ((text = text.replaceAll("\r\r", "\r\n\r\n")).endsWith("\r")) {
            text = String.valueOf(text) + "\n";
        }
        return text;
    }

    public String getText() {
        try {
            WordToTextConverter wordToTextConverter = new WordToTextConverter();
            HeaderStories hs = new HeaderStories(this.doc);
            if (hs.getFirstHeaderSubrange() != null) {
                wordToTextConverter.processDocumentPart(this.doc, hs.getFirstHeaderSubrange());
            }
            if (hs.getEvenHeaderSubrange() != null) {
                wordToTextConverter.processDocumentPart(this.doc, hs.getEvenHeaderSubrange());
            }
            if (hs.getOddHeaderSubrange() != null) {
                wordToTextConverter.processDocumentPart(this.doc, hs.getOddHeaderSubrange());
            }
            wordToTextConverter.processDocument(this.doc);
            wordToTextConverter.processDocumentPart(this.doc, this.doc.getMainTextboxRange());
            if (hs.getFirstFooterSubrange() != null) {
                wordToTextConverter.processDocumentPart(this.doc, hs.getFirstFooterSubrange());
            }
            if (hs.getEvenFooterSubrange() != null) {
                wordToTextConverter.processDocumentPart(this.doc, hs.getEvenFooterSubrange());
            }
            if (hs.getOddFooterSubrange() != null) {
                wordToTextConverter.processDocumentPart(this.doc, hs.getOddFooterSubrange());
            }
            return wordToTextConverter.getText();
        }
        catch (Exception exc) {
            throw new RuntimeException(exc);
        }
    }

    public static String stripFields(String text) {
        return Range.stripFields(text);
    }
}

