/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;

public final class EscherRecordHolder {
    private final ArrayList escherRecords = new ArrayList();

    public EscherRecordHolder() {
    }

    public EscherRecordHolder(byte[] data, int offset, int size) {
        this();
        this.fillEscherRecords(data, offset, size);
    }

    private void fillEscherRecords(byte[] data, int offset, int size) {
        DefaultEscherRecordFactory recordFactory = new DefaultEscherRecordFactory();
        int pos = offset;
        while (pos < offset + size) {
            EscherRecord r = recordFactory.createRecord(data, pos);
            this.escherRecords.add(r);
            int bytesRead = r.fillFields(data, pos, (EscherRecordFactory)recordFactory);
            pos += bytesRead + 1;
        }
    }

    public List getEscherRecords() {
        return this.escherRecords;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.escherRecords.size() == 0) {
            buffer.append("No Escher Records Decoded").append("\n");
        }
        Iterator iterator = this.escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            buffer.append(r.toString());
        }
        return buffer.toString();
    }

    public EscherContainerRecord getEscherContainer() {
        Iterator it = this.escherRecords.iterator();
        while (it.hasNext()) {
            Object er = it.next();
            if (!(er instanceof EscherContainerRecord)) continue;
            return (EscherContainerRecord)er;
        }
        return null;
    }

    public EscherRecord findFirstWithId(short id) {
        return EscherRecordHolder.findFirstWithId(id, this.getEscherRecords());
    }

    private static EscherRecord findFirstWithId(short id, List records) {
        EscherRecord r;
        Iterator it = records.iterator();
        while (it.hasNext()) {
            r = (EscherRecord)it.next();
            if (r.getRecordId() != id) continue;
            return r;
        }
        it = records.iterator();
        while (it.hasNext()) {
            EscherRecord found;
            r = (EscherRecord)it.next();
            if (!r.isContainerRecord() || (found = EscherRecordHolder.findFirstWithId(id, r.getChildRecords())) == null) continue;
            return found;
        }
        return null;
    }

    public List getDgContainers() {
        ArrayList<EscherContainerRecord> dgContainers = new ArrayList<EscherContainerRecord>(1);
        Iterator iterator = this.getEscherRecords().iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (escherRecord.getRecordId() != -4094) continue;
            dgContainers.add((EscherContainerRecord)escherRecord);
        }
        return dgContainers;
    }

    public List getDggContainers() {
        ArrayList<EscherContainerRecord> dggContainers = new ArrayList<EscherContainerRecord>(1);
        Iterator iterator = this.getEscherRecords().iterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = (EscherRecord)iterator.next();
            if (escherRecord.getRecordId() != -4096) continue;
            dggContainers.add((EscherContainerRecord)escherRecord);
        }
        return dggContainers;
    }

    public List getBStoreContainers() {
        ArrayList<EscherContainerRecord> bStoreContainers = new ArrayList<EscherContainerRecord>(1);
        Iterator iterator = this.getDggContainers().iterator();
        while (iterator.hasNext()) {
            EscherContainerRecord dggContainer = (EscherContainerRecord)iterator.next();
            Iterator iterator2 = dggContainer.getChildRecords().iterator();
            while (iterator2.hasNext()) {
                EscherRecord escherRecord = (EscherRecord)iterator2.next();
                if (escherRecord.getRecordId() != -4095) continue;
                bStoreContainers.add((EscherContainerRecord)escherRecord);
            }
        }
        return bStoreContainers;
    }

    public List getSpgrContainers() {
        ArrayList<EscherContainerRecord> spgrContainers = new ArrayList<EscherContainerRecord>(1);
        Iterator iterator = this.getDgContainers().iterator();
        while (iterator.hasNext()) {
            EscherContainerRecord dgContainer = (EscherContainerRecord)iterator.next();
            Iterator iterator2 = dgContainer.getChildRecords().iterator();
            while (iterator2.hasNext()) {
                EscherRecord escherRecord = (EscherRecord)iterator2.next();
                if (escherRecord.getRecordId() != -4093) continue;
                spgrContainers.add((EscherContainerRecord)escherRecord);
            }
        }
        return spgrContainers;
    }

    public List getSpContainers() {
        ArrayList<EscherContainerRecord> spContainers = new ArrayList<EscherContainerRecord>(1);
        Iterator iterator = this.getSpgrContainers().iterator();
        while (iterator.hasNext()) {
            EscherContainerRecord spgrContainer = (EscherContainerRecord)iterator.next();
            Iterator iterator2 = spgrContainer.getChildRecords().iterator();
            while (iterator2.hasNext()) {
                EscherRecord escherRecord = (EscherRecord)iterator2.next();
                if (escherRecord.getRecordId() != -4092) continue;
                spContainers.add((EscherContainerRecord)escherRecord);
            }
        }
        return spContainers;
    }
}

