/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hwpf.model.FieldsDocumentPart;
import org.apache.poi.hwpf.model.FileInformationBlock;
import org.apache.poi.hwpf.model.GenericPropertyNode;
import org.apache.poi.hwpf.model.PlexOfCps;
import org.apache.poi.hwpf.model.PlexOfField;
import org.apache.poi.hwpf.model.io.HWPFOutputStream;

public class FieldsTables {
    private static final int FLD_SIZE = 2;
    public static final int PLCFFLDATN = 0;
    public static final int PLCFFLDEDN = 1;
    public static final int PLCFFLDFTN = 2;
    public static final int PLCFFLDHDR = 3;
    public static final int PLCFFLDHDRTXBX = 4;
    public static final int PLCFFLDMOM = 5;
    public static final int PLCFFLDTXBX = 6;
    private Map _tables = new HashMap(FieldsDocumentPart.values().length);

    private static ArrayList toArrayList(PlexOfCps plexOfCps) {
        if (plexOfCps == null) {
            return new ArrayList();
        }
        ArrayList<PlexOfField> fields = new ArrayList<PlexOfField>(plexOfCps.length());
        int i = 0;
        while (i < plexOfCps.length()) {
            GenericPropertyNode propNode = plexOfCps.getProperty(i);
            PlexOfField plex = new PlexOfField(propNode);
            fields.add(plex);
            ++i;
        }
        return fields;
    }

    public FieldsTables(byte[] tableStream, FileInformationBlock fib) {
        int i = 0;
        while (i < FieldsDocumentPart.values().length) {
            FieldsDocumentPart part = FieldsDocumentPart.values()[i];
            PlexOfCps plexOfCps = this.readPLCF(tableStream, fib, part);
            this._tables.put(part, plexOfCps);
            ++i;
        }
    }

    public ArrayList getFieldsPLCF(FieldsDocumentPart part) {
        return FieldsTables.toArrayList((PlexOfCps)this._tables.get(part));
    }

    public ArrayList getFieldsPLCF(int partIndex) {
        return this.getFieldsPLCF(FieldsDocumentPart.values()[partIndex]);
    }

    private PlexOfCps readPLCF(byte[] tableStream, FileInformationBlock fib, FieldsDocumentPart documentPart) {
        int start = fib.getFieldsPlcfOffset(documentPart);
        int length = fib.getFieldsPlcfLength(documentPart);
        if (start <= 0 || length <= 0) {
            return null;
        }
        return new PlexOfCps(tableStream, start, length, 2);
    }

    private int savePlex(FileInformationBlock fib, FieldsDocumentPart part, PlexOfCps plexOfCps, HWPFOutputStream outputStream) throws IOException {
        if (plexOfCps == null || plexOfCps.length() == 0) {
            fib.setFieldsPlcfOffset(part, outputStream.getOffset());
            fib.setFieldsPlcfLength(part, 0);
            return 0;
        }
        byte[] data = plexOfCps.toByteArray();
        int start = outputStream.getOffset();
        int length = data.length;
        outputStream.write(data);
        fib.setFieldsPlcfOffset(part, start);
        fib.setFieldsPlcfLength(part, length);
        return length;
    }

    public void write(FileInformationBlock fib, HWPFOutputStream tableStream) throws IOException {
        int i = 0;
        while (i < FieldsDocumentPart.values().length) {
            FieldsDocumentPart part = FieldsDocumentPart.values()[i];
            PlexOfCps plexOfCps = (PlexOfCps)this._tables.get(part);
            this.savePlex(fib, part, plexOfCps, tableStream);
            ++i;
        }
    }
}

