/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.apache.poi.hwpf.model.HDFType;
import org.apache.poi.hwpf.model.StdfBase;
import org.apache.poi.hwpf.model.StdfPost2000;
import org.apache.poi.hwpf.model.UPX;
import org.apache.poi.hwpf.usermodel.CharacterProperties;
import org.apache.poi.hwpf.usermodel.ParagraphProperties;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import poi.support.ArraysUtil;

public final class StyleDescription
implements HDFType {
    private static final POILogger logger;
    private static final int PARAGRAPH_STYLE = 1;
    private static final int CHARACTER_STYLE = 2;
    private static final int TABLE_STYLE = 3;
    private static final int NUMBERING_STYLE = 4;
    private int _baseLength;
    private StdfBase _stdfBase;
    private StdfPost2000 _stdfPost2000;
    UPX[] _upxs;
    String _name;
    ParagraphProperties _pap;
    CharacterProperties _chp;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.poi.hwpf.model.StyleDescription");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = POILogFactory.getLogger((Class)clazz);
    }

    public StyleDescription() {
    }

    public StyleDescription(byte[] std, int baseLength, int offset, boolean word9) {
        int grupxStart;
        this._baseLength = baseLength;
        int nameStart = offset + baseLength;
        boolean readStdfPost2000 = false;
        if (baseLength == 18) {
            readStdfPost2000 = true;
        } else if (baseLength == 10) {
            readStdfPost2000 = false;
        } else {
            logger.log(POILogger.WARN, (Object)"Style definition has non-standard size of ", (Object)new Integer(baseLength));
        }
        this._stdfBase = new StdfBase(std, offset);
        offset += StdfBase.getSize();
        if (readStdfPost2000) {
            this._stdfPost2000 = new StdfPost2000(std, offset);
            offset += StdfPost2000.getSize();
        }
        short nameLength = 0;
        int multiplier = 1;
        if (word9) {
            nameLength = LittleEndian.getShort((byte[])std, (int)nameStart);
            multiplier = 2;
            nameStart += 2;
        } else {
            nameLength = std[nameStart];
        }
        try {
            this._name = new String(std, nameStart, nameLength * multiplier, "UTF-16LE");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        int varOffset = grupxStart = (nameLength + 1) * multiplier + nameStart;
        int countOfUPX = this._stdfBase.getCupx();
        this._upxs = new UPX[countOfUPX];
        int x = 0;
        while (x < countOfUPX) {
            short upxSize = LittleEndian.getShort((byte[])std, (int)varOffset);
            byte[] upx = new byte[upxSize];
            System.arraycopy(std, varOffset += 2, upx, 0, upxSize);
            this._upxs[x] = new UPX(upx);
            varOffset += upxSize;
            if (upxSize % 2 == 1) {
                ++varOffset;
            }
            ++x;
        }
    }

    public int getBaseStyle() {
        return this._stdfBase.getIstdBase();
    }

    public byte[] getCHPX() {
        switch (this._stdfBase.getStk()) {
            case 1: {
                if (this._upxs.length > 1) {
                    return this._upxs[1].getUPX();
                }
                return null;
            }
            case 2: {
                return this._upxs[0].getUPX();
            }
        }
        return null;
    }

    public byte[] getPAPX() {
        switch (this._stdfBase.getStk()) {
            case 1: {
                return this._upxs[0].getUPX();
            }
        }
        return null;
    }

    public ParagraphProperties getPAP() {
        return this._pap;
    }

    public CharacterProperties getCHP() {
        return this._chp;
    }

    void setPAP(ParagraphProperties pap) {
        this._pap = pap;
    }

    void setCHP(CharacterProperties chp) {
        this._chp = chp;
    }

    public String getName() {
        return this._name;
    }

    public byte[] toByteArray() {
        int size = this._baseLength + 2 + (this._name.length() + 1) * 2;
        size += this._upxs[0].size() + 2;
        int x = 1;
        while (x < this._upxs.length) {
            size += this._upxs[x - 1].size() % 2;
            size += this._upxs[x].size() + 2;
            ++x;
        }
        byte[] buf = new byte[size];
        this._stdfBase.serialize(buf, 0);
        int offset = this._baseLength;
        char[] letters = this._name.toCharArray();
        LittleEndian.putShort((byte[])buf, (int)this._baseLength, (short)((short)letters.length));
        offset += 2;
        int x2 = 0;
        while (x2 < letters.length) {
            LittleEndian.putShort((byte[])buf, (int)offset, (short)((short)letters[x2]));
            offset += 2;
            ++x2;
        }
        offset += 2;
        x2 = 0;
        while (x2 < this._upxs.length) {
            short upxSize = (short)this._upxs[x2].size();
            LittleEndian.putShort((byte[])buf, (int)offset, (short)upxSize);
            System.arraycopy(this._upxs[x2].getUPX(), 0, buf, offset += 2, upxSize);
            offset += upxSize + upxSize % 2;
            ++x2;
        }
        return buf;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
        result = 31 * result + (this._stdfBase == null ? 0 : this._stdfBase.hashCode());
        result = 31 * result + ArraysUtil.getHashCode(this._upxs);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StyleDescription other = (StyleDescription)obj;
        if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
            return false;
        }
        if (this._stdfBase == null ? other._stdfBase != null : !this._stdfBase.equals(other._stdfBase)) {
            return false;
        }
        return Arrays.equals(this._upxs, other._upxs);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[STD]: '");
        result.append(this._name);
        result.append("'");
        result.append(("\nStdfBase:\t" + this._stdfBase).replaceAll("\n", "\n    "));
        result.append(("\nStdfPost2000:\t" + this._stdfPost2000).replaceAll("\n", "\n    "));
        int i = 0;
        while (i < this._upxs.length) {
            UPX upx = this._upxs[i];
            result.append(("\nUPX:\t" + upx).replaceAll("\n", "\n    "));
            ++i;
        }
        return result.toString();
    }
}

